/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.form.project.FormClassLoader;
import org.netbeans.modules.form.project.ProjectClassLoader;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassPathUtils {
    private static Map loaders = new WeakHashMap();
    static final int UNSPECIFIED_CLASS = 0;
    static final int SYSTEM_CLASS = 1;
    static final int SYSTEM_CLASS_WITH_PROJECT = 2;
    private static FileObject patternSystemFolder;
    private static FileObject patternSystemWithProjectFolder;
    private static List patternsSystem;
    private static List patternsSystemWithProject;
    private static final String CL_LAYER_BASE = "org-netbeans-modules-form/classloader/";
    private static final String CL_SYSTEM_CLASS = "system";
    private static final String CL_SYSTEM_CLASS_WITH_PROJECT = "system_with_project";

    public static Class loadClass(String string, FileObject fileObject) throws ClassNotFoundException {
        return Class.forName(string, true, ClassPathUtils.getFormClassLoader(fileObject));
    }

    public static boolean checkUserClass(String string, FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        if (classPath == null) {
            return false;
        }
        String string2 = string.replace('.', '/').concat(".class");
        return classPath.findResource(string2) != null;
    }

    private static FormClassLoader getFormClassLoader(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FormClassLoader formClassLoader = (FormClassLoader)loaders.get(project);
        ClassLoader classLoader = formClassLoader != null ? formClassLoader.getProjectClassLoader() : null;
        ClassLoader classLoader2 = ProjectClassLoader.getUpToDateClassLoader(fileObject, classLoader);
        if (formClassLoader == null || classLoader2 != classLoader) {
            formClassLoader = new FormClassLoader(classLoader2);
            loaders.put(project, formClassLoader);
        }
        return formClassLoader;
    }

    static int getClassLoadingType(String string) {
        int n = string.lastIndexOf("[L");
        if (n != -1) {
            string = string.substring(n + 2, string.length() - 1);
        }
        if (ClassPathUtils.isClassLoaderType(string, 1)) {
            return 1;
        }
        if (ClassPathUtils.isClassLoaderType(string, 2)) {
            return 2;
        }
        return 0;
    }

    public static Class loadClass(ClassSource classSource) throws ClassNotFoundException {
        String string = classSource.getClassName();
        if (string == null) {
            return null;
        }
        ClassLoader classLoader = null;
        int n = classSource.getCPRootCount();
        if (n == 0) {
            classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        } else {
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    File file;
                    String string2 = classSource.getCPRootType(i);
                    String string3 = classSource.getCPRootName(i);
                    if ("jar".equals(string2)) {
                        file = new File(string3);
                        arrayList.add(FileUtil.getArchiveRoot((URL)file.toURI().toURL()));
                        continue;
                    }
                    if ("library".equals(string2)) {
                        file = LibraryManager.getDefault().getLibrary(string3);
                        if (file == null) continue;
                        object = file.getContent("classpath");
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            URL uRL = (URL)iterator.next();
                            if (FileUtil.isArchiveFile((URL)uRL)) {
                                uRL = FileUtil.getArchiveRoot((URL)uRL);
                            }
                            arrayList.add(uRL);
                        }
                        continue;
                    }
                    if (!"project".equals(string2)) continue;
                    file = new File(string3);
                    object = FileUtil.getArchiveRoot((URL)file.toURI().toURL());
                    if (FileUtil.isArchiveFile((URL)object)) {
                        object = FileUtil.getArchiveRoot((URL)object);
                    }
                    arrayList.add(object);
                }
                if (arrayList.size() <= 0) {
                    return null;
                }
                URL[] uRLArray = new URL[arrayList.size()];
                arrayList.toArray(uRLArray);
                classLoader = ClassPathSupport.createClassPath((URL[])uRLArray).getClassLoader(true);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)exception);
                throw illegalArgumentException;
            }
        }
        return classLoader.loadClass(classSource.getClassName());
    }

    public static ClassSource getProjectClassSource(FileObject fileObject, String string) {
        File file;
        int n;
        URI[] uRIArray;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        if (antArtifactArray.length == 0) {
            return null;
        }
        String[] stringArray = null;
        block2: for (int i = 0; i < antArtifactArray.length; ++i) {
            URI uRI = antArtifactArray[i].getScriptLocation().toURI();
            uRIArray = antArtifactArray[i].getArtifactLocations();
            for (n = 0; n < uRIArray.length; ++n) {
                URL uRL;
                file = new File(uRI.resolve(uRIArray[n]).normalize());
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                }
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                for (int j = 0; j < fileObjectArray.length; ++j) {
                    if (!FileUtil.isParentOf((FileObject)fileObjectArray[j], (FileObject)fileObject)) continue;
                    stringArray = new String[]{file.getAbsolutePath()};
                    break;
                }
                if (stringArray != null) continue block2;
            }
        }
        if (stringArray == null) {
            if (!fileObject.getExt().equals("class")) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(antArtifactArray.length);
            for (int i = 0; i < antArtifactArray.length; ++i) {
                uRIArray = antArtifactArray[i].getArtifactLocations();
                for (n = 0; n < uRIArray.length; ++n) {
                    file = new File(antArtifactArray[i].getScriptLocation().getParent() + File.separator + uRIArray[n].getPath());
                    arrayList.add(file.getAbsolutePath());
                }
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = "project";
        }
        return new ClassSource(string, stringArray2, stringArray);
    }

    public static boolean updateProject(FileObject fileObject, ClassSource classSource) throws IOException {
        if (classSource.getCPRootCount() == 0) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (projectClassPathExtender == null) {
            return false;
        }
        int n = classSource.getCPRootCount();
        for (int i = 0; i < n; ++i) {
            AntArtifact antArtifact;
            Object object;
            String string = classSource.getCPRootType(i);
            String string2 = classSource.getCPRootName(i);
            if ("jar".equals(string)) {
                object = FileUtil.toFileObject((File)new File(string2));
                projectClassPathExtender.addArchiveFile(object);
                continue;
            }
            if ("library".equals(string)) {
                object = LibraryManager.getDefault().getLibrary(string2);
                projectClassPathExtender.addLibrary((Library)object);
                continue;
            }
            if (!"project".equals(string) || (antArtifact = AntArtifactQuery.findArtifactFromFile((File)(object = new File(string2)))).getProject() == project) continue;
            URI[] uRIArray = antArtifact.getArtifactLocations();
            for (int j = 0; j < uRIArray.length; ++j) {
                projectClassPathExtender.addAntArtifact(antArtifact, uRIArray[j]);
            }
        }
        return true;
    }

    public static String getClassSourceDescription(ClassSource classSource) {
        if (classSource == null || classSource.getCPRootCount() == 0) {
            String string = classSource.getClassName();
            if (string != null) {
                if (string.startsWith("javax.") || string.startsWith("java.")) {
                    return ClassPathUtils.getBundleString("MSG_StandardJDKSource");
                }
                if (string.startsWith("org.netbeans.")) {
                    return ClassPathUtils.getBundleString("MSG_NetBeansSource");
                }
            }
        } else {
            String string = classSource.getCPRootType(0);
            String string2 = classSource.getCPRootName(0);
            if ("jar".equals(string)) {
                return MessageFormat.format(ClassPathUtils.getBundleString("FMT_JarSource"), string2);
            }
            if ("library".equals(string)) {
                Library library = LibraryManager.getDefault().getLibrary(string2);
                return MessageFormat.format(ClassPathUtils.getBundleString("FMT_LibrarySource"), library != null ? library.getDisplayName() : string2);
            }
            if ("project".equals(string)) {
                try {
                    Project project = FileOwnerQuery.getOwner((URI)new File(string2).toURI());
                    return MessageFormat.format(ClassPathUtils.getBundleString("FMT_ProjectSource"), project == null ? string2 : project.getProjectDirectory().getPath().replace('/', File.separatorChar));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ClassPathUtils.getBundleString("MSG_UnspecifiedSource");
    }

    static String getBundleString(String string) {
        return NbBundle.getBundle((Class)ClassPathUtils.class).getString(string);
    }

    private static boolean isClassLoaderType(String string, int n) {
        List list = ClassPathUtils.getClassPatterns(n);
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassPattern classPattern = (ClassPattern)iterator.next();
            switch (classPattern.type) {
                case 0: {
                    if (!string.equals(classPattern.name)) break;
                    return true;
                }
                case 1: {
                    if (!string.startsWith(classPattern.name) || string.lastIndexOf(46) > classPattern.name.length()) break;
                    return true;
                }
                case 2: {
                    if (!string.startsWith(classPattern.name)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static List getClassPatterns(int n) {
        List list = null;
        switch (n) {
            case 1: {
                list = patternsSystem;
                if (list != null) break;
                patternsSystem = list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(n));
                break;
            }
            case 2: {
                list = patternsSystemWithProject;
                if (list != null) break;
                patternsSystemWithProject = list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(n));
            }
        }
        return list;
    }

    private static FileObject getClassPatternsFolder(int n) {
        FileObject fileObject = null;
        switch (n) {
            case 1: {
                fileObject = patternSystemFolder;
                if (fileObject != null) break;
                fileObject = ClassPathUtils.getClassPatternsFolder(CL_SYSTEM_CLASS);
                if (fileObject == null) {
                    return null;
                }
                fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fileEvent) {
                        patternsSystem = null;
                        loaders.clear();
                    }

                    public void fileDeleted(FileEvent fileEvent) {
                        patternsSystem = null;
                        if (fileEvent.getFile() == patternSystemFolder) {
                            patternSystemFolder.removeFileChangeListener((FileChangeListener)this);
                            patternSystemFolder = null;
                        }
                        loaders.clear();
                    }
                });
                patternSystemFolder = fileObject;
                break;
            }
            case 2: {
                fileObject = patternSystemWithProjectFolder;
                if (fileObject != null) break;
                fileObject = ClassPathUtils.getClassPatternsFolder(CL_SYSTEM_CLASS_WITH_PROJECT);
                if (fileObject == null) {
                    return null;
                }
                fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fileEvent) {
                        patternsSystemWithProject = null;
                        loaders.clear();
                    }

                    public void fileDeleted(FileEvent fileEvent) {
                        patternsSystemWithProject = null;
                        if (fileEvent.getFile() == patternSystemFolder) {
                            patternSystemWithProjectFolder.removeFileChangeListener((FileChangeListener)this);
                            patternSystemWithProjectFolder = null;
                        }
                        loaders.clear();
                    }
                });
                patternSystemWithProjectFolder = fileObject;
            }
        }
        return fileObject;
    }

    private static FileObject getClassPatternsFolder(String string) {
        FileObject fileObject = null;
        if (string != null) {
            try {
                fileObject = Repository.getDefault().getDefaultFileSystem().findResource(CL_LAYER_BASE + string);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return fileObject;
    }

    private static List loadClassPatterns(FileObject fileObject) {
        ArrayList<ClassPattern> arrayList = new ArrayList<ClassPattern>();
        if (fileObject == null) {
            return arrayList;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObjectArray[i].getInputStream()));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!string.equals("")) {
                        ClassPattern classPattern = string.endsWith("**") ? new ClassPattern(string.substring(0, string.length() - 2), 2) : (string.endsWith("*") ? new ClassPattern(string.substring(0, string.length() - 1), 1) : new ClassPattern(string, 0));
                        arrayList.add(classPattern);
                    }
                    string = bufferedReader.readLine();
                }
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return arrayList;
    }

    private static class ClassPattern {
        static final int CLASS = 0;
        static final int PACKAGE = 1;
        static final int PACKAGE_AND_SUBPACKAGES = 2;
        String name;
        int type;

        ClassPattern(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }
}

