/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.netbeans.modules.xml.catalog.impl.sun.Util;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Catalog
implements CatalogReader,
CatalogDescriptor,
Serializable,
EntityResolver {
    private static final long serialVersionUID = 123659121L;
    private transient PropertyChangeSupport pchs;
    private transient EntityResolver peer;
    private transient String desc;
    private String location;
    private boolean preference = true;
    private static final String PROP_LOCATION = "cat-loc";
    private static final String PROP_PREF_PUBLIC = "cat-pref";
    private static final String PROP_DESC = "ca-desc";

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setShortDescription(Util.THIS.getString("MSG_prepared", this.location));
    }

    public synchronized void setLocation(String string) {
        String string2 = this.location;
        this.location = string;
        this.peer = null;
        this.getPCHS().firePropertyChange(PROP_LOCATION, string2, string);
        this.updateDisplayName();
    }

    public String getLocation() {
        return this.location;
    }

    public void setPreferPublic(boolean bl) {
        boolean bl2 = this.preference;
        this.preference = bl;
        this.getPCHS().firePropertyChange(PROP_LOCATION, bl2, bl);
    }

    public boolean isPreferPublic() {
        return this.preference;
    }

    public void addCatalogListener(CatalogListener catalogListener) {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCHS().addPropertyChangeListener(propertyChangeListener);
    }

    public String getDisplayName() {
        String string = this.location;
        if (string == null || "".equals(string.trim())) {
            return Util.THIS.getString("PROP_missing_location");
        }
        return Util.THIS.getString("TITLE_catalog", this.location);
    }

    public String getName() {
        return this.getClass() + this.location + this.preference;
    }

    public void updateDisplayName() {
        String string = this.getDisplayName();
        this.getPCHS().firePropertyChange("ca-name", null, string);
    }

    public Image getIcon(int n) {
        return null;
    }

    public Iterator getPublicIDs() {
        EntityResolver entityResolver = this.getPeer();
        if (entityResolver instanceof CatalogResolver) {
            org.apache.xml.resolver.Catalog catalog = ((CatalogResolver)entityResolver).getCatalog();
            return catalog.getPublicIDs();
        }
        return null;
    }

    public String getShortDescription() {
        return this.desc;
    }

    public void setShortDescription(String string) {
        String string2 = this.desc;
        this.desc = string;
        this.getPCHS().firePropertyChange(PROP_DESC, string2, string);
    }

    public String getSystemID(String string) {
        EntityResolver entityResolver = this.getPeer();
        if (entityResolver instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)entityResolver).getCatalog().resolveSystem(string);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized void refresh() {
        this.peer = this.createPeer(this.location, this.preference);
    }

    public void removeCatalogListener(CatalogListener catalogListener) {
        throw new UnsupportedOperationException();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCHS().removePropertyChangeListener(propertyChangeListener);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.getPeer().resolveEntity(string, string2);
    }

    private EntityResolver createPeer(String string, boolean bl) {
        try {
            CatalogManager catalogManager = new CatalogManager(null);
            catalogManager.setUseStaticCatalog(false);
            catalogManager.setPreferPublic(bl);
            CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
            org.apache.xml.resolver.Catalog catalog = catalogResolver.getCatalog();
            catalog.parseCatalog(new URL(string));
            this.setShortDescription(Util.THIS.getString("DESC_loaded"));
            return catalogResolver;
        }
        catch (IOException iOException) {
            this.setShortDescription(Util.THIS.getString("DESC_error_loading", iOException.getLocalizedMessage()));
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("I/O error loading catalog " + string, iOException);
            }
            return new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return null;
                }
            };
        }
    }

    private synchronized PropertyChangeSupport getPCHS() {
        if (this.pchs == null) {
            this.pchs = new PropertyChangeSupport(this);
        }
        return this.pchs;
    }

    private synchronized EntityResolver getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer(this.location, this.preference);
        }
        return this.peer;
    }

    public String resolveURI(String string) {
        EntityResolver entityResolver = this.getPeer();
        if (entityResolver instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)entityResolver).getCatalog().resolveURI(string);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String resolvePublic(String string) {
        EntityResolver entityResolver = this.getPeer();
        if (entityResolver instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)entityResolver).getCatalog().resolvePublic(string, null);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

