/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.catalog.impl.sun.Catalog;
import org.netbeans.modules.xml.catalog.impl.sun.Util;

public class CatalogCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -1437233290256708364L;
    Catalog model = null;
    private JTextArea descTextArea;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JCheckBox preferCheckBox;
    private JButton selectButton;

    public CatalogCustomizer() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_CatalogCustomizer"));
        this.locationLabel.setDisplayedMnemonic(Util.THIS.getString("CatalogCustomizer.locationLabel.mne").charAt(0));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_locationTextField"));
        this.preferCheckBox.setMnemonic(Util.THIS.getString("MNE_preference").charAt(0));
        this.preferCheckBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_preference"));
        this.selectButton.setMnemonic(Util.THIS.getString("MNE_file").charAt(0));
        this.selectButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_file"));
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.selectButton = new JButton();
        this.preferCheckBox = new JCheckBox();
        this.descTextArea = new JTextArea();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setLabelFor(this.locationTextField);
        this.locationLabel.setText(Util.THIS.getString("CatalogCustomizer.locationLabel.text"));
        this.add((Component)this.locationLabel, new GridBagConstraints());
        this.locationTextField.setColumns(40);
        this.locationTextField.addActionListener(formListener);
        this.locationTextField.addFocusListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.locationTextField, gridBagConstraints);
        this.selectButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/Bundle").getString("PROP_choose_file"));
        this.selectButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.selectButton, gridBagConstraints);
        this.preferCheckBox.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/Bundle").getString("LBL_preference"));
        this.preferCheckBox.setToolTipText(Util.THIS.getString("HINT_pp"));
        this.preferCheckBox.addChangeListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.preferCheckBox, gridBagConstraints);
        this.descTextArea.setColumns(40);
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(4);
        this.descTextArea.setText(Util.THIS.getString("DESC_catalog_fmts"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        File file = org.netbeans.modules.xml.catalog.lib.Util.selectCatalogFile("txt xml cat catalog");
        if (file == null) {
            return;
        }
        try {
            String string = file.toURL().toExternalForm();
            this.locationTextField.setText(string);
            this.model.setLocation(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void preferCheckBoxStateChanged(ChangeEvent changeEvent) {
        if (this.model != null) {
            this.model.setPreferPublic(this.preferCheckBox.isSelected());
        }
    }

    private void locationTextFieldFocusLost(FocusEvent focusEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("FocusLost-setting location: " + this.locationTextField.getText());
        }
        this.model.setLocation(this.locationTextField.getText());
    }

    private void locationTextFieldActionPerformed(ActionEvent actionEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ActionPerformed-setting location: " + this.locationTextField.getText());
        }
        this.model.setLocation(this.locationTextField.getText());
    }

    public void setObject(Object object) {
        if (!(object instanceof Catalog)) {
            throw new IllegalArgumentException("Catalog instance expected (" + object.getClass() + ").");
        }
        this.model = (Catalog)object;
        this.locationTextField.setText(this.model.getLocation());
        this.preferCheckBox.setSelected(this.model.isPreferPublic());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ChangeListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CatalogCustomizer.this.locationTextField) {
                CatalogCustomizer.this.locationTextFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CatalogCustomizer.this.selectButton) {
                CatalogCustomizer.this.selectButtonActionPerformed(actionEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == CatalogCustomizer.this.locationTextField) {
                CatalogCustomizer.this.locationTextFieldFocusLost(focusEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == CatalogCustomizer.this.preferCheckBox) {
                CatalogCustomizer.this.preferCheckBoxStateChanged(changeEvent);
            }
        }
    }
}

