/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nStringEditor;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class FormI18nSupport
extends JavaI18nSupport {
    private static final String RAD_PROPERTIES = "properties";
    private static final String RAD_PROPERTIES2 = "properties2";
    private static final String RAD_ACCESSIBILITY = "accessibility";
    private static final String RAD_LAYOUT = "layout";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$form$FormI18nSupport;
    static /* synthetic */ Class class$org$netbeans$modules$form$FormDataObject;

    private FormI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new FormI18nFinder(this.sourceDataObject, this.document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new FormI18nReplacer((FormI18nFinder)this.getFinder());
    }

    public JPanel getInfo(HardCodedString hardCodedString) {
        return new FormInfoPanel(hardCodedString, this.document);
    }

    public static class Factory
    extends I18nSupport.Factory {
        Factory() {
        }

        public I18nSupport create(DataObject dataObject) throws IOException {
            I18nSupport i18nSupport = super.create(dataObject);
            FormEditorSupport formEditorSupport = ((FormDataObject)dataObject).getFormEditor();
            if (formEditorSupport.isOpened()) {
                return i18nSupport;
            }
            if (formEditorSupport.loadForm()) {
                return i18nSupport;
            }
            throw new IOException("I18N: Loading form for " + dataObject.getName() + " was not succesful.");
        }

        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new FormI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            return class$org$netbeans$modules$form$FormDataObject == null ? (class$org$netbeans$modules$form$FormDataObject = FormI18nSupport.class$("org.netbeans.modules.form.FormDataObject")) : class$org$netbeans$modules$form$FormDataObject;
        }
    }

    private static class FormInfoPanel
    extends InfoPanel {
        public FormInfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
            super(hardCodedString, styledDocument);
        }

        protected void setHardCodedString(HardCodedString hardCodedString, StyledDocument styledDocument) {
            String string;
            this.getStringText().setText(hardCodedString == null ? "" : hardCodedString.getText());
            if (hardCodedString.getStartPosition() == null) {
                string = "";
            } else {
                int n = hardCodedString.getStartPosition().getOffset();
                try {
                    Element element = styledDocument.getParagraphElement(n);
                    string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            }
            this.getFoundInText().setText(string);
            if (hardCodedString instanceof FormHardCodedString) {
                this.getComponentText().setText(((FormHardCodedString)hardCodedString).getValidProperty().getRADComponentName());
                this.getPropertyText().setText(((FormHardCodedString)hardCodedString).getNodeProperty().getName());
            } else {
                this.remove(this.getComponentLabel());
                this.remove(this.getComponentText());
                this.remove(this.getPropertyLabel());
                this.remove(this.getPropertyText());
            }
        }
    }

    private static class FormHardCodedString
    extends HardCodedString {
        private ValidFormProperty validProperty;
        private Node.Property nodeProperty;

        FormHardCodedString(String string, Position position, Position position2, ValidFormProperty validFormProperty, Node.Property property) {
            super(string, position, position2);
            this.validProperty = validFormProperty;
            this.nodeProperty = property;
        }

        public ValidFormProperty getValidProperty() {
            return this.validProperty;
        }

        public Node.Property getNodeProperty() {
            return this.nodeProperty;
        }
    }

    private static class FormI18nReplacer
    extends JavaI18nSupport.JavaI18nReplacer {
        private FormI18nFinder finder;
        private final ResourceBundle bundle;

        public FormI18nReplacer(FormI18nFinder formI18nFinder) {
            this.finder = formI18nFinder;
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$form$FormI18nSupport == null ? (class$org$netbeans$modules$i18n$form$FormI18nSupport = FormI18nSupport.class$("org.netbeans.modules.i18n.form.FormI18nSupport")) : class$org$netbeans$modules$i18n$form$FormI18nSupport));
        }

        public void replace(HardCodedString hardCodedString, I18nString i18nString) {
            if (hardCodedString instanceof FormHardCodedString) {
                this.replaceInGuarded((FormHardCodedString)hardCodedString, (JavaI18nString)i18nString);
            } else {
                super.replace(hardCodedString, i18nString);
            }
        }

        private void replaceInGuarded(FormHardCodedString formHardCodedString, JavaI18nString javaI18nString) {
            try {
                Object object;
                StringBuffer stringBuffer;
                Object object2;
                String string = javaI18nString.getReplaceString();
                int n = this.finder.getLastPosition().getOffset();
                int n2 = formHardCodedString.getEndPosition().getOffset();
                Node.Property property = formHardCodedString.getNodeProperty();
                ValidFormProperty validFormProperty = formHardCodedString.getValidProperty();
                Object object3 = property.getValue();
                if (property instanceof FormProperty) {
                    if (object3 instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && ((RADConnectionPropertyEditor.RADConnectionDesignValue)object3).getType() == 2) {
                        object2 = ((RADConnectionPropertyEditor.RADConnectionDesignValue)object3).getCode();
                        stringBuffer = new StringBuffer((String)object2);
                        int n3 = this.indexOfHardString((String)object2, formHardCodedString.getText(), validFormProperty.getSkip());
                        if (n3 == -1) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.bundle.getString("MSG_StringNotFoundInGuarded"), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        int n4 = n3;
                        int n5 = n4 + formHardCodedString.getText().length() + 2;
                        stringBuffer.replace(n4, n5, string);
                        RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue = new RADConnectionPropertyEditor.RADConnectionDesignValue(stringBuffer.toString());
                        object = rADConnectionDesignValue;
                    } else {
                        ((FormProperty)property).setCurrentEditor((PropertyEditor)new FormI18nStringEditor());
                        object = new FormI18nString(javaI18nString);
                    }
                } else {
                    object2 = (String)object3;
                    stringBuffer = new StringBuffer((String)object2);
                    int n6 = this.indexOfHardString((String)object2, formHardCodedString.getText(), validFormProperty.getSkip());
                    if (n6 == -1) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.bundle.getString("MSG_StringNotFoundInGuarded"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    int n7 = n6;
                    int n8 = n7 + formHardCodedString.getText().length() + 2;
                    stringBuffer.replace(n7, n8, string);
                    object = stringBuffer.toString();
                }
                property.setValue(object);
                this.finder.decrementLastFoundSkip();
                object2 = javaI18nString.getSupport().getDocument();
                int n9 = n + string.length() - formHardCodedString.getText().length() - 2;
                SwingUtilities.invokeLater(new Runnable((StyledDocument)object2, n9){
                    private final /* synthetic */ StyledDocument val$document;
                    private final /* synthetic */ int val$lastP;
                    {
                        this.val$document = styledDocument;
                        this.val$lastP = n;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (this.val$document instanceof AbstractDocument) {
                            ((AbstractDocument)((Object)this.val$document)).readLock();
                        }
                        try {
                            finder.setLastPosition(this.val$document.createPosition(this.val$lastP));
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                        }
                        finally {
                            if (this.val$document instanceof AbstractDocument) {
                                ((AbstractDocument)((Object)this.val$document)).readUnlock();
                            }
                        }
                    }
                });
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
            }
        }

        private int indexOfHardString(String string, String string2, int n) {
            while (n >= 0) {
                int n2 = this.finder.indexOfNonI18nString(string, string2, n);
                if (n2 >= 0) {
                    return n2;
                }
                --n;
            }
            return -1;
        }
    }

    private static class FormI18nFinder
    extends JavaI18nSupport.JavaI18nFinder {
        private DataObject sourceDataObject;
        private String componentName = "";
        private String propertyName = "";
        private TreeSet formProperties;
        private ValidFormProperty lastFoundProp;

        public FormI18nFinder(DataObject dataObject, StyledDocument styledDocument) {
            super(styledDocument);
            this.sourceDataObject = dataObject;
            this.init();
        }

        private void init() {
            this.clearFormInfoValues();
            this.lastFoundProp = null;
            this.createFormProperties();
        }

        protected void reset() {
            super.reset();
            this.init();
        }

        void decrementLastFoundSkip() {
            if (this.lastFoundProp != null) {
                this.lastFoundProp.decrementSkip();
            }
        }

        private synchronized boolean createFormProperties() {
            this.formProperties = new TreeSet(new ValidFormPropertyComparator((FormDataObject)this.sourceDataObject));
            this.updateFormProperties();
            return true;
        }

        private synchronized void updateFormProperties() {
            if (this.formProperties == null) {
                return;
            }
            List list = ((FormDataObject)this.sourceDataObject).getFormEditor().getFormModel().getMetaComponents();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RADComponent rADComponent = (RADComponent)iterator.next();
                Node.PropertySet[] propertySetArray = rADComponent.getProperties();
                for (int i = 0; i < propertySetArray.length; ++i) {
                    String string = propertySetArray[i].getName();
                    if (!(FormI18nSupport.RAD_PROPERTIES.equals(string) || FormI18nSupport.RAD_PROPERTIES2.equals(string) || FormI18nSupport.RAD_ACCESSIBILITY.equals(string) || FormI18nSupport.RAD_LAYOUT.equals(string))) continue;
                    Node.Property[] propertyArray = propertySetArray[i].getProperties();
                    for (int j = 0; j < propertyArray.length; ++j) {
                        Object object;
                        Node.Property property = propertyArray[j];
                        if (property.isHidden() || !(property instanceof FormProperty) || !((FormProperty)property).isChanged()) continue;
                        try {
                            object = property.getValue();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            continue;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            continue;
                        }
                        if (object == null || !property.getValueType().equals(class$java$lang$String == null ? FormI18nSupport.class$("java.lang.String") : class$java$lang$String) && (!(object instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || ((RADConnectionPropertyEditor.RADConnectionDesignValue)object).getType() != 3 && ((RADConnectionPropertyEditor.RADConnectionDesignValue)object).getType() != 2)) continue;
                        this.formProperties.add(new ValidFormProperty(rADComponent.getName(), property));
                    }
                }
            }
        }

        protected HardCodedString findNextString() {
            HardCodedString hardCodedString;
            this.clearFormInfoValues();
            boolean bl = false;
            do {
                hardCodedString = super.findNextString();
                if (this.i18nSearch) {
                    return hardCodedString;
                }
                if (hardCodedString == null) break;
                bl = this.isInGuardedSection(hardCodedString.getStartPosition(), hardCodedString.getEndPosition());
                if (!bl) continue;
                hardCodedString = this.findInForm(hardCodedString);
            } while (bl && hardCodedString == null);
            return hardCodedString;
        }

        private void clearFormInfoValues() {
            this.componentName = "";
            this.propertyName = "";
        }

        private synchronized HardCodedString findInForm(HardCodedString hardCodedString) {
            Iterator iterator;
            boolean bl = false;
            String string = hardCodedString.getText();
            ValidFormProperty validFormProperty = null;
            Node.Property property = null;
            if (this.lastFoundProp != null) {
                validFormProperty = this.lastFoundProp;
                iterator = this.formProperties.tailSet(this.lastFoundProp).iterator();
            } else {
                iterator = this.formProperties.iterator();
            }
            do {
                Object object;
                if (validFormProperty == null && iterator.hasNext()) {
                    validFormProperty = (ValidFormProperty)iterator.next();
                }
                if (validFormProperty == null) break;
                Node.Property property2 = validFormProperty.getProperty();
                String string2 = validFormProperty.getRADComponentName();
                try {
                    object = property2.getValue();
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
                    validFormProperty = null;
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
                    validFormProperty = null;
                    continue;
                }
                if (object != null && (property2.getValueType().equals(class$java$lang$String == null ? FormI18nSupport.class$("java.lang.String") : class$java$lang$String) || object instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && (((RADConnectionPropertyEditor.RADConnectionDesignValue)object).getType() == 3 || ((RADConnectionPropertyEditor.RADConnectionDesignValue)object).getType() == 2))) {
                    String string3;
                    if (property2 instanceof FormProperty) {
                        if (object instanceof FormI18nString) {
                            validFormProperty = null;
                            continue;
                        }
                        if (object instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) {
                            string3 = "";
                            RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)object;
                            if (rADConnectionDesignValue.getType() == 3) {
                                string3 = rADConnectionDesignValue.getValue();
                                if (this.indexOfNonI18nString(string3, string, validFormProperty.getSkip()) != -1) {
                                    bl = true;
                                }
                            } else if (rADConnectionDesignValue.getType() == 2 && this.indexOfNonI18nString(string3 = rADConnectionDesignValue.getCode(), string, validFormProperty.getSkip()) != -1) {
                                bl = true;
                            }
                        } else {
                            string3 = FormI18nFinder.toAscii((String)object);
                            if (validFormProperty.getSkip() == 0 && string3.equals(string)) {
                                bl = true;
                            }
                        }
                    } else {
                        string3 = (String)object;
                        if (this.indexOfNonI18nString(string3, string, validFormProperty.getSkip()) != -1) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    property = property2;
                    this.componentName = string2;
                    this.propertyName = property2.getName();
                    break;
                }
                validFormProperty = null;
            } while (iterator.hasNext());
            if (bl) {
                this.lastFoundProp = new ValidFormProperty(validFormProperty);
                this.lastFoundProp.incrementSkip();
                return new FormHardCodedString(hardCodedString.getText(), hardCodedString.getStartPosition(), hardCodedString.getEndPosition(), validFormProperty, property);
            }
            return null;
        }

        public Position getLastPosition() {
            return this.lastPosition;
        }

        public void setLastPosition(Position position) {
            this.lastPosition = position;
        }

        public int indexOfNonI18nString(String string, String string2, int n) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string.indexOf(34, n4)) != -1) {
                int n5 = string.indexOf(34, n2 + 1);
                int n6 = string.indexOf(10, n2 + 1);
                if (n6 == -1 || n5 < n6) {
                    int n7;
                    String string3;
                    String string4 = string.substring(n2, n5 + 1);
                    int n8 = string.indexOf(10, n4 + 1);
                    if (n8 != -1 && n8 < n2) {
                        n4 = n8 + 1;
                    }
                    if (this.isSearchedString(string3 = n6 == -1 ? string.substring(n4) : ((n7 = string.indexOf(34, n5 + 1)) != -1 && n7 < n6 ? string.substring(n4, n7) + string.substring(n7, n6).replace('\"', '_') : string.substring(n4, n6)), string4)) {
                        if (n3 == n) {
                            if (string4.equals("\"" + string2 + "\"")) {
                                return n2;
                            }
                            return -1;
                        }
                        ++n3;
                    }
                    n4 = n5 + 1;
                    continue;
                }
                n4 = n6 + 1;
            }
            return -1;
        }

        private static String toAscii(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
            char[] cArray = string.toCharArray();
            block9: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (c) {
                    case '\b': {
                        stringBuffer.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block9;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' && c <= '\u007f') {
                            stringBuffer.append(c);
                            continue block9;
                        }
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c);
                        for (int j = 0; j < 4 - string2.length(); ++j) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private synchronized boolean isInGuardedSection(Position position, Position position2) {
            JavaEditor javaEditor = ((JavaDataObject)this.sourceDataObject).getJavaEditor();
            return javaEditor.testOverlap(javaEditor.createBounds(position.getOffset(), position2.getOffset(), false));
        }

        DataObject getSourceDataObject() {
            return this.sourceDataObject;
        }
    }

    private static class ValidFormPropertyComparator
    implements Comparator {
        private static final String CREATION_CODE_PRE = "creationCodePre";
        private static final String CREATION_CODE_CUSTOM = "creationCodeCustom";
        private static final String CREATION_CODE_POST = "creationCodePost";
        private static final String INIT_CODE_PRE = "initCodePre";
        private static final String INIT_CODE_POST = "initCodePost";
        private final FormModel formModel;

        public ValidFormPropertyComparator(FormDataObject formDataObject) {
            this.formModel = formDataObject.getFormEditor().getFormModel();
        }

        public int compare(Object object, Object object2) {
            String string = ((ValidFormProperty)object).getProperty().getName();
            String string2 = ((ValidFormProperty)object2).getProperty().getName();
            boolean bl = false;
            boolean bl2 = false;
            if (string.equals(CREATION_CODE_PRE) || string.equals(CREATION_CODE_CUSTOM) || string.equals(CREATION_CODE_POST)) {
                bl = true;
            }
            if (string2.equals(CREATION_CODE_PRE) || string2.equals(CREATION_CODE_CUSTOM) || string2.equals(CREATION_CODE_POST)) {
                bl2 = true;
            }
            if (bl != bl2) {
                return bl ? -1 : 1;
            }
            RADComponent rADComponent = this.formModel.findRADComponent(((ValidFormProperty)object).getRADComponentName());
            RADComponent rADComponent2 = this.formModel.findRADComponent(((ValidFormProperty)object2).getRADComponentName());
            int n = -1;
            int n2 = -1;
            if (!rADComponent.equals(rADComponent2)) {
                Object[] objectArray = this.formModel.getMetaComponents().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (rADComponent.equals(objectArray[i])) {
                        n = i;
                    }
                    if (rADComponent2.equals(objectArray[i])) {
                        n2 = i;
                    }
                    if (n != -1 && n2 != -1) break;
                }
                return n - n2;
            }
            if (bl) {
                n = -1;
                n2 = -1;
                if (string.equals(CREATION_CODE_PRE)) {
                    n = 0;
                } else if (string.equals(CREATION_CODE_CUSTOM)) {
                    n = 1;
                } else if (string.equals(CREATION_CODE_POST)) {
                    n = 2;
                }
                if (string2.equals(CREATION_CODE_PRE)) {
                    n2 = 0;
                } else if (string2.equals(CREATION_CODE_CUSTOM)) {
                    n2 = 1;
                } else if (string2.equals(CREATION_CODE_POST)) {
                    n2 = 2;
                }
                return n - n2;
            }
            n = -1;
            n2 = -1;
            n = string.equals(INIT_CODE_PRE) ? 0 : (string.equals(INIT_CODE_POST) ? 2 : 1);
            n2 = string2.equals(INIT_CODE_PRE) ? 0 : (string2.equals(INIT_CODE_POST) ? 2 : 1);
            if (n != 1 || n2 != 1) {
                return n - n2;
            }
            Node.PropertySet[] propertySetArray = rADComponent.getProperties();
            Object[] objectArray = new Node.Property[]{};
            ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>();
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!FormI18nSupport.RAD_PROPERTIES.equals(propertySetArray[i].getName()) && !FormI18nSupport.RAD_PROPERTIES2.equals(propertySetArray[i].getName()) && !FormI18nSupport.RAD_LAYOUT.equals(propertySetArray[i].getName()) && !FormI18nSupport.RAD_ACCESSIBILITY.equals(propertySetArray[i].getName())) continue;
                arrayList.addAll(Arrays.asList(propertySetArray[i].getProperties()));
            }
            objectArray = arrayList.toArray();
            n = -1;
            n2 = -1;
            Node.Property property = ((ValidFormProperty)object).getProperty();
            Node.Property property2 = ((ValidFormProperty)object2).getProperty();
            for (int i = 0; i < objectArray.length; ++i) {
                if (property.equals((Object)objectArray[i])) {
                    n = i;
                }
                if (property2.equals((Object)objectArray[i])) {
                    n2 = i;
                }
                if (n != -1 && n2 != -1) break;
            }
            return n - n2;
        }
    }

    private static class ValidFormProperty {
        private Node.Property property;
        private String radCompName;
        private int skip;

        public ValidFormProperty(String string, Node.Property property) {
            this.radCompName = string;
            this.property = property;
            this.skip = 0;
        }

        public ValidFormProperty(ValidFormProperty validFormProperty) {
            this.radCompName = validFormProperty.getRADComponentName();
            this.property = validFormProperty.getProperty();
            this.skip = validFormProperty.getSkip();
        }

        public String getRADComponentName() {
            return this.radCompName;
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public int getSkip() {
            return this.skip;
        }

        public void incrementSkip() {
            ++this.skip;
        }

        public void decrementSkip() {
            if (this.skip > 0) {
                --this.skip;
            }
        }
    }
}

