/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ClassMemberRelatedItemProvider;
import org.netbeans.modules.java.navigation.InheritanceTreeController;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;

final class ClassMemberController
extends MouseAdapter
implements PopupMenuListener {
    private ClassMemberPanelUI panelUI;
    private int origDelay = -1;

    public ClassMemberController(ClassMemberPanelUI classMemberPanelUI) {
        this.panelUI = classMemberPanelUI;
        this.initActions();
        this.initListeners();
    }

    private void initActions() {
        NavigatorJList navigatorJList = this.panelUI.getContent();
        OpenByKeyboardAction openByKeyboardAction = new OpenByKeyboardAction();
        navigatorJList.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "open");
        navigatorJList.getActionMap().put("open", openByKeyboardAction);
        ShowPopupAction showPopupAction = new ShowPopupAction();
        navigatorJList.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64, true), "popup");
        navigatorJList.getActionMap().put("popup", showPopupAction);
    }

    private void initListeners() {
        this.panelUI.getContent().addMouseListener(this);
    }

    private void showPopup(JList jList, Point point) {
        DisplayProvider displayProvider = (DisplayProvider)((Object)jList.getModel());
        Object var4_4 = null;
        int n = NavigatorJList.indexAtLocation(jList, point);
        if (n >= 0) {
            var4_4 = jList.getModel().getElementAt(n);
        }
        jList.scrollRectToVisible(new Rectangle(point.x, point.y + 16, 12, 16));
        JPopupMenu jPopupMenu = InheritanceTreeController.createPopupMenuForItem(jList, displayProvider, var4_4);
        if (jPopupMenu != null) {
            jPopupMenu.addPopupMenuListener(this);
            jPopupMenu.show(jList, point.x, point.y);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Action action;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        NavigatorJList navigatorJList = this.panelUI.getContent();
        Point point = mouseEvent.getPoint();
        int n = NavigatorJList.indexAtLocation(navigatorJList, point);
        Object var5_5 = null;
        if (n == -1) {
            return;
        }
        var5_5 = navigatorJList.getModel().getElementAt(n);
        DisplayProvider displayProvider = (DisplayProvider)((Object)navigatorJList.getModel());
        if ((displayProvider.isDefaultActionInstant() || mouseEvent.getClickCount() > 1) && (action = displayProvider.getDefaultAction(var5_5)) != null && action.isEnabled()) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "click");
            if (ClassMemberRelatedItemProvider.USE_RELATED_ITEMS && navigatorJList.getModel() instanceof RelatedItemProvider) {
                ((RelatedItemProvider)((Object)navigatorJList.getModel())).reset();
                navigatorJList.repaint();
            }
            action.actionPerformed(actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup((JList)mouseEvent.getSource(), mouseEvent.getPoint());
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup((JList)mouseEvent.getSource(), mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.origDelay = toolTipManager.getDismissDelay();
        toolTipManager.setDismissDelay(Integer.MAX_VALUE);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.origDelay > 0) {
            ToolTipManager.sharedInstance().setDismissDelay(this.origDelay);
            this.origDelay = -1;
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        int n;
        ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof KeyEvent && ((n = ((KeyEvent)aWTEvent).getKeyCode()) == 10 || n == 27)) {
            this.panelUI.getContent().ignoreNextKeyUntilReleased();
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private final class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorJList navigatorJList = ClassMemberController.this.panelUI.getContent();
            int n = navigatorJList.getSelectedIndex();
            Point point = navigatorJList.indexToLocation(n);
            point.x += 7;
            point.y += 14;
            ClassMemberController.this.showPopup(navigatorJList, point);
        }
    }

    private class OpenByKeyboardAction
    extends AbstractAction {
        private OpenByKeyboardAction() {
        }

        public boolean isEnabled() {
            return this.findDefaultAction() != null;
        }

        private Action findDefaultAction() {
            Action action;
            NavigatorJList navigatorJList = ClassMemberController.this.panelUI.getContent();
            ListModel listModel = navigatorJList.getModel();
            Object var3_3 = null;
            int n = navigatorJList.getSelectedIndex();
            if (n != -1) {
                var3_3 = listModel.getElementAt(n);
            }
            if (var3_3 != null && (action = ((DisplayProvider)((Object)listModel)).getDefaultAction(var3_3)) != null && action.isEnabled()) {
                return action;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.findDefaultAction();
            if (action != null) {
                InheritanceTreeController.runWithWaitCursor(ClassMemberController.this.panelUI.getContent(), action, actionEvent);
            }
        }
    }
}

