/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.jmi.reflect.RefFeatured;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.ClassMemberComparator;
import org.netbeans.modules.java.navigation.ClassMemberRelatedItemProvider;
import org.netbeans.modules.java.navigation.NaturalSortComparator;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.GenerateJavadocAction;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.jmi.Hacks;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.java.navigation.spi.RelatedItemListModelSupport;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.modules.java.navigation.spi.Reorderable;
import org.netbeans.modules.java.navigation.spi.StringFilter;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.strings.WeightedStringImpl;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ClassMemberModel
extends RelatedItemListModelSupport
implements MDRChangeListener,
Reorderable,
FiltersManager.FilterChangeListener {
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private static final MDRepository repo = JavaModel.getJavaRepository();
    static FiltersManager filters = null;
    private final HashSet listeningTo = new HashSet();
    private JavaDataObject dob = null;
    private JavaClass clazz = null;
    private static boolean naturalSort = false;
    private List noMembersAvail;
    private boolean isInheritance = false;
    private JUtils.TipHackInvoker tipInvoker;
    private RelatedItemProvider.RelatedItemListener relatedL;
    private static final boolean singleClick = Boolean.getBoolean("nb.navigator.singleclick");
    private boolean includeInners = true;

    ClassMemberModel(JavaDataObject javaDataObject, JUtils.TipHackInvoker tipHackInvoker, RelatedItemProvider.RelatedItemListener relatedItemListener) {
        super(new ClassMemberRelatedItemProvider(javaDataObject), singleClick, true, true);
        this.dob = javaDataObject;
        this.isInheritance = false;
        this.tipInvoker = tipHackInvoker;
        this.relatedL = relatedItemListener;
    }

    ClassMemberModel(JavaClass javaClass) {
        super(null, false, true, true);
        this.clazz = javaClass;
        this.isInheritance = true;
    }

    void setDataObject(JavaDataObject javaDataObject) {
        this.dob = javaDataObject;
    }

    public String getTooltip(Object object) {
        return null;
    }

    public String getTooltip(Object object, int n, int n2) {
        ItemPaintingData itemPaintingData = (ItemPaintingData)object;
        return JUtils.getTooltip(itemPaintingData.getWString(), itemPaintingData.getJMIData(), this.clazz, n, n2, this.tipInvoker);
    }

    public Action getDefaultAction(Object object) {
        if (!(object instanceof ItemPaintingData)) {
            object = null;
        }
        Object object2 = object != null ? ((ItemPaintingData)object).getJMIData() : null;
        return OpenAction.createOpenAction(object2);
    }

    public Action[] getActions(Object object) {
        Object object2 = null;
        if (object instanceof ItemPaintingData) {
            object2 = ((ItemPaintingData)object).getJMIData();
        }
        boolean bl = false;
        if (object2 != null) {
            JUtils.isWrapper(object2);
            object2 = JUtils.unwrap(object2);
        }
        if (object2 == null || object2 instanceof Method && bl) {
            return new Action[]{new SortActionSupport.SortByNameAction(this), new SortActionSupport.SortBySourceAction(this), null, new FilterSubmenuAction(ClassMemberModel.filtersInstance())};
        }
        return new Action[]{new GenerateJavadocAction((ClassMember)object2), null, new SortActionSupport.SortByNameAction(this), new SortActionSupport.SortBySourceAction(this), null, new FilterSubmenuAction(ClassMemberModel.filtersInstance())};
    }

    public List getSearchResults(String string) {
        if (this.getList() == null) {
            return Collections.EMPTY_LIST;
        }
        string = string.trim();
        StringFilter stringFilter = StringFilter.create(string);
        StringFilter stringFilter2 = StringFilter.create(string.toUpperCase());
        ArrayList<ItemPaintingData> arrayList = new ArrayList<ItemPaintingData>();
        ArrayList<ItemPaintingData> arrayList2 = new ArrayList<ItemPaintingData>();
        Iterator iterator = this.getList().iterator();
        while (iterator.hasNext()) {
            ItemPaintingData itemPaintingData = (ItemPaintingData)iterator.next();
            String string2 = itemPaintingData.getWString().toString();
            int n = string2.lastIndexOf(".");
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            if (stringFilter.match(string2)) {
                arrayList.add(itemPaintingData);
                continue;
            }
            if (!stringFilter2.match(string2.toUpperCase())) continue;
            arrayList2.add(itemPaintingData);
        }
        arrayList.addAll(arrayList2);
        return Collections.unmodifiableList(arrayList);
    }

    public Icon getIcon(Object object) {
        return ((ItemPaintingData)object).getIcon();
    }

    protected WeightedString assembleName(WeightedString weightedString, Object object) {
        return ((ItemPaintingData)object).getWString();
    }

    protected boolean isObjectValid(Object object) {
        return true;
    }

    public int indexOf(Object object) {
        if (object instanceof Element) {
            return this.findItemIndexForElement((Element)object);
        }
        return super.indexOf(object);
    }

    private int findItemIndexForElement(Element element) {
        List list = this.getList();
        ItemPaintingData itemPaintingData = null;
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            itemPaintingData = (ItemPaintingData)iterator.next();
            if (element.equals(itemPaintingData.getJMIData())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void stopListening() {
        if (!this.listeningTo.isEmpty()) {
            Iterator iterator = this.listeningTo.iterator();
            while (iterator.hasNext()) {
                ((MDRChangeSource)iterator.next()).removeListener((MDRChangeListener)this);
            }
            this.listeningTo.clear();
        }
        if (this.relatedL != null) {
            this.getRelatedItemProviderSupport().removeRelatedItemListener(this.relatedL);
        }
    }

    protected void startListening() {
        if (this.relatedL != null) {
            try {
                this.getRelatedItemProviderSupport().addRelatedItemListener(this.relatedL);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
        }
    }

    void setIncludeInners(boolean bl) {
        this.includeInners = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadContents() {
        List list = null;
        ((JMManager)JMManager.getManager()).waitScanFinished();
        repo.beginTrans(false);
        try {
            this.fireBusyChange(true);
            if (this.clazz != null && !this.clazz.isValid()) {
                this.clazz = null;
            }
            JavaClass javaClass = this.clazz;
            JavaClass[] javaClassArray = new JavaClass[]{javaClass};
            boolean bl = ClassMemberModel.filtersInstance().isSelected(SHOW_INHERITED);
            if (this.isInheritance) {
                if (javaClass != null) {
                    list = JUtils.getClassMembers(javaClass, bl, this.includeInners);
                }
            } else {
                list = JUtils.getClassMembers(this.dob, bl, javaClassArray, this.includeInners);
            }
            if (list == null) {
                List list2 = this.getNoMembersAvail();
                return list2;
            }
            if (javaClassArray[0] != this.clazz && javaClassArray[0] != null) {
                this.clazz = javaClassArray[0];
            }
            Object[] objectArray = list.iterator();
            while (objectArray.hasNext()) {
                Object object = JUtils.unwrap(objectArray.next());
                if (object instanceof Method || object instanceof Constructor || object instanceof Field || object instanceof Attribute) continue;
                objectArray.remove();
            }
            list = this.filter(this.clazz, list);
            objectArray = list.toArray();
            Arrays.sort(objectArray, naturalSort ? new NaturalSortComparator() : new ClassMemberComparator(javaClass));
            list = Arrays.asList(objectArray);
            list = this.buildMembersForPainting(list);
            if (list.isEmpty()) {
                list = this.getNoMembersAvail();
            }
            this.startListeningTo(Hacks.getResourceForDataObject(this.dob));
        }
        finally {
            repo.endTrans(false);
            this.fireBusyChange(false);
        }
        return list;
    }

    private List buildMembersForPainting(List list) {
        ArrayList<ItemPaintingData> arrayList = new ArrayList<ItemPaintingData>(list.size());
        Object var3_3 = null;
        Object var4_4 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            var4_4 = iterator.next();
            arrayList.add(new ItemPaintingData(this.buildWString(var4_4), JUtils.iconFor(var4_4), var4_4));
        }
        return arrayList;
    }

    private List getNoMembersAvail() {
        if (this.noMembersAvail == null) {
            this.noMembersAvail = new ArrayList(1);
            WeightedStringImpl weightedStringImpl = new WeightedStringImpl();
            ((WeightedString)weightedStringImpl).startMarkupRun(4);
            ((WeightedString)weightedStringImpl).append(NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_NoMembersAvail"), 0.9f);
            this.noMembersAvail.add(new ItemPaintingData(weightedStringImpl, null, null));
        }
        return this.noMembersAvail;
    }

    private WeightedString buildWString(Object object) {
        WeightedStringImpl weightedStringImpl = new WeightedStringImpl();
        if (object instanceof ClassMember && !((ClassMember)object).isValid()) {
            ((WeightedString)weightedStringImpl).startMarkupRun(512);
            ((WeightedString)weightedStringImpl).append(NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_Invalid"), 0.9f);
        } else {
            boolean bl;
            boolean bl2 = bl = this.dob == null;
            if (!bl && !this.isInheritance && object instanceof ClassMember && ((ClassMember)object).getDeclaringClass() instanceof JavaClass) {
                JavaClass javaClass = (JavaClass)((ClassMember)object).getDeclaringClass();
                bl = javaClass != this.clazz || javaClass.isInner();
            }
            JUtils.extractName(weightedStringImpl, object, this.clazz, bl);
        }
        return weightedStringImpl;
    }

    private List filter(JavaClass javaClass, List list) {
        FiltersManager filtersManager = ClassMemberModel.filtersInstance();
        boolean bl = filtersManager.isSelected(SHOW_STATIC);
        boolean bl2 = filtersManager.isSelected(SHOW_NON_PUBLIC);
        boolean bl3 = filtersManager.isSelected(SHOW_FIELDS);
        if (bl && bl2 && bl3) {
            return list;
        }
        ArrayList<ClassMember> arrayList = new ArrayList<ClassMember>();
        boolean bl4 = (javaClass.getModifiers() & 1) != 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = JUtils.unwrap(e);
            if (!(object instanceof ClassMember)) continue;
            ClassMember classMember = (ClassMember)object;
            if (!bl2 && (!bl4 || !this.isPartOfPublicAPI(classMember)) || !bl && (classMember.getModifiers() & 8) != 0 || !bl3 && classMember instanceof Field) continue;
            arrayList.add(classMember);
        }
        return arrayList;
    }

    private boolean isPartOfPublicAPI(ClassMember classMember) {
        boolean bl;
        boolean bl2 = (classMember.getModifiers() & 1) != 0;
        boolean bl3 = bl = (classMember.getModifiers() & 4) != 0;
        if (!bl2 && !bl) {
            return false;
        }
        RefFeatured refFeatured = classMember.refImmediateComposite();
        while (refFeatured instanceof JavaClass) {
            boolean bl4;
            JavaClass javaClass = (JavaClass)refFeatured;
            int n = javaClass.getModifiers();
            boolean bl5 = (n & 1) != 0;
            boolean bl6 = bl4 = (n & 4) != 0;
            if (!bl5 && !bl4) {
                return false;
            }
            if (bl && bl4 && (n & 0x10) != 0) {
                return false;
            }
            refFeatured = javaClass.refImmediateComposite();
        }
        return true;
    }

    private void startListeningTo(Object object) {
        if (object != null && object instanceof MDRChangeSource && !this.listeningTo.contains(object)) {
            this.listeningTo.add(object);
            ((MDRChangeSource)object).addListener((MDRChangeListener)this);
        } else if (this.clazz != null && this.clazz instanceof MDRChangeSource && !this.listeningTo.contains(this.clazz)) {
            this.listeningTo.add(this.clazz);
            ((MDRChangeSource)this.clazz).addListener((MDRChangeListener)this);
        }
    }

    public void change(MDRChangeEvent mDRChangeEvent) {
        if (!(mDRChangeEvent instanceof AttributeEvent)) {
            return;
        }
        this.change();
    }

    public boolean isReorderable() {
        return naturalSort;
    }

    public void setNaturalSort(boolean bl) {
        if (naturalSort == bl) {
            return;
        }
        naturalSort = bl;
        this.fireChange();
        this.change();
    }

    public boolean isNaturalSort() {
        return naturalSort;
    }

    public String move(Object object, int n) {
        ClassMember classMember;
        Object object2 = ((ItemPaintingData)object).getJMIData();
        ClassMember classMember2 = (ClassMember)(object2 = JUtils.unwrap(object2));
        String string = JUtils.move(classMember2, classMember = (ClassMember)((ItemPaintingData)this.getElementAt(n)).getJMIData());
        if (string == null) {
            this.change();
        }
        return string;
    }

    public JComponent getFilters() {
        FiltersManager filtersManager = ClassMemberModel.filtersInstance();
        filtersManager.hookChangeListener(this);
        return filtersManager.getComponent();
    }

    public void filterStateChanged(ChangeEvent changeEvent) {
        if (this.isActive()) {
            this.change();
        }
    }

    private static synchronized FiltersManager filtersInstance() {
        if (filters == null) {
            filters = ClassMemberModel.createFilters();
        }
        return filters;
    }

    private static FiltersManager createFilters() {
        FiltersDescription filtersDescription = new FiltersDescription();
        filtersDescription.addFilter(SHOW_INHERITED, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowInherited"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowInheritedTip"), false, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideInherited.png")), null);
        filtersDescription.addFilter(SHOW_FIELDS, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowFields"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowFieldsTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideFields.gif")), null);
        filtersDescription.addFilter(SHOW_STATIC, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowStatic"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowStaticTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideStatic.png")), null);
        filtersDescription.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowNonPublicTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideNonPublic.png")), null);
        return FiltersDescription.createManager(filtersDescription);
    }

    static final class ItemPaintingData {
        private final WeightedString wString;
        private final Icon icon;
        private final Object jmiData;

        public ItemPaintingData(WeightedString weightedString, Icon icon, Object object) {
            this.wString = weightedString;
            this.icon = icon;
            this.jmiData = object;
        }

        public WeightedString getWString() {
            return this.wString;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Object getJMIData() {
            return this.jmiData;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return this.jmiData == null ? false : this.jmiData.equals(object);
        }

        public int hashCode() {
            return this.jmiData == null ? System.identityHashCode(this) : this.jmiData.hashCode();
        }
    }
}

