/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.ClassMemberModel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.base.ModelBusyListener;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class ClassMemberPanel
implements NavigatorPanel,
LookupListener,
ModelBusyListener,
RelatedItemProvider.RelatedItemListener {
    static final Lookup.Template JDOS = new Lookup.Template(JavaDataObject.class);
    private ClassMemberPanelUI panelUI;
    private ClassMemberModel curModel;
    private Lookup.Result curContext;
    private JavaDataObject curData;

    public String getDisplayName() {
        return NbBundle.getBundle((Class)ClassMemberPanel.class).getString("LBL_members");
    }

    public String getDisplayHint() {
        return null;
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    public void panelActivated(Lookup lookup) {
        this.curContext = lookup.lookup(JDOS);
        this.curData = (JavaDataObject)((List)this.curContext.allInstances()).get(0);
        this.setNewContent(this.curData);
        this.curContext.addLookupListener((LookupListener)this);
    }

    public void panelDeactivated() {
        this.curContext.removeLookupListener((LookupListener)this);
        this.curContext = null;
        this.detachFromModel(this.curModel);
        this.curModel = null;
        this.curData = null;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        JavaDataObject javaDataObject;
        Collection collection = ((Lookup.Result)lookupEvent.getSource()).allInstances();
        if (!collection.isEmpty() && !(javaDataObject = (JavaDataObject)collection.iterator().next()).equals(this.curData)) {
            this.detachFromModel(this.curModel);
            this.curData = javaDataObject;
            this.setNewContent(javaDataObject);
        }
    }

    public Lookup getLookup() {
        return null;
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanel.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanel.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(RelatedItemProvider.RelatedItemEvent relatedItemEvent) {
        Rectangle rectangle;
        Object object = relatedItemEvent.getNewPrimary();
        Object object2 = relatedItemEvent.getOldPrimary();
        NavigatorJList navigatorJList = this.getPanelUI().getContent();
        NavigatorListModel navigatorListModel = (NavigatorListModel)navigatorJList.getModel();
        int n = object == null ? -1 : navigatorListModel.indexOf(object);
        navigatorJList.setSelectedIndex(object == null ? -1 : n);
        if (n != -1) {
            navigatorJList.ensureIndexIsVisible(n);
            navigatorJList.repaint(navigatorJList.getCellBounds(n, n));
        }
        int n2 = n = object2 == null ? -1 : navigatorListModel.indexOf(object2);
        if (n != -1) {
            navigatorJList.repaint(navigatorJList.getCellBounds(n, n));
        }
        Iterator iterator = relatedItemEvent.getPreviousRelatedItems().iterator();
        while (iterator.hasNext()) {
            n = navigatorListModel.indexOf(iterator.next());
            if (n == -1) continue;
            rectangle = navigatorJList.getCellBounds(n, n);
            navigatorJList.repaint(rectangle);
        }
        iterator = relatedItemEvent.getRelatedItems().iterator();
        while (iterator.hasNext()) {
            n = navigatorListModel.indexOf(iterator.next());
            if (n == -1) continue;
            rectangle = navigatorJList.getCellBounds(n, n);
            navigatorJList.repaint(rectangle);
        }
    }

    public void itemsCleared(RelatedItemProvider.RelatedItemEvent relatedItemEvent) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(JavaDataObject javaDataObject) {
        ClassMemberPanelUI classMemberPanelUI = this.getPanelUI();
        this.curModel = new ClassMemberModel(javaDataObject, classMemberPanelUI, this);
        classMemberPanelUI.getContent().setModel(this.curModel);
        classMemberPanelUI.setFilters(this.curModel.getFilters());
        try {
            this.curModel.addBusyListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            ErrorManager.getDefault().notify((Throwable)tooManyListenersException);
        }
        this.curModel.addNotify();
    }

    private void detachFromModel(ClassMemberModel classMemberModel) {
        classMemberModel.removeBusyListener(this);
        classMemberModel.removeNotify();
    }

    private ClassMemberPanelUI getPanelUI() {
        if (this.panelUI == null) {
            this.panelUI = new ClassMemberPanelUI();
        }
        return this.panelUI;
    }
}

