/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.java.navigation.ClassMemberController;
import org.netbeans.modules.java.navigation.base.CellRenderer;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.base.SearchPanel;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.netbeans.modules.java.navigation.base.TooltipHack;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ClassMemberPanelUI
extends JPanel
implements JUtils.TipHackInvoker {
    private JScrollPane pane;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private NavigatorJList content;
    private ClassMemberController controller;
    private SearchPanel searchPanel;
    private boolean firstPaint = true;

    public ClassMemberPanelUI() {
        this.init();
        this.controller = new ClassMemberController(this);
    }

    private void init() {
        this.pane = new JScrollPane();
        this.pane.setBorder(BorderFactory.createEmptyBorder());
        this.pane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.content = new NavigatorJList(this.pane);
        this.content.setCellRenderer(new CellRenderer());
        this.content.setSelectionMode(0);
        this.pane.getViewport().setView(this.content);
        if (Boolean.getBoolean("navigator.string.abbrevs")) {
            this.pane.setHorizontalScrollBarPolicy(31);
        } else {
            this.pane.setHorizontalScrollBarPolicy(30);
        }
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage((Class)ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        this.filtersPanel.setToolTipText(NbBundle.getMessage((Class)ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)string));
        this.searchPanel = new SearchPanel();
        this.searchPanel.prepare(this.content);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        this.add((Component)this.filtersPanel, "South");
    }

    void setFilters(JComponent jComponent) {
        this.filtersPanel.add(jComponent);
    }

    public NavigatorJList getContent() {
        return this.content;
    }

    public void paint(Graphics graphics) {
        if (this.firstPaint) {
            this.configureRowHeight(graphics);
        }
        super.paint(graphics);
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.content.requestFocusInWindow();
        return bl;
    }

    public void invokeTip(int n, int n2) {
        if (!this.content.isShowing()) {
            return;
        }
        if (this.content.isTooltipLocValid(n, n2)) {
            TooltipHack.invokeTip(this.content, n, n2, Integer.MAX_VALUE);
        }
    }

    public void setBusyState(boolean bl) {
        Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.filtersPanel.setCursor(cursor);
        this.content.setCursor(cursor);
    }

    public void newContentReady() {
        if (this.content.isFocusOwner()) {
            this.content.assureSelection();
        }
    }

    private void configureRowHeight(Graphics graphics) {
        graphics.setFont(this.content.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = Math.max(16, fontMetrics.getHeight());
        this.content.setFixedCellHeight(n);
        this.firstPaint = false;
    }
}

