/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.InheritanceTreePanelUI;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.Utilities;

final class InheritanceTreeController
extends MouseAdapter
implements TreeExpansionListener {
    private InheritanceTreePanelUI panelUI;
    private JTree tree;

    public InheritanceTreeController(InheritanceTreePanelUI inheritanceTreePanelUI) {
        this.panelUI = inheritanceTreePanelUI;
        this.tree = inheritanceTreePanelUI.getContent();
        this.initActions();
        this.initListeners();
    }

    private void initActions() {
        OpenByKeyboardAction openByKeyboardAction = new OpenByKeyboardAction();
        this.tree.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "open");
        this.tree.getActionMap().put("open", openByKeyboardAction);
        ShowPopupAction showPopupAction = new ShowPopupAction();
        this.tree.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64, true), "popup");
        this.tree.getActionMap().put("popup", showPopupAction);
    }

    private void initListeners() {
        this.tree.addMouseListener(this);
        this.tree.addTreeExpansionListener(this);
    }

    private static void showPopup(JTree jTree, Point point) {
        JPopupMenu jPopupMenu;
        DisplayProvider displayProvider = (DisplayProvider)((Object)jTree.getModel());
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        Object object = null;
        if (treePath != null) {
            object = treePath.getLastPathComponent();
            jTree.scrollRectToVisible(jTree.getPathBounds(treePath));
        }
        if ((jPopupMenu = InheritanceTreeController.createPopupMenuForItem(jTree, displayProvider, object)) != null) {
            jPopupMenu.show(jTree, point.x, point.y);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Action action;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Object object = null;
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        object = treePath.getLastPathComponent();
        DisplayProvider displayProvider = (DisplayProvider)((Object)this.tree.getModel());
        if ((displayProvider.isDefaultActionInstant() || mouseEvent.getClickCount() > 1) && (action = displayProvider.getDefaultAction(object)) != null && action.isEnabled()) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "click");
            action.actionPerformed(actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            InheritanceTreeController.showPopup((JTree)mouseEvent.getSource(), mouseEvent.getPoint());
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            InheritanceTreeController.showPopup((JTree)mouseEvent.getSource(), mouseEvent.getPoint());
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        NavigatorTreeModel navigatorTreeModel = (NavigatorTreeModel)this.tree.getModel();
        navigatorTreeModel.notifyExpandedState(treeExpansionEvent.getPath(), false);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        NavigatorTreeModel navigatorTreeModel = (NavigatorTreeModel)this.tree.getModel();
        navigatorTreeModel.notifyExpandedState(treeExpansionEvent.getPath(), true);
    }

    static JPopupMenu createPopupMenuForItem(Component component, DisplayProvider displayProvider, Object object) {
        Action[] actionArray;
        Action action = displayProvider.getDefaultAction(object);
        Action[] actionArray2 = displayProvider.getActions(object);
        int n = (actionArray2 == null ? 0 : actionArray2.length) + (action == null ? 0 : 1);
        if (n == 0) {
            return null;
        }
        if (action != null) {
            actionArray = new Action[n];
            actionArray[0] = action;
            if (actionArray2 != null) {
                System.arraycopy(actionArray2, 0, actionArray, 1, actionArray2.length);
            }
        } else {
            actionArray = actionArray2;
        }
        return Utilities.actionsToPopup((Action[])actionArray, (Component)component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runWithWaitCursor(JComponent jComponent, Action action, ActionEvent actionEvent) {
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            action.actionPerformed(actionEvent);
        }
        finally {
            jComponent.setCursor(cursor);
        }
    }

    private final class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = InheritanceTreeController.this.tree.getSelectionPath();
            if (treePath != null) {
                Rectangle rectangle = InheritanceTreeController.this.tree.getPathBounds(treePath);
                Point point = new Point(rectangle.x + 10, rectangle.y + rectangle.height - 3);
                InheritanceTreeController.showPopup(InheritanceTreeController.this.tree, point);
            }
        }
    }

    private class OpenByKeyboardAction
    extends AbstractAction {
        private OpenByKeyboardAction() {
        }

        public boolean isEnabled() {
            return this.findDefaultAction() != null;
        }

        private Action findDefaultAction() {
            Action action;
            Object object;
            JTree jTree = InheritanceTreeController.this.tree;
            TreePath treePath = jTree.getSelectionPath();
            Object object2 = object = treePath == null ? null : treePath.getLastPathComponent();
            if (object != null && (action = ((DisplayProvider)((Object)jTree.getModel())).getDefaultAction(object)) != null && action.isEnabled()) {
                return action;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.findDefaultAction();
            if (action != null) {
                InheritanceTreeController.runWithWaitCursor(InheritanceTreeController.this.tree, action, actionEvent);
            }
        }
    }
}

