/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class FilterSubmenuAction
extends AbstractAction
implements Presenter.Popup {
    private static final String PROP_FILTER_NAME = "nbFilterName";
    private FiltersManager filters;

    public FilterSubmenuAction(FiltersManager filtersManager) {
        this.filters = filtersManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
            String string = (String)jCheckBoxMenuItem.getClientProperty(PROP_FILTER_NAME);
            this.filters.setSelected(string, jCheckBoxMenuItem.isSelected());
        }
    }

    public final JMenuItem getPopupPresenter() {
        return this.createSubmenu();
    }

    private JMenuItem createSubmenu() {
        FiltersDescription filtersDescription = this.filters.getDescription();
        JMenu jMenu = new JMenu(NbBundle.getMessage((Class)FilterSubmenuAction.class, (String)"LBL_FilterSubmenu"));
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        String string = null;
        for (int i = 0; i < filtersDescription.getFilterCount(); ++i) {
            string = filtersDescription.getName(i);
            jCheckBoxMenuItem = new JCheckBoxMenuItem(filtersDescription.getDisplayName(i), this.filters.isSelected(string));
            jCheckBoxMenuItem.addActionListener(this);
            jCheckBoxMenuItem.putClientProperty(PROP_FILTER_NAME, string);
            ((Container)jMenu).add(jCheckBoxMenuItem);
        }
        return jMenu;
    }
}

