/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class OpenAction
extends AbstractAction {
    private final Element elem;
    private static final JavaMetamodel jmm = JavaMetamodel.getManager();
    private static final MDRepository repo = JavaModel.getJavaRepository();

    private OpenAction(Element element) {
        this.elem = element;
        this.putValue("Name", NbBundle.getMessage((Class)OpenAction.class, (String)"LBL_Goto"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        repo.beginTrans(false);
        try {
            if (!this.elem.isValid()) {
                return;
            }
            ClassDefinition classDefinition = this.elem instanceof ClassDefinition ? (ClassDefinition)this.elem : ((Feature)this.elem).getDeclaringClass();
            bl = JUtils.getSourceForBinary(classDefinition) != null;
        }
        finally {
            repo.endTrans();
        }
        if (bl) {
            OpenAction.openElement(this.elem);
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)OpenAction.class, (String)"MSG_NoSource", (Object)this.elem));
        }
    }

    public boolean isEnabled() {
        return this.elem != null;
    }

    public static Action createOpenAction(Object object) {
        Resource resource;
        List list;
        object = JUtils.unwrap(object);
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof JavaDataObject && (list = (resource = JavaModel.getResource((FileObject)((JavaDataObject)object).getPrimaryFile())).getClassifiers()) != null && list.size() > 0) {
            element = (JavaClass)list.get(0);
        }
        return new OpenAction(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean openElement(final Element element) {
        repo.beginTrans(false);
        try {
            Resource resource;
            Resource resource2 = resource = element.isValid() ? element.getResource() : null;
            if (resource != null) {
                EditorCookie.Observable observable;
                JavaModel.setClassPath((Resource)resource);
                DataObject dataObject = jmm.getDataObject(resource);
                if (dataObject != null && (observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class)) != null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)OpenAction.class, (String)"MSG_OpeningElement", (Object)(element instanceof NamedElement ? ((NamedElement)element).getName() : "")));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                OpenAction.selectElementInPane(jEditorPaneArray[0], element, false);
                            } else {
                                observable.addPropertyChangeListener(new PropertyChangeListener(this){
                                    private final /* synthetic */ 1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                        if ("openedPanes".equals(propertyChangeEvent.getPropertyName())) {
                                            JEditorPane[] jEditorPaneArray = 1.access$100(this.this$0).getOpenedPanes();
                                            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                                OpenAction.access$000(jEditorPaneArray[0], 1.access$200(this.this$0), true);
                                            }
                                            1.access$100(this.this$0).removePropertyChangeListener((PropertyChangeListener)this);
                                        }
                                    }
                                });
                                observable.open();
                            }
                        }

                        static /* synthetic */ EditorCookie.Observable access$100(1 var0) {
                            return var0.observable;
                        }

                        static /* synthetic */ Element access$200(1 var0) {
                            return var0.element;
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            repo.endTrans(false);
        }
        return false;
    }

    private static void selectElementInPane(final JEditorPane jEditorPane, final Element element, boolean bl) {
        if (bl) {
            jEditorPane.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            OpenAction.access$500(3.access$300(this.this$0), 3.access$400(this.this$0));
                        }
                    });
                    jEditorPane.removeFocusListener(this);
                }

                static /* synthetic */ JEditorPane access$300(3 var0) {
                    return var0.jEditorPane;
                }

                static /* synthetic */ Element access$400(3 var0) {
                    return var0.element;
                }
            });
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OpenAction.jumpToElement(jEditorPane, element);
                }
            });
            Container container = jEditorPane;
            while (!(container instanceof TopComponent)) {
                container = container.getParent();
            }
            ((TopComponent)container).requestActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jumpToElement(JEditorPane jEditorPane, Element element) {
        int n = jEditorPane.getCaretPosition();
        Container container = jEditorPane.getParent();
        Point point = container instanceof JViewport ? ((JViewport)container).getViewPosition() : null;
        PositionBounds positionBounds = null;
        repo.beginTrans(false);
        try {
            if (element.isValid()) {
                JavaModel.setClassPath((Resource)element.getResource());
                positionBounds = jmm.getElementPosition(element);
            }
        }
        finally {
            repo.endTrans(false);
        }
        if (positionBounds != null && jEditorPane.getCaretPosition() == n && (point == null || point.equals(((JViewport)container).getViewPosition()))) {
            jEditorPane.setCaretPosition(positionBounds.getBegin().getOffset());
        }
        StatusDisplayer.getDefault().setStatusText("");
    }
}

