/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class OverrideAction
extends AbstractAction {
    private final Method m;
    private final JavaClass target;
    private final JavaDataObject jdo;
    private int first = -1;
    private int last = -1;
    private boolean sortByIndex = false;

    public OverrideAction(Method method, JavaClass javaClass, JavaDataObject javaDataObject) {
        this.m = method;
        this.target = javaClass;
        this.jdo = javaDataObject;
        this.putValue("Name", NbBundle.getMessage((Class)OverrideAction.class, (String)(this.isInterfaceMethod() ? "LBL_implement" : "LBL_override")));
    }

    private boolean isInterfaceMethod() {
        ClassDefinition classDefinition = this.m.getDeclaringClass();
        if (classDefinition instanceof JavaClass) {
            return ((JavaClass)classDefinition).isInterface();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        block13: {
            TopComponent topComponent;
            OpenCookie openCookie;
            HashSet hashSet = new HashSet();
            String string = this.create(hashSet);
            JavaEditor javaEditor = this.jdo.getJavaEditor();
            if (javaEditor == null) {
                openCookie = (OpenCookie)this.jdo.getCookie(OpenCookie.class);
                if (openCookie == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                openCookie.open();
            }
            openCookie = javaEditor != null ? javaEditor.getOpenedPanes() : null;
            JEditorPane jEditorPane = openCookie != null && ((OpenCookie)openCookie).length >= 0 ? javaEditor.getOpenedPanes()[0] : null;
            BoundedRangeModel boundedRangeModel = null;
            if (jEditorPane != null && !hashSet.isEmpty()) {
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jEditorPane);
                if (jScrollPane != null) {
                    boundedRangeModel = jScrollPane.getHorizontalScrollBar().getModel();
                    boundedRangeModel.setValueIsAdjusting(true);
                }
                jEditorPane.setIgnoreRepaint(true);
            }
            int n = 0;
            try {
                StyledDocument styledDocument = javaEditor.getDocument();
                int n2 = OverrideAction.getInsertPosition(styledDocument);
                try {
                    styledDocument.insertString(n2 - 1, string, null);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                int n3 = 0;
                if (!hashSet.isEmpty()) {
                    n3 = this.createImports(hashSet, styledDocument);
                    if (boundedRangeModel != null) {
                        boundedRangeModel.setValueIsAdjusting(false);
                    }
                }
                n = n3 + n2 + string.indexOf("{") + 8;
                Object var13_14 = null;
                if (jEditorPane == null) break block13;
                jEditorPane.getCaret().setDot(n);
                topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (jEditorPane != null) {
                    jEditorPane.getCaret().setDot(n);
                    TopComponent topComponent2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane);
                    if (topComponent2 != null) {
                        topComponent2.requestActive();
                    }
                    jEditorPane.setIgnoreRepaint(false);
                }
                throw throwable;
            }
            if (topComponent != null) {
                topComponent.requestActive();
            }
            jEditorPane.setIgnoreRepaint(false);
            {
            }
        }
    }

    private static int getInsertPosition(Document document) {
        Element element = document.getDefaultRootElement();
        try {
            String string = document.getText(0, document.getLength());
            if (string.indexOf("}") >= 0) {
                return element.getStartOffset() + string.lastIndexOf("}");
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return document.getLength() - 2;
    }

    private String create(Set set) {
        Parameter parameter;
        Iterator iterator;
        Collection collection;
        StringBuffer stringBuffer = new StringBuffer("\n\n");
        int n = this.m.getModifiers();
        stringBuffer.append("    ");
        if ((n & 1) != 0 || ((JavaClass)this.m.getDeclaringClass()).isInterface()) {
            stringBuffer.append("public ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static");
        }
        if (this.m.getType() != null) {
            stringBuffer.append(this.maybeStripPackage(this.m.getType(), set));
            stringBuffer.append(' ');
        } else {
            stringBuffer.append("void ");
        }
        stringBuffer.append(this.m.getName());
        stringBuffer.append('(');
        List list = this.m.getParameters();
        if (!list.isEmpty()) {
            collection = new HashSet();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                String string = parameter.getName();
                if (string == null || string.trim().length() == 0) {
                    string = JUtils.generateBelievableParameterName(parameter, collection);
                }
                stringBuffer.append(this.maybeStripPackage(parameter.getType(), set));
                stringBuffer.append(' ');
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(')');
        collection = this.m.getExceptions();
        if (!collection.isEmpty()) {
            stringBuffer.append(" throws ");
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                parameter = (ParameterizedType)iterator.next();
                stringBuffer.append(this.maybeStripPackage((Type)parameter, set));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" {\n        \n    }");
        return stringBuffer.toString();
    }

    private int createImports(Set set, Document document) {
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            int n2 = this.findImportInsertLocation(document, type);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("import ");
            String string = type.getName();
            int n3 = string.indexOf("[");
            if (n3 > 0) {
                string = string.substring(0, n3);
            }
            stringBuffer.append(string);
            stringBuffer.append(";\n");
            n += stringBuffer.length();
            try {
                document.insertString(n2, stringBuffer.toString(), null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return 0;
            }
        }
        return n;
    }

    private int findImportInsertLocation(Document document, Type type) {
        try {
            Object[] objectArray;
            HashSet<ImpInfo> hashSet = new HashSet<ImpInfo>();
            int n = 0;
            int n2 = document.getDefaultRootElement().getElementCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                objectArray = document.getDefaultRootElement().getElement(i);
                String string = document.getText(objectArray.getStartOffset(), objectArray.getEndOffset() - objectArray.getStartOffset());
                if (string.trim().startsWith("import")) {
                    hashSet.add(new ImpInfo(string, n3, (Element)objectArray));
                    this.last = i;
                    if (this.first == -1) {
                        this.first = i;
                    }
                }
                if (string.trim().startsWith("package")) {
                    n = objectArray.getEndOffset();
                }
                n3 += 2;
                if (i - this.last > 10 && this.first != -1) break;
            }
            if (hashSet.isEmpty()) {
                hashSet = null;
                return this.last != -1 ? document.getDefaultRootElement().getElement(this.last).getEndOffset() : n;
            }
            ImpInfo impInfo = new ImpInfo("import " + type.getName() + ";\n", 0, null);
            hashSet.add(impInfo);
            objectArray = hashSet.toArray(new ImpInfo[0]);
            Arrays.sort(objectArray);
            int n4 = Arrays.asList(objectArray).indexOf(impInfo);
            if (n4 > 0) {
                impInfo.idx = ((ImpInfo)objectArray[n4 - 1]).idx + 1;
                impInfo.element = ((ImpInfo)objectArray[n4 - 1]).element;
            }
            this.sortByIndex = true;
            Arrays.sort(objectArray);
            this.sortByIndex = false;
            if (impInfo.element == null) {
                return n;
            }
            int n5 = impInfo.element.getEndOffset();
            return n5;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return 0;
        }
    }

    private String maybeStripPackage(Type type, Set set) {
        String string;
        int n;
        if (!this.isImported(type)) {
            set.add(type);
        }
        if ((n = (string = type.getName()).lastIndexOf(".")) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private boolean isImported(Type type) {
        String string = type.getName();
        if (string.indexOf("java.lang.") == 0 && string.lastIndexOf(".") == 9) {
            return true;
        }
        if (JUtils.isPrimitiveTypeName(string)) {
            return true;
        }
        Resource resource = JavaModel.getResource((FileObject)this.jdo.getPrimaryFile());
        List list = resource.getImports();
        String string2 = string;
        if (string2.indexOf(".") != -1) {
            int n = string2.lastIndexOf(".");
            string2 = string2.substring(0, n);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            String string3 = import_.getImportedNamespace().getName();
            if (string3.equals(string)) {
                return true;
            }
            if (!string.startsWith(string2) || string.lastIndexOf(".") != string2.length() || !string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.target.isValid() && (this.m.getModifiers() & 0x10) == 0 && !this.isSerializationMethod() && (this.m.getModifiers() & 2) == 0 && !this.isSerializationMethod() && this.jdo.getCookie(OpenCookie.class) != null && this.jdo.getPrimaryFile().canWrite() && !JUtils.overridesMethod(this.target, this.m) && !this.originIsTarget();
    }

    private boolean originIsTarget() {
        return this.m.getDeclaringClass() == this.target;
    }

    private boolean isSerializationMethod() {
        return "readObject".equals(this.m.getName()) || "writeObject".equals(this.m.getName()) || "readExternal".equals(this.m.getName()) || "writeExternal".equals(this.m.getName());
    }

    private final class ImpInfo
    implements Comparable {
        int idx;
        final String s;
        Element element;

        public ImpInfo(String string, int n, Element element) {
            this.s = string;
            this.idx = n;
            this.element = element;
        }

        public int compareTo(Object object) {
            return OverrideAction.this.sortByIndex ? this.idx - ((ImpInfo)object).idx : this.toString().compareTo(object.toString());
        }

        public String toString() {
            return this.s;
        }
    }
}

