/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.ModelProvider;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class CellRenderer
extends DefaultTreeCellRenderer
implements ListCellRenderer,
TreeCellRenderer {
    private static Color unfocusedSelFg;
    private static Color unfocusedSelBg;
    private boolean inSetContainerWidth = false;
    private int containerWidth = 50;
    private boolean widthChanged = true;
    private int scrollPaneWidth = -1;
    private int charCount = 20;
    private int charWidth = 8;
    private static final Color relatedColor;
    private static final Color relatedBorder;
    private RelatedItemProvider provider = null;
    private boolean related;
    private boolean primary = false;
    private boolean showDragFeedback = false;
    private boolean renderingCombo = false;
    private boolean selected = false;
    private boolean lead = false;
    private boolean focused = false;
    private boolean tree = false;
    private static Graphics scratch;
    private WeightedString str = null;
    private static final Icon WAIT_ICON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContainerWidth(JComponent jComponent) {
        if (this.inSetContainerWidth) {
            return;
        }
        this.inSetContainerWidth = true;
        try {
            this.setContainerWidth(jComponent.getWidth());
        }
        finally {
            this.inSetContainerWidth = false;
        }
    }

    private void setContainerWidth(int n) {
        if (this.containerWidth != n) {
            this.containerWidth = n;
            this.widthChanged = true;
        }
    }

    private void setScrollPaneWidth(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container != null) {
            container = SwingUtilities.getAncestorOfClass(JScrollPane.class, jComponent.getParent());
        }
        if (container != null) {
            int n = container.getWidth();
            boolean bl = this.widthChanged = this.scrollPaneWidth != n;
            if (this.widthChanged) {
                this.scrollPaneWidth = n;
            }
        } else {
            boolean bl = this.widthChanged = this.scrollPaneWidth != -1;
            if (this.widthChanged) {
                this.scrollPaneWidth = -1;
            }
        }
    }

    private void calcCharCount(Graphics graphics, FontMetrics fontMetrics) {
        int n = this.scrollPaneWidth == -1 ? this.containerWidth : this.scrollPaneWidth;
        int n2 = n - this.getIconTextGap();
        String string = "abcdefghkmnopqrstuvwxyzABCDEFG";
        int n3 = fontMetrics.stringWidth(string);
        this.charWidth = n3 / string.length();
        this.charCount = Math.max(5, n2 / this.charWidth);
        this.widthChanged = false;
    }

    private boolean isSelected() {
        return this.selected;
    }

    private boolean isParentFocused() {
        return this.focused && !this.renderingCombo;
    }

    private void setSelected(boolean bl) {
        this.selected = bl;
    }

    private void setLead(boolean bl) {
        this.lead = bl;
    }

    private void setParentFocused(boolean bl) {
        this.focused = bl;
    }

    private void setRenderingCombo(boolean bl) {
        this.renderingCombo = bl;
    }

    public Color getBackground() {
        return this.renderingCombo && !this.isSelected() ? null : super.getBackground();
    }

    public Color getBackgroundNonSelectionColor() {
        if (this.renderingCombo) {
            return this.isSelected() ? this.getBackgroundSelectionColor() : null;
        }
        return super.getBackgroundNonSelectionColor();
    }

    private void setRelatedItemProvider(RelatedItemProvider relatedItemProvider) {
        this.provider = relatedItemProvider;
    }

    private boolean isRelated() {
        return this.related && !this.isSelected();
    }

    private void setRelated(boolean bl) {
        this.related = bl;
    }

    private void setPrimary(boolean bl) {
        this.primary = bl;
    }

    private boolean isTree() {
        return this.tree;
    }

    private void setTree(boolean bl) {
        this.tree = bl;
    }

    void setShowDragFeedback(boolean bl) {
        this.showDragFeedback = bl;
    }

    private boolean isShowDragFeedback() {
        return this.showDragFeedback;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.str = null;
        this.setSelected(bl);
        this.setLead(bl2);
        this.setParentFocused(jList.hasFocus());
        if (jList.getModel() instanceof DisplayProvider) {
            if (jList.getModel() instanceof RelatedItemProvider) {
                this.setRelatedItemProvider((RelatedItemProvider)((Object)jList.getModel()));
            }
            this.configureFrom((DisplayProvider)((Object)jList.getModel()), object);
            this.setContainerWidth(jList);
            if (this.shouldAbbreviate()) {
                this.setScrollPaneWidth(jList);
            }
        } else if (object instanceof ModelProvider) {
            this.setText(((ModelProvider)object).getDisplayName());
            this.setIcon(null);
        } else {
            this.setText(object == null ? "" : object.toString());
            this.setIcon(null);
        }
        this.setRenderingCombo(jList.getModel() instanceof ComboBoxModel);
        if (bl) {
            this.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setFont(jList.getFont());
        this.setTree(false);
        return this;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = new Font(font.getName(), font.getStyle(), font.getSize());
        }
        super.setFont(font);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.str = null;
        this.setSelected(bl);
        this.setLead(bl4);
        this.setParentFocused(jTree.hasFocus());
        this.setRenderingCombo(false);
        if (jTree.getModel() instanceof DisplayProvider) {
            if (jTree.getModel() instanceof RelatedItemProvider) {
                this.setRelatedItemProvider((RelatedItemProvider)((Object)jTree.getModel()));
            }
            this.configureFrom((DisplayProvider)((Object)jTree.getModel()), object);
            this.setContainerWidth(jTree);
        } else {
            this.setText(object == null ? "" : object.toString());
            this.setIcon(null);
        }
        if (bl) {
            this.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setFont(jTree.getFont());
        this.setTree(true);
        return this;
    }

    private void configureFrom(DisplayProvider displayProvider, Object object) {
        if (AbstractModel.isWaitMarker(object)) {
            this.setText(NbBundle.getMessage((Class)CellRenderer.class, (String)"MSG_PleaseWait"));
            this.setIcon(WAIT_ICON);
        } else if (AbstractModel.isInvalidMarker(object)) {
            this.setText(NbBundle.getMessage((Class)CellRenderer.class, (String)"MSG_Invalid"));
            this.setIcon(null);
        } else {
            this.setIcon(displayProvider.getIcon(object));
            this.setWeightedString(displayProvider.getName(object));
        }
        if (this.provider != null) {
            this.setRelated(this.provider.isRelated(object));
            this.setPrimary(this.provider.isPrimary(object));
        }
    }

    public Dimension getPreferredSize() {
        String string;
        if (this.isTree()) {
            boolean bl = false;
            if (this.str != null) {
                this.setText(this.str.toString());
                int n = this.str.allMarkupTypes();
                if ((n & 2) != 0 || (n & 0x80) != 0) {
                    bl = true;
                }
            }
            Dimension dimension = super.getPreferredSize();
            ++dimension.width;
            if (bl) {
                dimension.width = (int)((float)dimension.width * 1.15f);
            }
            return dimension;
        }
        String string2 = string = this.str == null ? this.getText() : this.str.toString();
        if (string == null) {
            return new Dimension(16, 100);
        }
        Font font = this.getFont();
        if (font == null) {
            font = UIManager.getFont("controlFont");
        }
        FontMetrics fontMetrics = scratch.getFontMetrics(font);
        int n = (this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() : 0) + fontMetrics.stringWidth(string);
        Dimension dimension = new Dimension(n += 8, Math.max(16, fontMetrics.getHeight()));
        if (this.isTree()) {
            dimension.width = this.containerWidth - this.getLocation().x + (this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() : 0);
        }
        return dimension;
    }

    private void setWeightedString(WeightedString weightedString) {
        this.str = weightedString;
    }

    public void paint(Graphics graphics) {
        if (this.str == null) {
            super.paint(graphics);
        } else {
            Serializable serializable;
            Icon icon = this.getIcon();
            Insets insets = this.getInsets();
            int n = insets.left;
            if (icon != null) {
                n += icon.getIconWidth() + this.getIconTextGap();
            }
            boolean bl = this.isSelected();
            boolean bl2 = this.isParentFocused();
            if (this.isShowDragFeedback() && bl) {
                graphics.setColor(this.getForeground());
                graphics.drawLine(0, 0, this.containerWidth, 0);
            } else if (this.isRelated()) {
                graphics.setColor(relatedColor);
                graphics.fillRoundRect(2, 1, this.containerWidth - 5, this.getHeight() - 2, 16, 16);
                graphics.setColor(relatedBorder);
                graphics.drawRoundRect(2, 1, this.containerWidth - 5, this.getHeight() - 2, 16, 16);
            } else if (bl2) {
                graphics.setColor(bl ? this.getOurBackgroundSelectionColor() : this.getOurBackgroundNonSelectionColor());
                graphics.fillRect(this.isTree() ? n : 0, 0, this.containerWidth - ((this.isTree() ? n : 0) + 1), this.getHeight() - 1);
                if (bl && (serializable = this.getBorderSelectionColor()) != null) {
                    graphics.setColor((Color)serializable);
                    if (this.isTree()) {
                        graphics.drawRect(n, 0, this.getWidth() - (n + 1), this.getHeight() - 1);
                    } else {
                        graphics.drawRect(0, 0, this.containerWidth - 1, this.getHeight() - 1);
                    }
                }
            } else {
                serializable = this.getOurBackgroundNonSelectionColor();
                graphics.setColor(bl ? CellRenderer.getUnfocusedSelectionBackground(serializable) : serializable);
                graphics.fillRect(this.isTree() ? n : 0, 0, this.containerWidth - ((this.isTree() ? n : 0) + 1), this.getHeight() - 1);
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, insets.left, insets.top);
            }
            graphics.setFont(this.getFont());
            serializable = graphics.getFontMetrics();
            if (this.widthChanged) {
                this.calcCharCount(graphics, (FontMetrics)serializable);
            }
            int n2 = graphics.getFontMetrics().getHeight();
            int n3 = insets.top + graphics.getFontMetrics().getMaxAscent();
            int n4 = this.getHeight() - (insets.top + insets.bottom);
            if (n2 < n4) {
                n3 += (n4 - n2) / 2;
            }
            if (bl2) {
                graphics.setColor(bl ? this.getOurTextSelectionColor() : this.getOurTextNonSelectionColor());
            } else {
                graphics.setColor(bl ? CellRenderer.getUnfocusedSelectionForeground() : this.getOurTextNonSelectionColor());
            }
            int n5 = this.shouldAbbreviate() ? this.charCount : Integer.MAX_VALUE;
            this.str.getPainter().paint(graphics, n, n3, this.str, n5, !this.isSelected());
        }
        this.setRelatedItemProvider(null);
        this.setRelated(false);
        this.setPrimary(false);
    }

    private boolean shouldAbbreviate() {
        if (this.isTree()) {
            return false;
        }
        return Boolean.getBoolean("navigator.string.abbrevs");
    }

    private Color getOurBackgroundSelectionColor() {
        Color color = this.getBackgroundSelectionColor();
        if (color == null) {
            color = Color.blue;
        }
        return color;
    }

    private Color getOurBackgroundNonSelectionColor() {
        Color color = this.getBackgroundNonSelectionColor();
        if (color == null) {
            color = Color.white;
        }
        return color;
    }

    private Color getOurTextSelectionColor() {
        Color color = this.getTextSelectionColor();
        if (color == null) {
            color = Color.white;
        }
        return color;
    }

    private Color getOurTextNonSelectionColor() {
        Color color = this.getTextNonSelectionColor();
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    private static Color getUnfocusedSelectionBackground(Color color) {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!color.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
    }

    static {
        relatedColor = new Color(255, 240, 205);
        relatedBorder = new Color(255, 215, 207);
        scratch = new BufferedImage(2, 2, 2).getGraphics();
        WAIT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif"));
    }
}

