/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.java.navigation.base.ReorderDragAndDropHandler;
import org.netbeans.modules.java.navigation.base.TooltipHack;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.openide.util.NbBundle;

public final class NavigatorJList
extends JList
implements MouseMotionListener,
MouseListener {
    static CellRendererPane cellpane = new CellRendererPane();
    static JLabel widthTestLabel = new JLabel();
    private JComponent enclosingComp;
    private Point curMouseLoc;
    private boolean isMouseInside;
    private boolean ignoreNextKey;
    private static final boolean DND = Boolean.getBoolean("nb.navigator.reordering");
    private static final boolean NO_SCROLL = Boolean.getBoolean("nb.navigator.noscroll");

    public NavigatorJList(JComponent jComponent) {
        cellpane.add(widthTestLabel);
        this.curMouseLoc = null;
        this.isMouseInside = false;
        this.ignoreNextKey = false;
        this.enclosingComp = jComponent;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)NavigatorJList.class, (String)"ACC_NavListName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)NavigatorJList.class, (String)"ACC_NavListDesc"));
        this.setBorder(BorderFactory.createEmptyBorder());
        if (DND) {
            ReorderDragAndDropHandler reorderDragAndDropHandler = new ReorderDragAndDropHandler();
            this.addMouseListener(reorderDragAndDropHandler);
            this.addMouseMotionListener(reorderDragAndDropHandler);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (!NO_SCROLL) {
            super.scrollRectToVisible(rectangle);
        } else {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof MouseEvent && ((MouseEvent)aWTEvent).getID() == 506) {
                super.scrollRectToVisible(rectangle);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.curMouseLoc = null;
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.assureSelection();
        return bl;
    }

    public void assureSelection() {
        if (this.getSelectedIndex() == -1 && this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getModel() instanceof NavigatorListModel) {
            NavigatorListModel navigatorListModel = (NavigatorListModel)this.getModel();
            int n = NavigatorJList.indexAtLocation(this, mouseEvent.getPoint());
            if (n >= 0 && n <= navigatorListModel.getSize()) {
                Object e = navigatorListModel.getElementAt(n);
                if (AbstractModel.isWaitMarker(e) || AbstractModel.isInvalidMarker(e)) {
                    return null;
                }
                return navigatorListModel.getTooltip(e, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        return "";
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Container container = this.getTopLevelAncestor();
        Rectangle rectangle = this.enclosingComp.getBounds();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, container);
        boolean bl = rectangle2.x + rectangle2.width < container.getWidth() - rectangle2.x;
        point = SwingUtilities.convertPoint(this, point, this.enclosingComp);
        int n = this.approximateWidth(this.getToolTipText(mouseEvent));
        int n2 = NavigatorJList.widthTestLabel.getPreferredSize().height;
        point.x = bl ? rectangle.x + rectangle.width + 5 : rectangle.x - (n + 5);
        point = SwingUtilities.convertPoint(this.enclosingComp, point, this);
        Point point2 = mouseEvent.getPoint();
        int n3 = this.locationToIndex(point2);
        Rectangle rectangle3 = this.getCellBounds(n3, n3);
        if (rectangle3 != null) {
            point.y = rectangle3.y;
        }
        return point;
    }

    public String getToolTipText() {
        Rectangle rectangle;
        int n = this.getSelectedIndex();
        if (n >= 0 && (rectangle = this.getCellBounds(n, n)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TooltipHack.invokeTip(NavigatorJList.this, (int)rectangle.getCenterX(), (int)rectangle.getCenterY(), Integer.MAX_VALUE);
                }
            });
        }
        return "";
    }

    public boolean isTooltipLocValid(int n, int n2) {
        if (this.curMouseLoc == null || !this.isMouseInside) {
            return false;
        }
        return NavigatorJList.indexAtLocation(this, this.curMouseLoc) == NavigatorJList.indexAtLocation(this, new Point(n, n2));
    }

    private int approximateWidth(String string) {
        widthTestLabel.setText(string);
        return NavigatorJList.widthTestLabel.getPreferredSize().width;
    }

    public static int indexAtLocation(JList jList, Point point) {
        int n = jList.locationToIndex(point);
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (n != -1 && !rectangle.contains(point)) {
            n = -1;
        }
        return n;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.curMouseLoc = mouseEvent.getPoint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.isMouseInside = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isMouseInside = false;
        TooltipHack.invokeTip(this, 0, 0, 0);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void ignoreNextKeyUntilReleased() {
        this.ignoreNextKey = true;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.ignoreNextKey) {
            if (keyEvent.getID() == 402) {
                this.ignoreNextKey = false;
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }
}

