/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.base.TooltipHack;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.NbBundle;

public class NavigatorJTree
extends JTree {
    JLabel widthTestLabel = NavigatorJList.widthTestLabel;
    private JComponent enclosingComp;

    public NavigatorJTree(JComponent jComponent) {
        this.enclosingComp = jComponent;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)NavigatorJTree.class, (String)"ACC_NavTreeName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)NavigatorJTree.class, (String)"ACC_NavTreeDesc"));
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private int approximateWidth(String string) {
        this.widthTestLabel.setText(string);
        return this.widthTestLabel.getPreferredSize().width;
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (this.getSelectionPath() == null && this.getModel().getRoot() != null) {
            this.setSelectionRow(0);
        }
        return bl;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getModel() instanceof NavigatorTreeModel) {
            NavigatorTreeModel navigatorTreeModel = (NavigatorTreeModel)this.getModel();
            Point point = mouseEvent.getPoint();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (AbstractModel.isWaitMarker(object) || AbstractModel.isInvalidMarker(object)) {
                    return null;
                }
                String string = navigatorTreeModel.getTooltip(object);
                if (string != null) {
                    return string;
                }
            }
        }
        return "";
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Container container = this.getTopLevelAncestor();
        Rectangle rectangle = this.enclosingComp.getBounds();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, container);
        boolean bl = rectangle2.x + rectangle2.width < container.getWidth() - rectangle2.x;
        point = SwingUtilities.convertPoint(this, point, this.enclosingComp);
        int n = this.approximateWidth(this.getToolTipText(mouseEvent));
        int n2 = this.widthTestLabel.getPreferredSize().height;
        point.x = bl ? rectangle.x + rectangle.width + 5 : rectangle.x - (n + 10);
        point = SwingUtilities.convertPoint(this.enclosingComp, point, this);
        Point point2 = mouseEvent.getPoint();
        TreePath treePath = this.getPathForLocation(point2.x, point2.y);
        if (treePath != null) {
            Rectangle rectangle3 = this.getPathBounds(treePath);
            point.y = rectangle3.y;
        }
        return point;
    }

    public String getToolTipText() {
        Rectangle rectangle;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TooltipHack.invokeTip(NavigatorJTree.this, (int)rectangle.getCenterX(), (int)rectangle.getCenterY(), Integer.MAX_VALUE);
                }
            });
        }
        return "";
    }
}

