/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import org.netbeans.modules.java.navigation.base.CellRenderer;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.Reorderable;
import org.openide.awt.StatusDisplayer;

class ReorderDragAndDropHandler
implements MouseListener,
MouseMotionListener {
    private Reorderable currReorderable = null;
    private JComponent target = null;
    private Point dragStart = null;
    private CellRenderer rend = null;

    ReorderDragAndDropHandler() {
    }

    private Reorderable getReorderable(Object object) {
        Reorderable reorderable = null;
        if (object instanceof JTree && ((JTree)object).getModel() instanceof Reorderable) {
            reorderable = (Reorderable)((Object)((JTree)object).getModel());
        } else if (object instanceof JList && ((JList)object).getModel() instanceof Reorderable) {
            reorderable = (Reorderable)((Object)((JList)object).getModel());
        }
        return reorderable != null && reorderable.isReorderable() ? reorderable : null;
    }

    private void armDrag(JComponent jComponent, Point point, Reorderable reorderable) {
        if (jComponent instanceof JTree && ((JTree)jComponent).getCellRenderer() instanceof CellRenderer) {
            this.rend = (CellRenderer)((JTree)jComponent).getCellRenderer();
        } else if (jComponent instanceof JList && ((JList)jComponent).getCellRenderer() instanceof CellRenderer) {
            this.rend = (CellRenderer)((JList)jComponent).getCellRenderer();
        } else {
            return;
        }
        this.currReorderable = reorderable;
        this.target = jComponent;
        this.dragStart = point;
    }

    private void abortDrag() {
        this.currReorderable = null;
        this.target = null;
        this.dragStart = null;
        if (this.rend != null) {
            this.rend.setShowDragFeedback(false);
        }
        this.rend = null;
    }

    private void endDrag(MouseEvent mouseEvent) {
        if (this.target instanceof JTree) {
            this.endDragForTree(mouseEvent);
        } else {
            this.endDragForList(mouseEvent);
        }
    }

    private Object selectedObjectAt(Point point) {
        JList jList;
        int n;
        if (this.target instanceof JTree) {
            return null;
        }
        if (this.target instanceof JList && (n = (jList = (JList)this.target).locationToIndex(point)) != -1 && n < jList.getModel().getSize()) {
            return jList.getModel().getElementAt(n);
        }
        return null;
    }

    private void endDragForTree(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDragForList(MouseEvent mouseEvent) {
        JList jList = (JList)this.target;
        int n = jList.locationToIndex(mouseEvent.getPoint());
        if (n == -1 || n >= jList.getModel().getSize()) {
            this.abortDrag();
            return;
        }
        int n2 = jList.locationToIndex(this.dragStart);
        if (n2 == -1 || n2 >= jList.getModel().getSize()) {
            this.abortDrag();
            return;
        }
        if (n2 == n) {
            this.abortDrag();
            return;
        }
        Object e = jList.getModel().getElementAt(n2);
        String string = null;
        Cursor cursor = this.target.getCursor();
        try {
            this.target.setCursor(Cursor.getPredefinedCursor(3));
            string = this.currReorderable.move(e, n);
        }
        finally {
            this.target.setCursor(cursor);
        }
        if (string != null) {
            StatusDisplayer.getDefault().setStatusText(string);
        } else {
            jList.setSelectedIndex(n);
            Action action = ((NavigatorListModel)jList.getModel()).getDefaultAction(e);
            if (action != null) {
                action.actionPerformed(new ActionEvent(jList, 1001, "move"));
            }
        }
        this.abortDrag();
    }

    private boolean isActive(MouseEvent mouseEvent) {
        Point point;
        JList jList;
        boolean bl;
        boolean bl2 = bl = !mouseEvent.isPopupTrigger() && this.currReorderable != null && this.target.contains(mouseEvent.getPoint()) && mouseEvent.getSource() == this.target;
        if (bl && this.target instanceof JList && (jList = (JList)this.target).locationToIndex(point = mouseEvent.getPoint()) == jList.locationToIndex(this.dragStart)) {
            bl = false;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Reorderable reorderable = this.getReorderable(mouseEvent.getSource());
        if (reorderable != null) {
            this.armDrag((JComponent)mouseEvent.getSource(), mouseEvent.getPoint(), reorderable);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isActive(mouseEvent)) {
            this.endDrag(mouseEvent);
        } else {
            this.abortDrag();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isActive(mouseEvent)) {
            boolean bl = this.selectedObjectAt(mouseEvent.getPoint()) != this.selectedObjectAt(this.dragStart);
            this.rend.setShowDragFeedback(bl);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

