/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.NbBundle;

public final class SearchPanel {
    private JPanel searchpanel = null;
    private SearchTextField searchTextField = new SearchTextField();
    private JTree treeTarget = null;
    private JList listTarget = null;
    private SearchKeyProcessor keyProcessor = new SearchKeyProcessor();
    private SearchFieldListener searchFieldListener = new SearchFieldListener();
    private List results = null;

    public SearchPanel() {
        this.searchTextField.addKeyListener(this.searchFieldListener);
        this.searchTextField.addFocusListener(this.searchFieldListener);
        this.searchTextField.getDocument().addDocumentListener(this.searchFieldListener);
    }

    public void prepare(JComponent jComponent) {
        KeyListener[] keyListenerArray = (KeyListener[])jComponent.getListeners(KeyListener.class);
        for (int i = 0; i < keyListenerArray.length; ++i) {
            jComponent.removeKeyListener(keyListenerArray[i]);
        }
        jComponent.addKeyListener(this.keyProcessor);
    }

    private void invoke(JTree jTree) {
        this.treeTarget = jTree;
        this.listTarget = null;
        this.show();
    }

    private void invoke(JList jList) {
        this.treeTarget = null;
        this.listTarget = jList;
        this.show();
    }

    private void detach() {
        if (this.searchpanel.isShowing()) {
            JComponent jComponent = (JComponent)this.searchpanel.getParent();
            this.searchpanel.getParent().remove(this.searchpanel);
            jComponent.repaint(this.searchpanel.getBounds());
        }
        this.results = null;
    }

    private JComponent getTarget() {
        return this.treeTarget == null ? this.listTarget : this.treeTarget;
    }

    private void show() {
        int n;
        this.prepareSearchPanel();
        JComponent jComponent = (JComponent)this.getTarget().getParent().getParent();
        JLayeredPane jLayeredPane = jComponent.getRootPane().getLayeredPane();
        Point point = new Point(jComponent.getWidth() / 2, 5);
        point = SwingUtilities.convertPoint(jComponent, point, jLayeredPane);
        int n2 = jComponent.getWidth() / 2;
        int n3 = n = this.getTarget() instanceof JTree ? ((JTree)this.getTarget()).getRowHeight() + 8 : ((JList)this.getTarget()).getFixedCellHeight() + 8;
        if (n2 < 120) {
            n2 = 160;
            point.x -= 160;
        }
        if (point.x < 0) {
            point.x += jComponent.getWidth();
        }
        this.searchTextField.setFont(this.getTarget().getFont());
        this.searchpanel.setBounds(point.x, point.y, n2, n);
        jLayeredPane.add((Component)this.searchpanel, JLayeredPane.POPUP_LAYER);
        this.searchpanel.setVisible(true);
        this.searchTextField.requestFocus();
    }

    private void prepareSearchPanel() {
        if (this.searchpanel == null) {
            this.searchpanel = new JPanel();
            JLabel jLabel = new JLabel(NbBundle.getMessage((Class)SearchPanel.class, (String)"LBL_QUICKSEARCH"));
            this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
            this.searchpanel.add(jLabel);
            this.searchpanel.add(this.searchTextField);
            jLabel.setLabelFor(this.searchTextField);
            this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
    }

    private List doSearch(String string) {
        JComponent jComponent = this.getTarget();
        if (jComponent == null) {
            System.err.println("SOMETHING IS WRONG!!!");
            return Collections.EMPTY_LIST;
        }
        List list = jComponent instanceof JList ? ((NavigatorListModel)((JList)jComponent).getModel()).getSearchResults(string) : ((NavigatorTreeModel)((JTree)jComponent).getModel()).getSearchResults(string);
        return list;
    }

    private class SearchFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private List results = new ArrayList();
        private int currentSelectionIndex;

        SearchFieldListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                SearchPanel.this.detach();
                keyEvent.consume();
                SearchPanel.this.getTarget().requestFocus();
            } else if (n == 38) {
                --this.currentSelectionIndex;
                this.displaySearchResult();
                keyEvent.consume();
            } else if (n == 40) {
                ++this.currentSelectionIndex;
                this.displaySearchResult();
                keyEvent.consume();
            } else if (n == 9) {
                keyEvent.consume();
            } else if (n == 10) {
                SearchPanel.this.detach();
                this.performAction();
            }
        }

        private void performAction() {
            JComponent jComponent = SearchPanel.this.getTarget();
            if (jComponent instanceof JTree) {
                this.performActionTree();
            } else {
                this.performActionList();
            }
        }

        private void performActionTree() {
            TreeNode treeNode;
            Action action;
            JTree jTree = (JTree)SearchPanel.this.getTarget();
            NavigatorTreeModel navigatorTreeModel = (NavigatorTreeModel)jTree.getModel();
            if (!(jTree.getModel() instanceof NavigatorTreeModel)) {
                return;
            }
            TreePath treePath = jTree.getSelectionPath();
            if (treePath != null && (action = navigatorTreeModel.getDefaultAction(treeNode = (TreeNode)treePath.getLastPathComponent())).isEnabled()) {
                action.actionPerformed(new ActionEvent(jTree, 1001, null));
            }
        }

        private void performActionList() {
            Object e;
            Action action;
            JList jList = (JList)SearchPanel.this.getTarget();
            if (!(jList.getModel() instanceof NavigatorListModel)) {
                return;
            }
            NavigatorListModel navigatorListModel = (NavigatorListModel)jList.getModel();
            int n = jList.getSelectedIndex();
            if (n != -1 && (action = navigatorListModel.getDefaultAction(e = navigatorListModel.getElementAt(n))).isEnabled()) {
                action.actionPerformed(new ActionEvent(jList, 1001, null));
            }
        }

        private void searchForNode() {
            this.currentSelectionIndex = 0;
            this.results = null;
            String string = SearchPanel.this.searchTextField.getText();
            if (string.length() > 0) {
                this.results = SearchPanel.this.doSearch(string);
                this.displaySearchResult();
            }
        }

        private void displaySearchResult() {
            if (this.results == null) {
                return;
            }
            JComponent jComponent = SearchPanel.this.getTarget();
            if (jComponent instanceof JList) {
                this.displaySearchResultList();
            } else {
                this.displaySearchResultTree();
            }
        }

        private void displaySearchResultList() {
            JList jList = (JList)SearchPanel.this.getTarget();
            NavigatorListModel navigatorListModel = (NavigatorListModel)jList.getModel();
            int n = this.results.size();
            if (n > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = n - 1;
                } else if (this.currentSelectionIndex >= n) {
                    this.currentSelectionIndex = 0;
                }
                Object e = this.results.get(this.currentSelectionIndex);
                int n2 = navigatorListModel.indexOf(e);
                jList.setSelectedIndex(n2);
                jList.ensureIndexIsVisible(n2);
            }
        }

        private void displaySearchResultTree() {
            JTree jTree = (JTree)SearchPanel.this.getTarget();
            if (jTree == null) {
                System.err.println("SOMETHING IS VERY WRONG");
                return;
            }
            int n = this.results.size();
            if (n > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = n - 1;
                } else if (this.currentSelectionIndex >= n) {
                    this.currentSelectionIndex = 0;
                }
                TreePath treePath = (TreePath)this.results.get(this.currentSelectionIndex);
                jTree.setSelectionPath(treePath);
                jTree.scrollPathToVisible(treePath);
            } else {
                jTree.clearSelection();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            SearchPanel.this.detach();
        }
    }

    private class SearchKeyProcessor
    extends KeyAdapter {
        private boolean armed = false;

        private SearchKeyProcessor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 521 || n2 == 45 || n2 == 107 || n2 == 109) {
                return;
            }
            if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (!Character.isISOControl(c) && n2 != 16 && n2 != 27) {
                this.armed = true;
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.armed) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                if (keyEvent.getSource() instanceof JTree) {
                    SearchPanel.this.invoke((JTree)keyEvent.getSource());
                } else {
                    SearchPanel.this.invoke((JList)keyEvent.getSource());
                }
                SearchPanel.this.searchTextField.setText(String.valueOf(keyStroke.getKeyChar()));
                keyEvent.consume();
                this.armed = false;
            }
        }
    }

    private class SearchTextField
    extends JTextField {
        private SearchTextField() {
        }

        public boolean isManagingFocus() {
            return true;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                final JComponent jComponent = SearchPanel.this.getTarget();
                SearchPanel.this.detach();
                keyEvent.consume();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jComponent.requestFocus();
                    }
                });
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }
}

