/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.jmi;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefPackage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.jmi.Hacks;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class JUtils {
    private static final Icon defIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/public.gif"));
    private static final HashMap icons = new HashMap(15);
    private static final float NAME_IMPORTANCE = 1.0f;
    private static final float PARAMS_PAREN_IMPORTANCE = 0.8f;
    private static final float PARAMETER_TYPE_IMPORTANCE = 0.25f;
    private static final float PARAMETER_NAME_IMPORTANCE = 0.1f;
    private static final float FIELD_TYPE_IMPORTANCE = 0.3f;
    private static final int IN_DESCRIPTION = 0;
    private static final int IN_PARAM = 1;
    private static final int IN_RETURN = 2;
    private static final int IN_THROWS = 3;
    private static final int IN_OTHER = 99;
    private static boolean askMoveInnerClass = true;
    private static final MDRepository repo = JavaModel.getJavaRepository();
    private static WeakReference lastTooltipForRef;
    private static RequestProcessor.Task tooltipTask;
    private static String lastTooltip;
    private static final Object TOOLTIP_DATA_LOCK;
    static final boolean EXTRA_DECORATIONS;
    private static final String LINK_TAG_START = "{@link ";
    private static final char LINK_TAG_END = '}';

    private JUtils() {
    }

    public static Icon iconFor(Object object) {
        boolean bl;
        Object object2;
        String string = "";
        boolean bl2 = false;
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).getElement();
            bl2 = true;
        }
        if (object instanceof Element && !((Element)object).isValid()) {
            return null;
        }
        if (object instanceof Method) {
            object2 = (Method)object;
            boolean bl3 = bl = (object2.getModifiers() & 8) != 0;
            string = (object2.getModifiers() & 1) != 0 ? (bl ? "methodStPublic" : "methodPublic") : ((object2.getModifiers() & 4) != 0 ? (bl ? "methodStProtected" : "methodProtected") : ((object2.getModifiers() & 2) != 0 ? (bl ? "methodStPrivate" : "methodPrivate") : (bl ? "methodStPackage" : "methodPackage")));
        } else if (object instanceof Constructor) {
            object2 = (Constructor)object;
            string = (object2.getModifiers() & 1) != 0 ? "constructorPublic" : ((object2.getModifiers() & 4) != 0 ? "constructorProtected" : ((object2.getModifiers() & 2) != 0 ? "constructorPrivate" : "constructorPackage"));
        } else if (object instanceof Field) {
            object2 = (Field)object;
            boolean bl4 = bl = (object2.getModifiers() & 8) != 0;
            string = (object2.getModifiers() & 1) != 0 ? (bl ? "variableStPublic" : "variablePublic") : ((object2.getModifiers() & 4) != 0 ? (bl ? "variableStProtected" : "variableProtected") : ((object2.getModifiers() & 2) != 0 ? (bl ? "variableStPrivate" : "variablePrivate") : (bl ? "variableStPackage" : "variablePackage")));
        } else if (object instanceof JavaClass) {
            object2 = (JavaClass)object;
            string = object2.isInterface() ? "interface" : "class2";
        } else if (object instanceof DataObject) {
            string = "class";
        }
        object2 = (Icon)icons.get(bl2 ? string + "_w" : string);
        if (object2 == null) {
            String string2 = "org/netbeans/modules/java/navigation/resources/" + string + ".gif";
            Image image = Utilities.loadImage((String)string2);
            if (bl2) {
                image = JUtils.washOutImage(image);
            }
            if (image != null) {
                object2 = new ImageIcon(image);
                icons.put(bl2 ? string + "_w" : string, object2);
            } else {
                object2 = defIcon;
            }
        }
        return object2;
    }

    private static Image washOutImage(Image image) {
        Image image2 = JUtils.toBufferedImage(image);
        Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
        graphics2D.fillRect(0, 0, 16, 16);
        return image2;
    }

    private static final Image toBufferedImage(Image image) {
        new ImageIcon(image);
        BufferedImage bufferedImage = JUtils.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    private static final BufferedImage createBufferedImage(int n, int n2) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    public static void extractName(WeightedString weightedString, Object object, JavaClass javaClass, boolean bl) {
        if ((object = JUtils.unwrap(object)) instanceof Constructor) {
            Constructor constructor = (Constructor)object;
            JUtils.extractConstructorName(weightedString, constructor, javaClass, bl);
        } else if (object instanceof Method) {
            Method method = (Method)object;
            JUtils.extractMethodName(weightedString, method, javaClass, bl);
        } else if (object instanceof Field) {
            Field field = (Field)object;
            JUtils.extractFieldName(weightedString, field, javaClass, bl);
        } else if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            JUtils.extractParameterName(weightedString, parameter, 0);
        } else if (object instanceof DataObject) {
            weightedString.append(((DataObject)object).getName(), 1.0f);
        } else if (object instanceof JavaClass) {
            JavaClass javaClass2 = (JavaClass)object;
            weightedString.append(javaClass2.getSimpleName(), 1.0f);
        } else if (object instanceof NamedElement) {
            weightedString.append(((NamedElement)object).getName(), 1.0f);
        } else {
            weightedString.append(object.toString(), 1.0f);
        }
    }

    private static void extractMethodName(WeightedString weightedString, Method method, JavaClass javaClass, boolean bl) {
        boolean bl2;
        String string;
        JavaClass javaClass2;
        JavaClass javaClass3 = javaClass2 = bl && method.refImmediateComposite() instanceof JavaClass ? (JavaClass)method.refImmediateComposite() : null;
        if (bl && javaClass2 != javaClass && javaClass2 != null && (string = javaClass2.getSimpleName()).length() > 0) {
            weightedString.startMarkupRun(4);
            weightedString.append(string + ".", 0.7f);
            weightedString.endMarkupRun();
        }
        if (bl2 = method.isDeprecated()) {
            weightedString.startMarkupRun(1);
        }
        if (EXTRA_DECORATIONS) {
            if (Hacks.isOverride(method)) {
                weightedString.startMarkupRun(2);
            }
            if ((method.getModifiers() & 0x10) != 0) {
                weightedString.startMarkupRun(128);
            }
        }
        weightedString.append(method.getName(), 1.0f);
        weightedString.append("(", 0.8f);
        List list = method.getParameters();
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JUtils.extractParameterName(weightedString, (Parameter)iterator.next(), bl2 ? 1 : 0);
                if (!iterator.hasNext()) continue;
                weightedString.append(",", 0.35f);
            }
        }
        weightedString.append(")", 0.8f);
    }

    private static void extractFieldName(WeightedString weightedString, Field field, JavaClass javaClass, boolean bl) {
        CharSequence charSequence;
        JavaClass javaClass2;
        JavaClass javaClass3 = javaClass2 = bl && field.refImmediateComposite() instanceof JavaClass ? (JavaClass)field.refImmediateComposite() : null;
        if (bl && javaClass2 != null && javaClass2 != javaClass) {
            charSequence = javaClass2.getSimpleName();
            weightedString.startMarkupRun(4);
            weightedString.append((String)charSequence + ".", 0.7f);
            weightedString.endMarkupRun();
        }
        if (field.isDeprecated()) {
            weightedString.startMarkupRun(1);
        }
        weightedString.append(field.getName(), 1.0f);
        weightedString.startMarkupRun(4);
        if (field.getType() != null) {
            charSequence = new StringBuffer();
            JUtils.convertToSimpleName(field.getType().getName(), (StringBuffer)charSequence);
            weightedString.append(" " + ((StringBuffer)charSequence).toString(), 0.3f);
        }
    }

    private static void extractConstructorName(WeightedString weightedString, Constructor constructor, JavaClass javaClass, boolean bl) {
        List list;
        JavaClass javaClass2;
        if (constructor.getDeclaringClass() == null) {
            return;
        }
        JavaClass javaClass3 = javaClass2 = bl && constructor.refImmediateComposite() instanceof JavaClass ? (JavaClass)constructor.refImmediateComposite() : null;
        if (bl && javaClass2 != null && javaClass2 != javaClass) {
            weightedString.startMarkupRun(4);
            list = constructor.getDeclaringClass();
            String string = list instanceof JavaClass ? ((JavaClass)list).getSimpleName() : list.getName();
            JUtils.append(weightedString, string + ".", '.', 0.7f);
            weightedString.endMarkupRun();
        }
        list = constructor.getParameters();
        boolean bl2 = constructor.isDeprecated();
        if (bl2) {
            weightedString.startMarkupRun(1);
        }
        JUtils.append(weightedString, constructor.getDeclaringClass().getName(), '.', 1.0f);
        weightedString.append("(", 0.8f);
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JUtils.extractParameterName(weightedString, (Parameter)iterator.next(), bl2 ? 1 : 0);
                if (!iterator.hasNext()) continue;
                weightedString.append(",", 0.35f);
            }
        }
        weightedString.append(")", 0.8f);
    }

    private static void extractParameterName(WeightedString weightedString, Parameter parameter, int n) {
        String string;
        if (!parameter.isValid()) {
            return;
        }
        weightedString.startMarkupRun(4 | n);
        weightedString.append(JUtils.getParameterType(parameter), 0.25f);
        if (parameter.isVarArg()) {
            weightedString.append(" ...", 0.1f);
        }
        if ((string = parameter.getName()) != null && !"".equals(string)) {
            weightedString.append(" " + string, 0.1f);
        }
        weightedString.endMarkupRun();
    }

    private static String getParameterType(Parameter parameter) {
        TypeReference typeReference = parameter.getTypeName();
        if (typeReference != null) {
            return typeReference.getName();
        }
        String string = parameter.getType().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static void append(WeightedString weightedString, String string, char c, float f) {
        int n = string.lastIndexOf(c) + 1;
        if (n != -1 && n < string.length()) {
            char[] cArray = new char[string.length() - n];
            string.getChars(n, string.length(), cArray, 0);
            weightedString.append(cArray, f);
        } else {
            weightedString.append(string, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTooltip(WeightedString weightedString, Object object, JavaClass javaClass, int n, int n2, TipHackInvoker tipHackInvoker) {
        Object object2;
        Object object3 = TOOLTIP_DATA_LOCK;
        synchronized (object3) {
            Object object4 = object2 = lastTooltipForRef == null ? null : (Object)lastTooltipForRef.get();
            if (object2 == object) {
                if (lastTooltip != null) {
                    return lastTooltip;
                }
                return "";
            }
            if (tooltipTask != null) {
                boolean bl = tooltipTask.cancel();
                tooltipTask = null;
            }
            lastTooltipForRef = new WeakReference<Object>(object);
            lastTooltip = null;
        }
        object3 = new TooltipCalculator(object, javaClass, n, n2, tipHackInvoker);
        object2 = TOOLTIP_DATA_LOCK;
        synchronized (object2) {
            tooltipTask = RequestProcessor.getDefault().post((Runnable)object3);
        }
        return "";
    }

    public static String getTooltip(Object object, JavaClass javaClass) {
        RefFeatured refFeatured;
        Object object2 = object;
        if ((object = JUtils.unwrap(object)) instanceof Element && !((Element)object).isValid()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        if (object instanceof Method) {
            JUtils.createMethodTooltip((Method)object, stringBuffer, javaClass);
        } else if (object instanceof Field) {
            JUtils.createFieldTooltip((Field)object, stringBuffer, javaClass);
        } else if (object instanceof Constructor) {
            JUtils.createConstructorTooltip((Constructor)object, stringBuffer, javaClass);
        } else {
            if (object instanceof DataObject) {
                FileObject fileObject = ((DataObject)object).getPrimaryFile();
                if (fileObject != null) {
                    return fileObject.getPath();
                }
                return ((DataObject)object).getName();
            }
            if (object instanceof JavaClass) {
                JUtils.createClassTooltip((JavaClass)object, stringBuffer, javaClass);
            }
        }
        if (object instanceof ClassMember && (refFeatured = ((ClassMember)object).refImmediateComposite()) instanceof JavaClass) {
            stringBuffer.append(" on " + ((JavaClass)refFeatured).getName());
        }
        return stringBuffer.toString();
    }

    private static void includeInnerMessage(Element element, StringBuffer stringBuffer, JavaClass javaClass) {
        JavaClass javaClass2;
        JavaClass javaClass3 = javaClass2 = element.refImmediateComposite() instanceof JavaClass ? (JavaClass)element.refImmediateComposite() : null;
        if (javaClass2 != null && javaClass2.isInner()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            while (javaClass2 != javaClass && javaClass2 != null) {
                stringBuffer2.insert(0, javaClass2.getSimpleName());
                javaClass2 = javaClass2.refImmediateComposite() instanceof JavaClass ? (JavaClass)javaClass2.refImmediateComposite() : null;
            }
            stringBuffer.append(NbBundle.getMessage((Class)JUtils.class, (String)"FMT_InnerClassTip", (Object)stringBuffer2));
            stringBuffer.append("<br>");
        }
    }

    private static void includeOverrideMessage(Method method, StringBuffer stringBuffer) {
        if (Hacks.isOverride(method)) {
            Collection collection = JavaModelUtil.getOverriddenMethods((Method)method);
            if (collection == null) {
                return;
            }
            JavaClass javaClass = method.getDeclaringClass().getSuperClass();
            if (javaClass == null) {
                return;
            }
            Method method2 = javaClass.getMethod(method.getName(), JUtils.getParameterTypeList(method), false);
            boolean bl = method2 == null || (method2.getModifiers() & 0x400) != 0;
            StringBuffer stringBuffer2 = new StringBuffer(30);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Method method3 = (Method)iterator.next();
                ClassDefinition classDefinition = method3.getDeclaringClass();
                stringBuffer2.append(classDefinition.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer2.append(", ");
            }
            stringBuffer.append("<br><hr>");
            stringBuffer.append(NbBundle.getMessage((Class)JUtils.class, (String)(bl ? "FMT_ImplementsTip" : "FMT_OverrideTip"), (Object[])new Object[]{method.getName(), stringBuffer2.toString()}));
        }
    }

    private static void includeDocumentedAnnotations(AnnotableElement annotableElement, StringBuffer stringBuffer) {
        Iterator iterator = annotableElement.getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            AnnotationType annotationType = annotation.getType();
            if (annotationType == null) continue;
            annotationType = (AnnotationType)JUtils.getSourceForBinary((ClassDefinition)annotationType);
            Iterator iterator2 = annotationType.getAnnotations().iterator();
            while (iterator2.hasNext()) {
                AnnotationType annotationType2 = (AnnotationType)JUtils.getSourceForBinary((ClassDefinition)((Annotation)iterator2.next()).getType());
                if (annotationType2 == null || !"java.lang.annotation.Documented".equals(annotationType2.getName())) continue;
                stringBuffer.append("@" + JUtils.getTypeName((Type)annotationType));
                List list = annotation.getAttributeValues();
                if (!list.isEmpty()) {
                    try {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        Iterator iterator3 = list.iterator();
                        while (iterator3.hasNext()) {
                            AttributeValue attributeValue = (AttributeValue)iterator3.next();
                            stringBuffer2.append(attributeValue.getDefinition().getName());
                            stringBuffer2.append('=');
                            PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition((Element)attributeValue.getValue());
                            if (positionBounds == null) {
                                stringBuffer2 = null;
                                break;
                            }
                            stringBuffer2.append(positionBounds.getText());
                            if (!iterator3.hasNext()) continue;
                            stringBuffer2.append(", ");
                        }
                        if (stringBuffer2 != null) {
                            stringBuffer.append('(');
                            stringBuffer.append(stringBuffer2);
                            stringBuffer.append(')');
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                stringBuffer.append("<br>");
            }
        }
    }

    private static String getTypeName(Type type) {
        String string = null;
        if (type instanceof Array) {
            string = JUtils.getTypeName(((Array)type).getType()) + "[]";
        }
        if (type instanceof AnnotationType || type instanceof ParameterizedType && ((ParameterizedType)type).getDefinition() instanceof AnnotationType) {
            string = "@" + ((JavaClass)type).getSimpleName();
        }
        if (type instanceof JavaClass) {
            string = ((JavaClass)type).getSimpleName();
        }
        string = string.replaceAll("<", "&lt;");
        return string.replaceAll(">", "&gt;");
    }

    private static List getParameterTypeList(Method method) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = method.getParameters().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Parameter)iterator.next()).getType());
        }
        return arrayList;
    }

    private static void createMethodTooltip(Method method, StringBuffer stringBuffer, JavaClass javaClass) {
        Method method2;
        String string;
        stringBuffer.append("<html>");
        JUtils.getModifiers(method.getModifiers(), stringBuffer);
        if (method.getType().getName() != null) {
            JUtils.htmlizeTypeName(method.getType().getName(), stringBuffer, false);
        } else {
            JUtils.htmlizeTypeName("void", stringBuffer, false);
        }
        stringBuffer.append(' ');
        stringBuffer.append("<b><font color=#7C0000>");
        stringBuffer.append(method.getName());
        stringBuffer.append("</b></font>");
        JUtils.appendParameterList(method.getParameters(), stringBuffer);
        stringBuffer.append("<br>");
        List list = method.getAnnotations();
        if (list != null && list.size() > 0) {
            JUtils.includeDocumentedAnnotations((AnnotableElement)method, stringBuffer);
        }
        if (javaClass != null) {
            JUtils.includeInnerMessage((Element)method, stringBuffer, javaClass);
        }
        if (((string = method.getJavadocText()) == null || string.length() == 0) && (method2 = JUtils.findSuperWithJavadoc(method)) != null) {
            string = method2.getJavadocText();
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append("<hr>");
            stringBuffer.append(JUtils.htmlize(string));
        }
        JUtils.includeOverrideMessage(method, stringBuffer);
        stringBuffer.append("</html>");
    }

    private static Method findSuperWithJavadoc(Method method) {
        RefFeatured refFeatured = method.refImmediateComposite();
        if (refFeatured instanceof JavaClass) {
            Method method2;
            JavaClass javaClass = (JavaClass)refFeatured;
            JavaClass javaClass2 = javaClass.getSuperClass();
            if (javaClass2 != null && (method2 = javaClass2.getMethod(method.getName(), JUtils.obtainParamTypes(method.getParameters()), true)) != null) {
                String string = method2.getJavadocText();
                if (string != null && string.trim().length() > 0) {
                    return method2;
                }
                return JUtils.findSuperWithJavadoc(method2);
            }
            method2 = javaClass.getInterfaces().iterator();
            while (method2.hasNext()) {
                String string;
                JavaClass javaClass3;
                Method method3;
                Object e = method2.next();
                if (!(e instanceof JavaClass) || (method3 = (javaClass3 = (JavaClass)e).getMethod(method.getName(), JUtils.obtainParamTypes(method.getParameters()), true)) == null || (string = method3.getJavadocText()) == null || string.length() <= 0) continue;
                return method3;
            }
        }
        return null;
    }

    private static List obtainParamTypes(List list) {
        int n = list.size();
        if (n == 0) {
            return list;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Parameter)iterator.next()).getType());
        }
        return arrayList;
    }

    private static void appendParameterList(List list, StringBuffer stringBuffer) {
        stringBuffer.append(" ( ");
        int n = stringBuffer.length() - 61;
        HashSet hashSet = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            String string = parameter.getType().getName();
            if ((n += string.length()) + string.length() + (parameter.getTypeName() == null ? 0 : parameter.getTypeName().getName().length()) > 120) {
                stringBuffer.append("<br>&nbsp;&nbsp;   ");
                n = 0;
            }
            JUtils.htmlizeTypeName(string, stringBuffer, false);
            stringBuffer.append(' ');
            if (parameter.getName() != null) {
                stringBuffer.append("<font color=#B200B2>");
                stringBuffer.append(parameter.getName());
                stringBuffer.append("</font>");
                n += parameter.getName().length();
            } else {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                String string2 = JUtils.generateBelievableParameterName(parameter, hashSet);
                stringBuffer.append("<font color=#B200B2>");
                stringBuffer.append(string2);
                stringBuffer.append("</font>");
                n += string2.length();
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
            n += 2;
        }
        stringBuffer.append(" )");
    }

    static void separateClassName(String string, StringBuffer stringBuffer) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string.substring(n + 1));
        } else {
            stringBuffer.append(string);
        }
    }

    static void convertToSimpleName(String string, StringBuffer stringBuffer) {
        int n = string.indexOf(60);
        if (n == -1) {
            JUtils.separateClassName(string, stringBuffer);
            return;
        }
        if (string.charAt(string.length() - 1) != '>') {
            JUtils.separateClassName(string, stringBuffer);
            return;
        }
        JUtils.separateClassName(string.substring(0, n), stringBuffer);
        stringBuffer.append("<");
        int n2 = n + 1;
        while (n2 < string.length()) {
            int n3;
            int n4 = 0;
            block5: for (n3 = n2; n3 < string.length() && (string.charAt(n3) != ',' || n4 > 0); ++n3) {
                switch (string.charAt(n3)) {
                    case '<': {
                        ++n4;
                        continue block5;
                    }
                    case '>': {
                        --n4;
                    }
                }
            }
            String string2 = string.substring(n2, n3);
            int n5 = string2.lastIndexOf(32);
            if (n5 == -1) {
                JUtils.convertToSimpleName(string2, stringBuffer);
            } else {
                stringBuffer.append(string2.substring(0, n5));
                stringBuffer.append(' ');
                JUtils.convertToSimpleName(string2.substring(n5 + 1), stringBuffer);
            }
            if ((n2 = n3 + 1) >= string.length()) continue;
            stringBuffer.append(", ");
        }
    }

    private static void htmlizeTypeName(String string, StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append("<b><font color=#77000>");
        }
        JUtils.convertToSimpleName(string, stringBuffer);
        block4: for (int i = stringBuffer.length(); i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '<': {
                    stringBuffer.replace(i, i + 1, "&lt;");
                    continue block4;
                }
                case '>': {
                    stringBuffer.replace(i, i + 1, "&gt;");
                }
            }
        }
        if (bl) {
            stringBuffer.append("</font></b>");
        }
    }

    private static String htmlize(String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken().trim();
            if (!(string2 = JUtils.extractLinks(string2)).startsWith("@")) {
                stringBuffer2.append(string2 + " ");
                continue;
            }
            JUtils.wrapText(stringBuffer2.toString(), stringBuffer);
            stringBuffer2.delete(0, stringBuffer2.length());
            for (n2 = 1; n2 < string2.length() && Character.isJavaIdentifierPart(string2.charAt(n2)); ++n2) {
            }
            if (n2 == 1) continue;
            int n3 = 0;
            String string3 = string2.substring(1, n2);
            n3 = string3.equals("param") ? 1 : (string3.equals("return") ? 2 : (string3.equals("throws") || string3.equals("exception") ? 3 : 99));
            if (n == 0 && n != 99) {
                stringBuffer.append("<dl>");
            }
            if (n3 != n) {
                stringBuffer.append("<dt><b>");
                switch (n3) {
                    case 1: {
                        stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ParametersTerm") + ":");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ReturnsTerm") + ":");
                        break;
                    }
                    case 3: {
                        stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$navigation$jmi$JUtils == null ? JUtils.class$("org.netbeans.modules.java.navigation.jmi.JUtils") : class$org$netbeans$modules$java$navigation$jmi$JUtils), (String)"FMT_ThrowsTerm") + ":");
                        break;
                    }
                }
                stringBuffer.append("</b>");
                stringBuffer.append("<dd>");
            } else if (n3 != 0 && n3 != 99) {
                stringBuffer.append("<dd>");
            }
            if (n3 == 1) {
                int n4;
                stringBuffer2.append("<code>");
                for (n4 = Math.min(n2 + 1, string2.length()); n4 < string2.length() && Character.isWhitespace(string2.charAt(n4)); ++n4) {
                }
                n2 = n4;
                while (n4 < string2.length() && Character.isJavaIdentifierPart(string2.charAt(n4))) {
                    ++n4;
                }
                stringBuffer2.append(string2.substring(n2, n4));
                stringBuffer2.append("</code> - ");
                n2 = n4;
            }
            if (n3 != 99) {
                stringBuffer2.append(string2.substring(n2) + " ");
            }
            n = n3;
        }
        JUtils.wrapText(stringBuffer2.toString(), stringBuffer);
        if (n != 0) {
            stringBuffer.append("</dl>");
        }
        return stringBuffer.toString();
    }

    private static void wrapText(String string, StringBuffer stringBuffer) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken().toLowerCase();
            int n3 = string2.length();
            int n4 = JUtils.findHtmlBreakPos(string2);
            int n5 = n2 = n4 == -1 ? n3 : n4;
            if (n + n2 > 90) {
                stringBuffer.append("<br>");
                n = 0;
            }
            stringBuffer.append(string2 + " ");
            n = n4 == -1 ? (n += n3 + 1) : Math.max(0, n3 - n2 - 7);
            if (!string2.endsWith("</br>") && !string2.endsWith("</p>")) continue;
            n = 0;
        }
    }

    private static int findHtmlBreakPos(String string) {
        int n = string.indexOf("<p>");
        if (n == -1) {
            n = string.indexOf("<br>");
        }
        return n;
    }

    private static void createFieldTooltip(Field field, StringBuffer stringBuffer, JavaClass javaClass) {
        String string;
        stringBuffer.append("<html>");
        JUtils.getModifiers(field.getModifiers(), stringBuffer);
        stringBuffer.append(field.getType().getName());
        stringBuffer.append(' ');
        stringBuffer.append("<b><font color=#0000B2>");
        stringBuffer.append(field.getName());
        stringBuffer.append("</font></b>");
        if (javaClass != null) {
            JUtils.includeInnerMessage((Element)field, stringBuffer, javaClass);
        }
        if ((string = field.getJavadocText()) != null && string.length() > 0) {
            stringBuffer.append("<br>");
            stringBuffer.append("<hr>");
            stringBuffer.append(JUtils.htmlize(string));
        }
        stringBuffer.append("</html>");
    }

    private static void createConstructorTooltip(Constructor constructor, StringBuffer stringBuffer, JavaClass javaClass) {
        String string = constructor.getJavadocText();
        stringBuffer.append("<html>");
        JUtils.getModifiers(constructor.getModifiers(), stringBuffer);
        stringBuffer.append("<b><font color=#B28C00>");
        stringBuffer.append(((JavaClass)constructor.refImmediateComposite()).getSimpleName());
        stringBuffer.append("</font></b>");
        JUtils.appendParameterList(constructor.getParameters(), stringBuffer);
        if (javaClass != null) {
            JUtils.includeInnerMessage((Element)constructor, stringBuffer, javaClass);
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append("<br>");
            stringBuffer.append("<hr>");
            stringBuffer.append(JUtils.htmlize(string));
        }
        stringBuffer.append("</html>");
    }

    private static void createClassTooltip(JavaClass javaClass, StringBuffer stringBuffer, JavaClass javaClass2) {
        String string = javaClass.getJavadocText();
        stringBuffer.append("<html>");
        stringBuffer.append(javaClass.getName());
        if (string != null && string.length() > 0) {
            stringBuffer.append("<br>");
            stringBuffer.append("<hr>");
            stringBuffer.append(JUtils.htmlize(string));
        }
        stringBuffer.append("</html>");
    }

    private static void getModifiers(int n, StringBuffer stringBuffer) {
        boolean bl = false;
        if ((n & 1) != 0) {
            stringBuffer.append("public");
            bl = true;
        } else if ((n & 4) != 0) {
            stringBuffer.append("protected");
            bl = true;
        } else if ((n & 2) != 0) {
            stringBuffer.append("private");
            bl = true;
        }
        if ((n & 0x400) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("abstract");
            bl = true;
        }
        if ((n & 8) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("static");
            bl = true;
        }
        if ((n & 0x10) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("final");
            bl = true;
        }
        if ((n & 0x100) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("native");
            bl = true;
        }
        if ((n & 0x20) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("synchronized");
            bl = true;
        }
        if ((n & 0x80) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("transient");
            bl = true;
        }
        if ((n & 0x40) != 0) {
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("volatile");
            bl = true;
        }
        if (bl) {
            stringBuffer.append(' ');
        }
    }

    public static String generateBelievableParameterName(Parameter parameter, Set set) {
        int n;
        String string;
        String string2 = parameter.getType().getName();
        boolean bl = false;
        if (string2.endsWith("Listener")) {
            string = "l";
        } else if (string2.equals("java.lang.Object")) {
            string = "o";
        } else if (string2.equals("java.lang.Class")) {
            string = "clazz";
        } else if (string2.endsWith("Stream")) {
            string = "stream";
        } else {
            int n2;
            string = string2.toLowerCase();
            n = string2.indexOf("[");
            if (n > 0) {
                string2 = string2.substring(0, n - 1);
            }
            if ((n2 = string.lastIndexOf(".")) != -1) {
                string = string.substring(n2 + 1);
            }
            bl = true;
        }
        if (string.trim().length() == 0) {
            string = "value";
        }
        if ((n = string.indexOf("[")) > 0) {
            string = string.substring(0, n);
            if (bl) {
                string = string + "s";
            }
        }
        if (!Utilities.isJavaIdentifier((String)string2)) {
            string = new String(new char[string2.charAt(0)]);
        }
        if (JUtils.isPrimitiveTypeName(string)) {
            string = new String(new char[]{string.charAt(0)});
        }
        if (string.length() > 7) {
            string = JUtils.tryMakeAcronym(string);
        }
        String string3 = string;
        int n3 = 0;
        while (set.contains(string3)) {
            string3 = string + ++n3;
        }
        string = string3;
        set.add(string);
        return string;
    }

    public static boolean isPrimitiveTypeName(String string) {
        return "void".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string) || "short".equals(string) || "char".equals(string) || "boolean".equals(string);
    }

    private static String tryMakeAcronym(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isUpperCase(cArray[i])) continue;
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() > 1) {
            return stringBuffer.toString().toLowerCase();
        }
        return string;
    }

    public static List getClassMembers(JavaDataObject javaDataObject, boolean bl, JavaClass[] javaClassArray, boolean bl2) {
        List list = null;
        Resource resource = Hacks.getResourceForDataObject(javaDataObject);
        if (resource != null && resource.isValid()) {
            JavaModel.setClassPath((Resource)resource);
            boolean bl3 = false;
            Iterator iterator = resource.getClassifiers().iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass = (JavaClass)iterator.next();
                if (javaClassArray[0] == null) {
                    javaClassArray[0] = javaClass;
                }
                if (list == null) {
                    list = javaClass.getFeatures();
                } else {
                    if (!bl3) {
                        List list2 = list;
                        list = new ArrayList();
                        list.addAll(list2);
                        bl3 = true;
                    }
                    list.addAll(javaClass.getFeatures());
                }
                if (bl2) {
                    list = JUtils.addInnerClassMembers(list, bl);
                }
                if (!bl) continue;
                list = JUtils.addInheritedMembers((ClassDefinition)javaClass, list, javaClass);
            }
            if (list != null) {
                list = new ArrayList(new HashSet(list));
            }
        }
        return list;
    }

    public static List getClassMembers(JavaClass javaClass, boolean bl, boolean bl2) {
        JavaModel.setClassPath((Resource)javaClass.getResource());
        ArrayList arrayList = javaClass.getFeatures();
        if (bl2) {
            arrayList = JUtils.addInnerClassMembers(arrayList, bl);
        }
        if (bl) {
            arrayList = JUtils.addInheritedMembers((ClassDefinition)javaClass, arrayList, javaClass);
        }
        if (arrayList != null) {
            arrayList = new ArrayList(new HashSet(arrayList));
        }
        return arrayList;
    }

    public static List addInnerClassMembers(List list, boolean bl) {
        Object object;
        if (!(list instanceof ArrayList) && !(list instanceof LinkedList)) {
            list = new LinkedList(list);
        }
        ArrayList arrayList = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof Initializer) {
                iterator.remove();
                continue;
            }
            if (!(object instanceof JavaClass)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(object);
            iterator.remove();
        }
        if (arrayList != null) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (JavaClass)iterator.next();
                list = JUtils.addInnerClassMembers(object, list, bl);
            }
        }
        return list;
    }

    private static List addInnerClassMembers(JavaClass javaClass, List list, boolean bl) {
        List list2 = javaClass.getFeatures();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Initializer) continue;
            if (e instanceof JavaClass) {
                list = JUtils.addInnerClassMembers((JavaClass)e, list, bl);
                continue;
            }
            list.add(e);
        }
        return list;
    }

    private static List addInheritedMembers(ClassDefinition classDefinition, List arrayList, JavaClass javaClass) {
        Object object;
        JavaClass javaClass2;
        if (!(arrayList instanceof ArrayList)) {
            arrayList = new ArrayList(arrayList);
        }
        ClassDefinition classDefinition2 = classDefinition;
        if (classDefinition instanceof JavaClass && !((JavaClass)classDefinition).isInterface()) {
            javaClass2 = classDefinition.getSuperClass();
            if (javaClass2 == null) {
                return arrayList;
            }
            object = JUtils.getSourceForBinary((ClassDefinition)javaClass2);
            classDefinition2 = object == null ? javaClass2 : object;
            JUtils.addItemMembers(classDefinition2, arrayList, javaClass);
            JUtils.addInheritedMembers(classDefinition2, arrayList, javaClass);
        }
        javaClass2 = classDefinition2.getInterfaces().iterator();
        while (javaClass2.hasNext()) {
            object = javaClass2.next();
            if (!(object instanceof JavaClass)) continue;
            JUtils.addItemMembers((ClassDefinition)((JavaClass)object), arrayList, javaClass);
            JUtils.addInheritedMembers((ClassDefinition)((JavaClass)object), arrayList, javaClass);
        }
        return arrayList;
    }

    private static void addItemMembers(ClassDefinition classDefinition, List list, JavaClass javaClass) {
        Iterator iterator = classDefinition.getFeatures().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!JUtils.isDisplayableInheritedMember(e, javaClass)) continue;
            list.add(new Wrapper((Element)e, javaClass));
        }
    }

    public static ClassDefinition getSourceForBinary(ClassDefinition classDefinition) {
        return ((JMManager)JavaMetamodel.getManager()).getSourceElementIfExists(classDefinition);
    }

    private static boolean isDisplayableInheritedMember(Object object, JavaClass javaClass) {
        boolean bl;
        if (!(object instanceof Method || object instanceof Field || object instanceof Constructor)) {
            return false;
        }
        ClassMember classMember = (ClassMember)object;
        RefPackage refPackage = javaClass.refImmediatePackage();
        RefPackage refPackage2 = classMember.refImmediatePackage();
        boolean bl2 = refPackage == null && refPackage2 == null || refPackage != null && refPackage.equals(refPackage2);
        int n = classMember.getModifiers();
        boolean bl3 = bl = (n & 1) != 0 || (n & 4) != 0 || bl2 && (n & 2) == 0 || classMember.refImmediateComposite() == javaClass;
        if (bl && object instanceof Method) {
            bl = !JUtils.isOverridenAnywhere(javaClass, (Method)object);
        }
        return bl;
    }

    public static Object unwrap(Object object) {
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).getElement();
        }
        return object;
    }

    public static boolean isWrapper(Object object) {
        return object instanceof Wrapper;
    }

    public static boolean overridesMethod(JavaClass javaClass, Method method) {
        if (javaClass == null) {
            return false;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = method.getParameters().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Parameter)iterator.next()).getType());
        }
        try {
            return javaClass.getMethod(method.getName(), arrayList, false) != null;
        }
        catch (NullPointerException nullPointerException) {
            NullPointerException nullPointerException2 = new NullPointerException("NPE: target " + javaClass + " method " + method);
            ErrorManager.getDefault().annotate((Throwable)nullPointerException2, (Throwable)nullPointerException);
            throw nullPointerException2;
        }
    }

    private static boolean isOverridenAnywhere(JavaClass javaClass, Method method) {
        JavaClass javaClass2 = (JavaClass)method.getDeclaringClass();
        List list = method.getParameters();
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            arrayList.add(((Parameter)object.next()).getType());
        }
        object = method.getName();
        String string = javaClass2.getName();
        for (JavaClass javaClass3 = javaClass; javaClass3 != null && !string.equals(javaClass3.getName()); javaClass3 = javaClass3.getSuperClass()) {
            if (javaClass3.getMethod((String)object, arrayList, false) == null) continue;
            return true;
        }
        return false;
    }

    public static String move(ClassMember classMember, ClassMember classMember2) {
        JavaClass javaClass;
        if (classMember.equals(classMember2)) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CanMoveToSelf");
        }
        if (classMember.refImmediateComposite() instanceof JavaClass && classMember2.refImmediateComposite() instanceof JavaClass) {
            JavaClass javaClass2;
            javaClass = (JavaClass)classMember.refImmediateComposite();
            if (!javaClass.equals(javaClass2 = (JavaClass)classMember2.refImmediateComposite())) {
                if (javaClass.isInner() && javaClass.refImmediateComposite() == javaClass2) {
                    return JUtils.askMoveEntireInnerClass(javaClass2, javaClass, (Element)classMember2, (Element)classMember);
                }
                return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CantMove");
            }
        } else {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CantMove");
        }
        JUtils.repositionElementWithinClass((Element)classMember, (Element)classMember2, javaClass);
        return null;
    }

    private static void repositionElementWithinClass(Element element, Element element2, JavaClass javaClass) {
        List list = javaClass.getFeatures();
        int n = list.indexOf(element);
        int n2 = list.indexOf(element2);
        if (n != -1 && n2 != -1) {
            list.remove(n);
            if (n2 > n) {
                --n2;
            }
            list.add(n2, element);
        }
    }

    private static String qualifiedNameOf(Object object) {
        if (object instanceof Constructor) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"FMT_Constructor", (Object)((Constructor)object).getDeclaringClass().getName());
        }
        return ((Feature)object).getName();
    }

    private static String askMoveEntireInnerClass(JavaClass javaClass, JavaClass javaClass2, Element element, Element element2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2 = bl = !askMoveInnerClass;
        if (!bl) {
            object3 = NbBundle.getMessage((Class)JUtils.class, (String)"TITLE_MoveInnerClass");
            String string = NbBundle.getMessage((Class)JUtils.class, (String)"MSG_AskMoveInnerClass", (Object[])new Object[]{JUtils.qualifiedNameOf(element2), javaClass2.getSimpleName()});
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            object2 = new JTextArea(string);
            ((JComponent)object2).setOpaque(false);
            ((JTextComponent)object2).setEditable(false);
            ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
            object = new JCheckBox(NbBundle.getMessage((Class)JUtils.class, (String)"MSG_AlwaysDoThis"));
            jPanel.add((Component)object2, "Center");
            jPanel.add((Component)object, "South");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)jPanel, (String)object3, 0, 3, null, NotifyDescriptor.YES_OPTION);
            bl = NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify(notifyDescriptor));
            askMoveInnerClass = ((AbstractButton)object).isSelected();
            if (!bl) {
                return "";
            }
        }
        object3 = javaClass.getContents();
        int n = object3.indexOf(element);
        int n2 = -1;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            ++n2;
            object = object2.next();
            if (!object.equals(javaClass2)) continue;
        }
        if (n2 == -1 || n2 == object3.size() || n == -1) {
            return NbBundle.getMessage((Class)JUtils.class, (String)"MSG_CouldNotLocateClass", (Object)javaClass2.getSimpleName());
        }
        object3.remove(n2);
        try {
            if (n2 < n) {
                --n;
            }
            object3.add(n, javaClass2);
        }
        catch (Exception exception) {
            object3.add(n2, javaClass2);
            object = NbBundle.getMessage((Class)JUtils.class, (String)"MSG_MoveFailed");
            ErrorManager.getDefault().annotate((Throwable)exception, object);
            ErrorManager.getDefault().notify(256, (Throwable)exception);
            return object;
        }
        return null;
    }

    private static String extractLinks(String string) {
        int n = string.indexOf(LINK_TAG_START);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n2 = 0;
        int n3 = -1;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            n3 = string.indexOf(125, n);
            if (n3 == -1) {
                stringBuffer.append(string.substring(n + 7));
                break;
            }
            stringBuffer.append(string.substring(n + 7, n3));
            n2 = n3 + 1;
            n = string.indexOf(LINK_TAG_START, n3);
        }
        if (n3 != -1 && n3 + 1 < string.length()) {
            stringBuffer.append(string.substring(n3 + 1));
        }
        return stringBuffer.toString();
    }

    static {
        TOOLTIP_DATA_LOCK = new Object();
        EXTRA_DECORATIONS = Boolean.getBoolean("nb.navigator.decorate");
    }

    private static final class Wrapper {
        final Element element;
        final JavaClass clazz;

        public Wrapper(Element element, JavaClass javaClass) {
            this.element = element;
            this.clazz = javaClass;
        }

        public Element getElement() {
            return this.element;
        }

        public JavaClass getOwner() {
            return this.clazz;
        }

        public String toString() {
            return this.clazz.getName() + "." + this.element;
        }

        public int hashCode() {
            return this.clazz.getName().hashCode() * 31 ^ this.element.hashCode();
        }

        public String getClassName() {
            return this.clazz.getSimpleName();
        }

        public boolean equals(Object object) {
            if (object instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)object;
                return wrapper.element == this.element && wrapper.clazz == this.clazz;
            }
            return false;
        }
    }

    public static interface TipHackInvoker {
        public void invokeTip(int var1, int var2);
    }

    private static class TooltipCalculator
    implements Runnable {
        private Object tooltipFor;
        private JavaClass jc;
        private int x;
        private int y;
        private TipHackInvoker invoker;

        TooltipCalculator(Object object, JavaClass javaClass, int n, int n2, TipHackInvoker tipHackInvoker) {
            this.tooltipFor = object;
            this.jc = javaClass;
            this.x = n;
            this.y = n2;
            this.invoker = tipHackInvoker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string;
            repo.beginTrans(false);
            try {
                string = JUtils.getTooltip(this.tooltipFor, this.jc);
            }
            finally {
                repo.endTrans(false);
            }
            Object object = TOOLTIP_DATA_LOCK;
            synchronized (object) {
                tooltipTask = null;
                if (lastTooltipForRef != null && lastTooltipForRef.get() != this.tooltipFor) {
                    return;
                }
                lastTooltip = string;
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ TooltipCalculator this$0;
                {
                    this.this$0 = tooltipCalculator;
                }

                public void run() {
                    TooltipCalculator.access$700(this.this$0).invokeTip(TooltipCalculator.access$500(this.this$0), TooltipCalculator.access$600(this.this$0));
                }
            });
        }

        static /* synthetic */ int access$500(TooltipCalculator tooltipCalculator) {
            return tooltipCalculator.x;
        }

        static /* synthetic */ int access$600(TooltipCalculator tooltipCalculator) {
            return tooltipCalculator.y;
        }

        static /* synthetic */ TipHackInvoker access$700(TooltipCalculator tooltipCalculator) {
            return tooltipCalculator.invoker;
        }
    }
}

