/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.ListModelSupport;
import org.netbeans.modules.java.navigation.spi.TreeModelSupport;

public abstract class AbstractModel {
    private TreeModelSupport tree = null;
    List tempList = null;
    private TreePath path = null;

    protected AbstractModel() {
        if (!TreeModelSupport.class.isAssignableFrom(this.getClass()) && !ListModelSupport.class.isAssignableFrom(this.getClass())) {
            throw new Error("Only ListModelSupport and TreeModelSupport may subclass AbstractModelSupport");
        }
    }

    protected abstract List loadContents();

    public final void addNotify() {
        this.doAddNotify();
        TreeModelSupport treeModelSupport = this.getTree();
        if (this.tree != null) {
            // empty if block
        }
    }

    abstract void doAddNotify();

    protected abstract void removeNotify();

    protected abstract List getSearchResults(String var1);

    protected abstract boolean isActive();

    protected abstract List getList();

    protected abstract boolean isReady();

    protected abstract void startListening();

    protected abstract void stopListening();

    protected abstract void addChangeListener(ChangeListener var1) throws TooManyListenersException;

    protected abstract void removeChangeListener(ChangeListener var1);

    abstract boolean owns(Object var1);

    abstract int getSize();

    abstract Object getElementAt(int var1);

    abstract int indexOf(Object var1);

    AbstractModel findModelFor(Object object, boolean bl) {
        return this.owns(object) ? this : null;
    }

    void setTree(TreeModelSupport treeModelSupport) {
        this.tree = treeModelSupport;
    }

    List getLoadingTempList() {
        if (this.tempList == null) {
            this.tempList = Arrays.asList(AbstractModel.createWaitMarker());
        }
        return this.tempList;
    }

    TreeModelSupport getTree() {
        return this.tree;
    }

    TreeModelSupport getRootTree() {
        TreeModelSupport treeModelSupport = this.getTree();
        if (treeModelSupport != null) {
            return treeModelSupport.getRootTree();
        }
        if (this instanceof TreeModelSupport) {
            return (TreeModelSupport)this;
        }
        return null;
    }

    int fullSize() {
        return this.getSize();
    }

    void setPath(TreePath treePath) {
        this.path = treePath;
    }

    TreePath getPath() {
        return this.path;
    }

    static TreePath combine(TreePath treePath, TreePath treePath2) {
        if (treePath == null || treePath.getPathComponent(0) == treePath2.getPathComponent(0)) {
            return treePath2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(treePath.getPathCount() + treePath2.getPathCount());
        arrayList.addAll(Arrays.asList(treePath.getPath()));
        arrayList.addAll(Arrays.asList(treePath2.getPath()));
        return new TreePath(arrayList.toArray());
    }

    public static final Object createInvalidMarker() {
        return new Unique(true);
    }

    public static final Object createWaitMarker() {
        return new Unique(true);
    }

    public static final boolean isWaitMarker(Object object) {
        return object instanceof Unique && ((Unique)object).wait;
    }

    public static final boolean isInvalidMarker(Object object) {
        return object instanceof Unique && !((Unique)object).wait;
    }

    private static final class Unique {
        final boolean wait;

        Unique(boolean bl) {
            this.wait = bl;
        }

        public String toString() {
            return this.wait ? "wait" : "unique";
        }
    }
}

