/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.java.navigation.base.ModelBusyListener;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.ExtListDataEvent;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.diff.Change;
import org.netbeans.modules.java.navigation.spi.diff.Diff;
import org.netbeans.modules.java.navigation.spi.diff.ListDiff;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class ListModelSupport
extends AbstractModel
implements NavigatorListModel {
    private boolean invalid = false;
    private final boolean singleClick;
    List list = null;
    private volatile boolean active;
    private List listeners = Collections.synchronizedList(new ArrayList(2));
    private ChangeManager changeManager = null;
    private Loader loader = null;
    protected static final RequestProcessor rp;
    private static Thread rpThread;
    private static ListModelSupport waitingModel;
    private boolean updateAsync = false;
    private boolean readAsync = true;
    private int retryCount = 0;
    private ChangeListener changeListener = null;
    private ModelBusyListener busyListener = null;
    private static final Object START_STOP_LISTENING_LOCK;
    static long cumulateTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ListModelSupport() {
        this(true);
    }

    protected ListModelSupport(boolean bl) {
        this.singleClick = bl;
    }

    protected ListModelSupport(boolean bl, boolean bl2, boolean bl3) {
        this(bl);
        this.readAsync = bl2;
        this.updateAsync = bl3;
    }

    public List getSearchResults(String string) {
        if (this.list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string2 = this.getName(e).toString().toUpperCase();
            if (!string2.startsWith(string)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected final List getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"getList may only becalled on the dispatch thread");
        }
        return this.list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.list);
    }

    boolean owns(Object object) {
        return this.list == null || this.invalid ? false : this.list.contains(object);
    }

    public int indexOf(Object object) {
        return this.list == null || this.invalid ? -1 : this.list.indexOf(object);
    }

    protected final boolean isUpdateAsync() {
        return this.updateAsync;
    }

    protected final boolean isReadAsync() {
        return this.readAsync;
    }

    protected Task getWaitTask() {
        return null;
    }

    protected void startListening() {
    }

    protected void stopListening() {
    }

    protected abstract List loadContents();

    protected void updated() {
    }

    protected void cancelWaitTask(Cancellable cancellable) {
        cancellable.cancel();
    }

    protected final boolean isActive() {
        return this.active;
    }

    public final boolean isReady() {
        return this.list != null;
    }

    public final void addChangeListener(ChangeListener changeListener) throws TooManyListenersException {
        if (this.changeListener != null) {
            throw new TooManyListenersException(changeListener.toString());
        }
        this.changeListener = changeListener;
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListener != changeListener) {
            throw new IllegalArgumentException("Wrong listener " + changeListener);
        }
        this.changeListener = null;
    }

    protected final void fireChange() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public final void addBusyListener(ModelBusyListener modelBusyListener) throws TooManyListenersException {
        if (this.busyListener != null) {
            throw new TooManyListenersException(modelBusyListener.toString());
        }
        this.busyListener = modelBusyListener;
    }

    public final void removeBusyListener(ModelBusyListener modelBusyListener) {
        if (this.busyListener != modelBusyListener) {
            throw new IllegalArgumentException("Wrong listener " + modelBusyListener);
        }
        this.busyListener = null;
    }

    protected final void fireBusyChange(boolean bl) {
        if (this.busyListener == null) {
            return;
        }
        if (bl) {
            this.busyListener.busyStart();
        } else {
            this.busyListener.busyEnd();
        }
    }

    private void fireNewContentReady() {
        if (this.busyListener == null) {
            return;
        }
        this.busyListener.newContentReady();
    }

    protected final void setInvalid(boolean bl) {
        if (bl != this.invalid) {
            this.invalid = bl;
            if (bl) {
                this.stopListening();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        ListModelSupport.this.setContents(Arrays.asList(AbstractModel.createInvalidMarker()));
                    }
                });
                this.loader.cancel();
            } else {
                this.list = null;
                this.loader = new Loader(this.getWaitTask());
            }
        }
    }

    protected final void change() {
        if (this.invalid) {
            return;
        }
        if (this.loader == null) {
            throw new IllegalStateException("Change called before addNotify");
        }
        this.loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retryLoad(long l) {
        if (!rp.isRequestProcessorThread()) {
            throw new IllegalStateException("retryLoad must be called from the loader thread");
        }
        if (!Thread.holdsLock(this.loader)) {
            throw new IllegalStateException("retryLoad may only be called from loadContents");
        }
        if (l > 90000L) {
            throw new IllegalArgumentException("Abusive retry delay - must be less than 1.5 minutes");
        }
        if (this.retryCount > 10) {
            ErrorManager.getDefault().log(1, "Too many retries on " + this + " - marking it invalid");
            this.setInvalid(true);
            return;
        }
        ErrorManager.getDefault().log(1, "Putting loader thread to sleep for " + l + " milliseconds due to error");
        try {
            ++this.retryCount;
            Class clazz = ListModelSupport.class;
            synchronized (clazz) {
                rpThread = Thread.currentThread();
                waitingModel = this;
            }
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            if (this.isActive() && !this.invalid) {
                this.loader.retryStart(l);
                return;
            }
        }
        finally {
            rpThread = null;
            waitingModel = null;
        }
        if (this.isActive() && !this.invalid) {
            this.loader.retryStart(0L);
        }
    }

    private void setContents(final List list) {
        List list2 = this.list;
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                if (!ListModelSupport.this.active) {
                    return;
                }
                boolean bl = ListModelSupport.this.list == null;
                ListModelSupport.this.list = list;
                try {
                    ListModelSupport.this.updated();
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().notify((Throwable)runtimeException);
                }
                ListModelSupport.this.fireChange();
                if ((ListModelSupport.this.listeners.size() > 0 || ListModelSupport.this.getTree() != null) && bl) {
                    ExtListDataEvent extListDataEvent;
                    List<Object> list2 = Arrays.asList(AbstractModel.createInvalidMarker());
                    if (ListModelSupport.this.listeners.size() > 0) {
                        extListDataEvent = new ExtListDataEvent(ListModelSupport.this, 2, 0, 0);
                        extListDataEvent.setContents(list2, null);
                        ListModelSupport.this.fire(extListDataEvent);
                    }
                    if (list.size() > 0 && ListModelSupport.this.listeners.size() > 0) {
                        extListDataEvent = new ExtListDataEvent(ListModelSupport.this, 1, 0, list.size());
                        extListDataEvent.setContents(Collections.EMPTY_LIST, list);
                        ListModelSupport.this.fire(extListDataEvent);
                    }
                    if (ListModelSupport.this.getTree() != null) {
                        ListModelSupport.this.getTree().processDiffs(ListModelSupport.this, new Diff[]{ListDiff.createDiff(list2, ListModelSupport.this.list)});
                    }
                    ListModelSupport.this.fireNewContentReady();
                }
            }
        });
        if (list2 != null) {
            this.change(list2, list);
        }
    }

    protected final void change(List list) {
        this.queueChanges(ListDiff.createFixed(this.list, this.list, list));
    }

    protected final void change(int n, int n2, int n3) {
        Change change = new Change(n, n2, n3);
        this.change(Arrays.asList(change));
    }

    private final void change(List list, List list2) {
        if (!this.active) {
            return;
        }
        Diff diff = ListDiff.createDiff(list, list2);
        diff.getChanges();
        this.queueChanges(diff);
    }

    public final Object getElementAt(int n) {
        Object object = this.list == null ? (this.invalid ? AbstractModel.createInvalidMarker() : this.getLoadingTempList().get(0)) : (!this.list.isEmpty() ? this.list.get(n) : this.getLoadingTempList().get(0));
        if (!(AbstractModel.isInvalidMarker(object) || AbstractModel.isWaitMarker(object) || this.isObjectValid(object))) {
            object = AbstractModel.createInvalidMarker();
        }
        return object;
    }

    protected boolean isObjectValid(Object object) {
        return true;
    }

    public final int getSize() {
        return this.list == null || this.invalid ? 1 : this.list.size();
    }

    public final boolean isDefaultActionInstant() {
        return this.singleClick;
    }

    public String getTooltip(Object object) {
        return null;
    }

    public String getTooltip(Object object, int n, int n2) {
        return null;
    }

    protected String getDisplayName(Object object) {
        return null;
    }

    protected WeightedString assembleName(WeightedString weightedString, Object object) {
        weightedString.startMarkupRun(512);
        weightedString.append("Unknown: ", 0.09f);
        weightedString.endMarkupRun();
        weightedString.append(object.toString(), 0.09f);
        return weightedString;
    }

    public final WeightedString getName(Object object) {
        long l = System.currentTimeMillis();
        WeightedString weightedString = WeightedString.instance();
        String string = this.getDisplayName(object);
        if (string != null) {
            weightedString.append(string, 0.09f);
        } else {
            weightedString = this.assembleName(weightedString, object);
        }
        cumulateTime += System.currentTimeMillis() - l;
        return weightedString;
    }

    private synchronized void queueChanges(Diff diff) {
        if (!this.active) {
            return;
        }
        if (this.changeManager == null) {
            this.changeManager = new ChangeManager();
        }
        if (this.changeManager.isBusy()) {
            this.changeManager = new ChangeManager().enqueue(diff);
        } else {
            this.changeManager.enqueue(diff);
        }
    }

    public final void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    public final void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    private void fire(ListDataEvent listDataEvent) {
        if (!this.active) {
            return;
        }
        ListDataListener[] listDataListenerArray = new ListDataListener[this.listeners.size()];
        listDataListenerArray = this.listeners.toArray(listDataListenerArray);
        block5: for (int i = 0; i < listDataListenerArray.length; ++i) {
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListenerArray[i].contentsChanged(listDataEvent);
                    continue block5;
                }
                case 1: {
                    listDataListenerArray[i].intervalAdded(listDataEvent);
                    continue block5;
                }
                case 2: {
                    listDataListenerArray[i].intervalRemoved(listDataEvent);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Bad event type: " + listDataEvent.getType());
                }
            }
        }
    }

    public final void doAddNotify() {
        if (this.active) {
            throw new IllegalStateException("Already active");
        }
        if (this.invalid) {
            return;
        }
        this.active = true;
        this.list = null;
        if (rpThread != null) {
            rpThread.interrupt();
            rpThread = null;
            waitingModel = null;
        }
        this.loader = new Loader(this.getWaitTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNotify() {
        if (this.loader == null) {
            throw new IllegalStateException("removeNotify called before addNotify");
        }
        Object object = START_STOP_LISTENING_LOCK;
        synchronized (object) {
            this.loader.cancel();
            this.stopListening();
        }
        this.active = false;
        object = ListModelSupport.class;
        synchronized (object) {
            if (rpThread != null && waitingModel == this) {
                rpThread.interrupt();
                rpThread = null;
                waitingModel = null;
            }
        }
    }

    static {
        $assertionsDisabled = !ListModelSupport.class.desiredAssertionStatus();
        rp = new RequestProcessor("ListModelSupport loader", 1);
        rpThread = null;
        waitingModel = null;
        START_STOP_LISTENING_LOCK = new Object();
        cumulateTime = 0L;
    }

    private final class Loader
    implements Runnable,
    TaskListener,
    Cancellable {
        private boolean cancelled = false;
        private boolean finished = true;
        private final Task waitTask;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Loader(Task task) {
            this.waitTask = task;
            if (task != null && !task.isFinished()) {
                task.addTaskListener((TaskListener)this);
            } else {
                this.start();
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.waitTask != null && this.waitTask instanceof Cancellable) {
                ListModelSupport.this.cancelWaitTask((Cancellable)this.waitTask);
            }
            return true;
        }

        public void start() {
            boolean bl;
            if (!this.finished) {
                return;
            }
            this.finished = false;
            this.cancelled = false;
            boolean bl2 = bl = ListModelSupport.this.list == null ? ListModelSupport.this.isReadAsync() : ListModelSupport.this.isUpdateAsync();
            if (rp.isRequestProcessorThread() && bl) {
                this.run();
            } else if (SwingUtilities.isEventDispatchThread() && !bl) {
                this.run();
            } else if (bl) {
                rp.post((Runnable)this);
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void retryStart(long l) {
            rp.post((Runnable)this, (int)l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!($assertionsDisabled || SwingUtilities.isEventDispatchThread() || rp.isRequestProcessorThread())) {
                throw new AssertionError();
            }
            if (this.cancelled || !ListModelSupport.this.active || ListModelSupport.this.invalid) {
                return;
            }
            try {
                boolean bl = ListModelSupport.this.list == null;
                Object object = this;
                synchronized (object) {
                    ListModelSupport.this.setContents(ListModelSupport.this.loadContents());
                }
                object = START_STOP_LISTENING_LOCK;
                synchronized (object) {
                    block14: {
                        if (!this.cancelled && ListModelSupport.this.active && !ListModelSupport.this.invalid) break block14;
                        return;
                    }
                    if (bl) {
                        ListModelSupport.this.startListening();
                    }
                }
            }
            finally {
                this.finished = true;
                this.cancelled = false;
            }
        }

        public void taskFinished(Task task) {
            task.removeTaskListener((TaskListener)this);
            this.start();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$ListModelSupport == null ? (class$org$netbeans$modules$java$navigation$spi$ListModelSupport = ListModelSupport.class$("org.netbeans.modules.java.navigation.spi.ListModelSupport")) : class$org$netbeans$modules$java$navigation$spi$ListModelSupport).desiredAssertionStatus();
        }
    }

    private final class ChangeManager
    implements Runnable {
        private boolean enqueued = false;
        private final List diffs = Collections.synchronizedList(new ArrayList(2));
        private volatile boolean busy = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ChangeManager() {
        }

        ChangeManager enqueue(Diff diff) {
            this.diffs.add(diff);
            if (!this.enqueued) {
                this.enqueued = true;
                Mutex.EVENT.readAccess((Runnable)this);
            }
            return this;
        }

        boolean isBusy() {
            return this.busy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!ListModelSupport.this.active) {
                return;
            }
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            this.busy = true;
            try {
                Diff[] diffArray = null;
                List list = this.diffs;
                synchronized (list) {
                    diffArray = this.diffs.toArray(new Diff[this.diffs.size()]);
                    this.diffs.clear();
                }
                this.processDiffs(diffArray);
            }
            finally {
                this.enqueued = false;
                this.busy = false;
            }
        }

        private void processDiffs(Diff[] diffArray) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (!ListModelSupport.this.isActive()) {
                return;
            }
            if (!ListModelSupport.this.listeners.isEmpty()) {
                for (int i = 0; i < diffArray.length; ++i) {
                    this.processDiff(diffArray[i]);
                }
            }
            if (ListModelSupport.this.getTree() != null) {
                ListModelSupport.this.getTree().processDiffs(ListModelSupport.this, diffArray);
            }
        }

        private void processDiff(Diff diff) {
            Iterator iterator = diff.getChanges().iterator();
            while (iterator.hasNext()) {
                Change change = (Change)iterator.next();
                ExtListDataEvent extListDataEvent = new ExtListDataEvent(ListModelSupport.this, change.getType(), change.getStart(), change.getEnd());
                extListDataEvent.setContents(diff.getOld(), diff.getNew());
                ListModelSupport.this.fire(extListDataEvent);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$ListModelSupport == null ? (class$org$netbeans$modules$java$navigation$spi$ListModelSupport = ListModelSupport.class$("org.netbeans.modules.java.navigation.spi.ListModelSupport")) : class$org$netbeans$modules$java$navigation$spi$ListModelSupport).desiredAssertionStatus();
        }
    }
}

