/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.TooManyListenersException;
import org.netbeans.modules.java.navigation.spi.diff.ListDiff;

public interface RelatedItemProvider {
    public boolean isRelated(Object var1);

    public boolean isPrimary(Object var1);

    public Object getPrimaryItem();

    public void addRelatedItemListener(RelatedItemListener var1) throws TooManyListenersException;

    public void removeRelatedItemListener(RelatedItemListener var1);

    public void reset();

    public static final class RelatedItemEvent
    extends EventObject {
        private final Collection oldItems;
        private final Collection newItems;
        private final Object oldPrimary;
        private final Object newPrimary;

        public RelatedItemEvent(Object object, Collection collection, Collection collection2, Object object2, Object object3) {
            super(object);
            this.oldItems = collection == null ? Collections.EMPTY_SET : collection;
            this.newItems = collection2 == null ? Collections.EMPTY_SET : collection2;
            this.oldPrimary = object2;
            this.newPrimary = object3;
        }

        public Collection getRelatedItems() {
            return this.newItems;
        }

        public Collection getPreviousRelatedItems() {
            return this.oldItems;
        }

        public Object getOldPrimary() {
            return this.oldPrimary;
        }

        public Object getNewPrimary() {
            return this.newPrimary;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            try {
                List list = this.oldItems instanceof List ? (List)this.oldItems : new ArrayList(this.oldItems);
                List list2 = this.newItems instanceof List ? (List)this.newItems : new ArrayList(this.newItems);
                stringBuffer.append(ListDiff.createDiff(list, list2));
            }
            catch (Exception exception) {
                stringBuffer.append("Exception iterating the list: " + exception);
            }
            return stringBuffer.toString();
        }
    }

    public static interface RelatedItemListener
    extends EventListener {
        public void itemsChanged(RelatedItemEvent var1);

        public void itemsCleared(RelatedItemEvent var1);
    }
}

