/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public abstract class RelatedItemProviderSupport
implements RelatedItemProvider {
    private RelatedItemProvider.RelatedItemListener listener = null;
    private static final RequestProcessor rp;
    private Updater updater = null;
    private Collection list = Collections.EMPTY_LIST;
    private Object primary = null;
    private RelatedItemProvider eventDelegate = this;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RelatedItemProviderSupport() {
    }

    final void setEventDelegate(RelatedItemProvider relatedItemProvider) {
        this.eventDelegate = relatedItemProvider;
    }

    protected abstract Collection collectRelatedItems(Object var1);

    protected abstract Object findPrimaryItem();

    protected abstract void startListening();

    protected abstract void stopListening();

    protected final void change() {
        if (!this.isActive()) {
            return;
        }
        this.updater.start();
    }

    public final synchronized void addRelatedItemListener(RelatedItemProvider.RelatedItemListener relatedItemListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        if (relatedItemListener == null) {
            throw new NullPointerException();
        }
        this.listener = relatedItemListener;
        this.start();
    }

    public final synchronized void removeRelatedItemListener(RelatedItemProvider.RelatedItemListener relatedItemListener) {
        this.listener = null;
        this.stop();
    }

    protected final boolean isActive() {
        return this.listener != null;
    }

    public final boolean isRelated(Object object) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        return this.isActive() && this.list != null ? this.list.contains(object) : false;
    }

    public final void reset() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        this.list = Collections.EMPTY_LIST;
    }

    public final boolean isPrimary(Object object) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        return this.primary == null || !this.isActive() ? false : this.primary.equals(object);
    }

    protected Collection getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.list == null ? Collections.EMPTY_SET : Collections.unmodifiableCollection(this.list);
    }

    public final Object getPrimaryItem() {
        return this.primary;
    }

    private void setContents(Collection collection, Object object) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Collection collection2 = this.list;
        this.list = collection;
        Object object2 = this.primary;
        this.primary = object;
        if (collection2 != null && this.list != null && !((Object)collection2).equals(this.list) || object2 != object) {
            this.fire(collection2, this.list, object2, object);
        }
    }

    private void fire(Collection collection, Collection collection2, Object object, Object object2) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isActive()) {
            return;
        }
        RelatedItemProvider.RelatedItemEvent relatedItemEvent = new RelatedItemProvider.RelatedItemEvent(this.eventDelegate, collection, collection2, object, object2);
        if ((collection2 == null || collection2.isEmpty()) && object2 == null) {
            this.listener.itemsCleared(relatedItemEvent);
        } else {
            this.listener.itemsChanged(relatedItemEvent);
        }
    }

    private void start() {
        if (!$assertionsDisabled && this.updater != null) {
            throw new AssertionError((Object)"Start called twice");
        }
        this.updater = new Updater();
        this.updater.start();
    }

    private void stop() {
        if (this.updater != null) {
            this.updater.cancel();
        }
        this.updater = null;
        this.primary = null;
        this.list = null;
        this.stopListening();
    }

    static {
        $assertionsDisabled = !RelatedItemProviderSupport.class.desiredAssertionStatus();
        rp = new RequestProcessor("Navigator RelatedItemProviderSupport gatherer");
    }

    public static abstract class ActiveNodeSupport
    extends RelatedItemProviderSupport {
        private PropertyChangeListener pcl = null;
        private final boolean useCurrentNodes;
        private static final Object PCL_LOCK = new Object();

        protected ActiveNodeSupport(boolean bl) {
            this.useCurrentNodes = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void startListening() {
            Object object = PCL_LOCK;
            synchronized (object) {
                this.pcl = new PCL();
                TopComponent.getRegistry().addPropertyChangeListener(this.pcl);
                this.pcl.propertyChange(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void stopListening() {
            Object object = PCL_LOCK;
            synchronized (object) {
                TopComponent.getRegistry().removePropertyChangeListener(this.pcl);
                this.pcl = null;
            }
        }

        protected final Collection collectRelatedItems() {
            return this.collectRelatedItems(this.getNodes());
        }

        protected abstract Collection collectRelatedItems(Object var1);

        protected abstract Object getPrimaryItemFromNodes(Node[] var1);

        protected final Object findPrimaryItem() {
            return this.getPrimaryItemFromNodes(this.getNodes());
        }

        private Node[] getNodes() {
            return this.useCurrentNodes ? TopComponent.getRegistry().getCurrentNodes() : TopComponent.getRegistry().getActivatedNodes();
        }

        private final class PCL
        implements PropertyChangeListener {
            private PCL() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ActiveNodeSupport.this.useCurrentNodes && (propertyChangeEvent == null || "currentNodes".equals(propertyChangeEvent.getPropertyName())) || !ActiveNodeSupport.this.useCurrentNodes && (propertyChangeEvent == null || "activatedNodes".equals(propertyChangeEvent.getPropertyName()))) {
                    ActiveNodeSupport.this.change();
                }
            }
        }
    }

    private final class Updater
    implements Runnable {
        boolean enqueued = false;
        boolean cancelled = false;
        boolean firstRun = true;
        Object newPrimary = null;
        Collection newItems = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Updater() {
        }

        void start() {
            if (this.enqueued) {
                return;
            }
            this.enqueued = true;
            rp.post((Runnable)this);
        }

        void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (rp.isRequestProcessorThread()) {
                if (!RelatedItemProviderSupport.this.isActive()) {
                    return;
                }
                if (this.firstRun) {
                    this.firstRun = false;
                    RelatedItemProviderSupport.this.startListening();
                }
                Updater updater = this;
                synchronized (updater) {
                    this.newPrimary = RelatedItemProviderSupport.this.findPrimaryItem();
                    this.newItems = RelatedItemProviderSupport.this.collectRelatedItems(this.newPrimary);
                }
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                if (!RelatedItemProviderSupport.this.isActive()) {
                    return;
                }
                Collection collection = null;
                Object object = null;
                Updater updater = this;
                synchronized (updater) {
                    collection = this.newItems;
                    object = this.newPrimary;
                }
                RelatedItemProviderSupport.this.setContents(this.newItems, this.newPrimary);
                this.newItems = null;
                this.newPrimary = null;
                this.enqueued = false;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Wrong thread");
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport == null ? (class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport = RelatedItemProviderSupport.class$("org.netbeans.modules.java.navigation.spi.RelatedItemProviderSupport")) : class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport).desiredAssertionStatus();
        }
    }
}

