/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.ListModelSupport;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.netbeans.modules.java.navigation.spi.diff.Change;
import org.netbeans.modules.java.navigation.spi.diff.Diff;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.util.Cancellable;
import org.openide.util.Task;
import org.openide.util.Utilities;

public abstract class TreeModelSupport
extends AbstractModel
implements NavigatorTreeModel {
    private final Roots roots;
    protected final Object root;
    private HashMap mdls2roots = new HashMap();
    private HashMap roots2mdls = new HashMap();
    private List listeners = Collections.synchronizedList(new ArrayList());
    private boolean suppressChildFiring = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TreeModelSupport(Object object) {
        this.root = object;
        this.roots = new Roots(this);
        this.roots.setTree(this);
    }

    public final void doAddNotify() {
        this.roots.setTree(this);
        this.roots.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNotify() {
        List list = this.getList();
        this.roots.removeNotify();
        this.suppressChildFiring = true;
        try {
            Iterator iterator = this.mdls2roots.keySet().iterator();
            while (iterator.hasNext()) {
                AbstractModel abstractModel = (AbstractModel)iterator.next();
                if (!abstractModel.isActive()) continue;
                abstractModel.removeNotify();
            }
        }
        finally {
            this.suppressChildFiring = false;
        }
    }

    protected final boolean isActive() {
        return this.roots.isActive();
    }

    public boolean acceptsStringFilter() {
        return false;
    }

    protected Task getWaitTask() {
        return null;
    }

    protected void cancelWaitTask(Cancellable cancellable) {
        cancellable.cancel();
    }

    public abstract Action[] getActions(Object var1);

    protected String getDisplayName(Object object) {
        return null;
    }

    protected WeightedString assembleName(WeightedString weightedString, Object object) {
        weightedString.startMarkupRun(512);
        weightedString.append("Unknown: ", 0.09f);
        weightedString.endMarkupRun();
        weightedString.append(object.toString(), 0.09f);
        return weightedString;
    }

    public final WeightedString getName(Object object) {
        WeightedString weightedString = WeightedString.instance();
        String string = this.getDisplayName(object);
        if (string != null) {
            weightedString.append(string, 0.09f);
        } else {
            weightedString = this.assembleName(weightedString, object);
        }
        return weightedString;
    }

    public abstract Icon getIcon(Object var1);

    public String getTooltip(Object object) {
        return null;
    }

    public abstract Action getDefaultAction(Object var1);

    public final boolean isDefaultActionInstant() {
        return false;
    }

    public void notifyExpandedState(TreePath treePath, boolean bl) {
        AbstractModel abstractModel = this.findModelFor(treePath, true);
        if (abstractModel.isActive() != bl && bl) {
            abstractModel.addNotify();
        }
    }

    AbstractModel findModelFor(TreePath treePath, boolean bl) {
        return this.findModelFor(treePath.getLastPathComponent(), bl);
    }

    AbstractModel findModelFor(Object object, boolean bl) {
        AbstractModel abstractModel = this.modelForRootObject(object, bl);
        if (abstractModel == null) {
            Iterator iterator = this.mdls2roots.keySet().iterator();
            while (iterator.hasNext()) {
                AbstractModel abstractModel2 = (AbstractModel)iterator.next();
                if (!abstractModel2.owns(object)) continue;
                abstractModel = abstractModel2.findModelFor(object, bl);
            }
        }
        return abstractModel;
    }

    void notifyChildModelAddNotify(AbstractModel abstractModel) {
        if (abstractModel != this.roots) {
            List list = abstractModel.getLoadingTempList();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, abstractModel.getPath(), new int[]{0}, new Object[]{list.get(0)});
            this.childTreeFires(1, treeModelEvent, abstractModel);
        }
    }

    public TreePath[] getDefaultExpandedPaths() {
        return new TreePath[0];
    }

    public boolean isShowRoot() {
        return true;
    }

    protected abstract List loadContents();

    protected void updated() {
    }

    protected abstract AbstractModel createModelFor(Object var1);

    protected void startListening() {
    }

    protected void stopListening() {
    }

    public boolean isReady() {
        return this.roots.isReady();
    }

    public void addChangeListener(ChangeListener changeListener) throws TooManyListenersException {
        this.roots.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.roots.removeChangeListener(changeListener);
    }

    protected final List getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"getList may only becalled on the dispatch thread");
        }
        return this.roots.getList();
    }

    public final Object getRoot() {
        return this.root;
    }

    public final int getIndexOfChild(Object object, Object object2) {
        if (this.root.equals(object)) {
            return this.roots.indexOf(object2);
        }
        AbstractModel abstractModel = this.findModelFor(object, true);
        return abstractModel == null ? -1 : abstractModel.indexOf(object2);
    }

    public final Object getChild(Object object, int n) {
        AbstractModel abstractModel = this.findModelFor(object, true);
        if (abstractModel != null) {
            return abstractModel.getElementAt(n);
        }
        return null;
    }

    protected final AbstractModel modelForRootObject(Object object, boolean bl) {
        if (this.root.equals(object)) {
            return this.roots;
        }
        if (this.roots.owns(object)) {
            AbstractModel abstractModel = (AbstractModel)this.roots2mdls.get(object);
            if (abstractModel == null) {
                abstractModel = this.createModelFor(object);
                abstractModel.setPath(TreeModelSupport.combine(this.getPath(), new TreePath(object)));
                abstractModel.setTree(this);
                this.mdls2roots.put(abstractModel, object);
                this.roots2mdls.put(object, abstractModel);
                this.notifyChildModelAddNotify(abstractModel);
            }
            return abstractModel;
        }
        return null;
    }

    public final int getChildCount(Object object) {
        AbstractModel abstractModel = this.findModelFor(object, true);
        if (abstractModel instanceof Roots && object != abstractModel.getPath().getLastPathComponent()) {
            return 0;
        }
        if (abstractModel != null) {
            return abstractModel.getSize();
        }
        return 0;
    }

    TreePath getPath() {
        TreePath treePath = super.getPath();
        if (treePath == null) {
            return new TreePath(this.getRoot());
        }
        return treePath;
    }

    boolean owns(Object object) {
        boolean bl;
        block1: {
            bl = this.roots.owns(object);
            if (bl) break block1;
            Iterator iterator = this.mdls2roots.keySet().iterator();
            while (iterator.hasNext() && !(bl |= ((AbstractModel)iterator.next()).owns(object))) {
            }
        }
        return bl;
    }

    int getSize() {
        return this.roots.getSize();
    }

    int fullSize() {
        int n = this.getSize();
        Iterator iterator = this.mdls2roots.keySet().iterator();
        while (iterator.hasNext()) {
            n += ((AbstractModel)iterator.next()).fullSize();
        }
        return n;
    }

    Object getElementAt(int n) {
        return this.roots.getElementAt(n);
    }

    int indexOf(Object object) {
        return this.roots.indexOf(object);
    }

    void childTreeFires(int n, TreeModelEvent treeModelEvent, AbstractModel abstractModel) {
        if (this.suppressChildFiring) {
            return;
        }
        TreePath treePath = TreeModelSupport.combine(this.getPath(), treeModelEvent.getTreePath());
        TreeModelEvent treeModelEvent2 = new TreeModelEvent((Object)this, treePath, treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        this.fire(n, treeModelEvent2);
    }

    public final boolean isLeaf(Object object) {
        AbstractModel abstractModel = this.findModelFor(object, true);
        if (abstractModel instanceof ListModelSupport && !(abstractModel instanceof Roots)) {
            Object object2 = abstractModel.getPath().getLastPathComponent();
            return !object.equals(object2);
        }
        return abstractModel == null ? true : (!abstractModel.isActive() ? false : abstractModel.getSize() == 0);
    }

    public final void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException();
    }

    public final void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public final void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    protected final void change() {
        this.roots.change();
    }

    protected final void change(int n, int n2, int n3) {
        this.roots.change(n, n2, n3);
    }

    protected final void change(List list) {
        this.roots.change(list);
    }

    void processDiffs(ListModelSupport listModelSupport, Diff[] diffArray) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Object object = listModelSupport == this.roots ? this.root : this.mdls2roots.get(listModelSupport);
        TreePath treePath = listModelSupport == this.roots ? this.getPath() : listModelSupport.getPath();
        for (int i = 0; i < diffArray.length; ++i) {
            List list = diffArray[i].getChanges();
            if (object == null || list.isEmpty()) continue;
            int n = -1;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            Change[] changeArray = list.toArray(new Change[0]);
            for (int j = 0; j < changeArray.length; ++j) {
                Change change = changeArray[j];
                if (n == change.getType() || n == -1) {
                    n = change.getType();
                    this.addIndicesForChange(change, arrayList, arrayList2, diffArray[i].getOld(), diffArray[i].getNew());
                }
                if (j != changeArray.length - 1 && changeArray[j + 1].getType() == n) continue;
                int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])arrayList.toArray(new Integer[arrayList.size()]));
                Object[] objectArray = arrayList2.toArray();
                arrayList.clear();
                arrayList2.clear();
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                this.fire(n, treeModelEvent);
                n = -1;
            }
        }
    }

    private void addIndicesForChange(Change change, List list, List list2, List list3, List list4) {
        for (int i = change.getStart(); i <= change.getEnd(); ++i) {
            list.add(new Integer(i));
            list2.add(change.getType() != 2 ? list4.get(i) : list3.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(int n, TreeModelEvent treeModelEvent) {
        TreeModelListener[] treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        block8: for (int i = 0; i < treeModelListenerArray.length; ++i) {
            switch (n) {
                case 0: {
                    treeModelListenerArray[i].treeNodesChanged(treeModelEvent);
                    continue block8;
                }
                case 1: {
                    treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
                    continue block8;
                }
                case 2: {
                    treeModelListenerArray[i].treeNodesRemoved(treeModelEvent);
                    continue block8;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block8;
                }
            }
        }
        TreeModelSupport treeModelSupport = this.getRootTree();
        if (treeModelSupport != this) {
            treeModelSupport.childTreeFires(n, treeModelEvent, this);
        }
        TreeModelSupport treeModelSupport2 = this;
        synchronized (treeModelSupport2) {
            this.notifyAll();
        }
    }

    public String toString() {
        return "[TME for " + this.getRoot() + " path " + this.getPath() + "]";
    }

    static {
        $assertionsDisabled = !TreeModelSupport.class.desiredAssertionStatus();
    }

    private static final class Roots
    extends ListModelSupport {
        Roots(TreeModelSupport treeModelSupport) {
            this.setTree(treeModelSupport);
        }

        public Action[] getActions(Object object) {
            return this.getTree().getActions(object);
        }

        public Action getDefaultAction(Object object) {
            return this.getTree().getDefaultAction(object);
        }

        public Icon getIcon(Object object) {
            return this.getTree().getIcon(object);
        }

        protected List loadContents() {
            return this.getTree().loadContents();
        }

        protected Task getWaitTask() {
            return this.getTree().getWaitTask();
        }

        protected void cancelWaitTask(Cancellable cancellable) {
            this.getTree().cancelWaitTask(cancellable);
        }

        protected void startListening() {
            this.getTree().startListening();
        }

        protected void stopListening() {
            this.getTree().stopListening();
        }

        protected void updated() {
            this.getTree().updated();
        }

        TreePath getPath() {
            return this.getTree().getPath();
        }

        public JComponent getFilters() {
            return this.getTree().getFilters();
        }
    }
}

