/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.java.navigation.spi.diff.Change;

final class ParallelIterator {
    private final List old;
    private final List nue;
    private Iterator oi;
    private Iterator ni;
    private Set h_old = null;
    private Set h_new = null;
    private final List changes = new ArrayList(5);
    private Object lastOld;
    private Object lastNue;
    private boolean oiHadNext = true;
    private boolean done = false;
    private int offset = 0;
    private int index = 0;
    private Change currChange = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    ParallelIterator(List list, List list2) {
        this.old = list;
        this.nue = list2;
        this.oi = list.iterator();
        this.ni = list2.iterator();
    }

    private void go() {
        if (this.oi == null) {
            throw new IllegalStateException("Cannot reuse");
        }
        if (this.old.isEmpty() && this.nue.isEmpty()) {
            this.oi = null;
            this.ni = null;
            return;
        }
        if (!this.old.isEmpty() && this.nue.isEmpty()) {
            Change change = new Change(0, 2);
            change.setEnd(this.old.size() - 1);
            this.changes.add(change);
            this.oi = null;
            this.ni = null;
            return;
        }
        if (this.old.isEmpty() && !this.nue.isEmpty()) {
            Change change = new Change(0, 1);
            change.setEnd(this.nue.size() - 1);
            this.changes.add(change);
            this.oi = null;
            this.ni = null;
            return;
        }
        this.ensureInit();
        while (this.hasNext()) {
            this.next();
        }
        this.done();
    }

    private boolean hasNext() {
        return !this.done && (this.oi.hasNext() || this.ni.hasNext() || this.lastOld != null || this.lastNue != null);
    }

    private void handled(Object object, List list) {
        if (list == this.old) {
            this.lastOld = null;
            if (this.oi.hasNext()) {
                this.lastOld = this.oi.next();
                ++this.index;
            }
        } else {
            this.lastNue = null;
            if (this.ni.hasNext()) {
                this.lastNue = this.ni.next();
            }
        }
    }

    private void next() {
        boolean bl;
        boolean bl2 = this.oi.hasNext();
        boolean bl3 = this.ni.hasNext();
        boolean bl4 = bl = this.lastOld != null && this.lastNue != null && this.lastOld.equals(this.lastNue);
        if (bl) {
            this.writeChange();
            this.handled(this.lastOld, this.old);
            this.handled(this.lastNue, this.nue);
        } else {
            this.ensureSets();
            boolean bl5 = this.h_new.contains(this.lastOld);
            boolean bl6 = this.h_old.contains(this.lastNue);
            if (this.lastNue == null && this.lastOld != null) {
                Change change;
                this.writeChange();
                this.currChange = change = new Change(this.index + this.offset, this.old.size() - 1 + this.offset, 2);
                this.done = true;
            } else if (this.lastOld == null && this.lastNue != null) {
                for (int i = this.index + 1; i < this.nue.size() - this.offset; ++i) {
                    this.addChange(1, i);
                }
                this.done = true;
            } else if (bl5 && !bl6) {
                this.addChange(1, this.index);
                this.handled(this.lastNue, this.nue);
            } else if (!bl5 && bl6) {
                this.addChange(2, this.index);
                this.handled(this.lastOld, this.old);
            } else if (bl5 && bl6) {
                this.addChange(0, this.index);
                this.handled(this.lastOld, this.old);
                this.handled(this.lastNue, this.nue);
            } else if (!bl5 && !bl6 && (bl2 || !bl2 && this.oiHadNext)) {
                this.addChange(0, this.index);
                this.handled(this.lastOld, this.old);
                this.handled(this.lastNue, this.nue);
                if (!bl2) {
                    for (int i = this.index + 1; i < this.nue.size() - this.offset; ++i) {
                        this.addChange(1, i);
                    }
                    this.done = true;
                } else if (!bl3) {
                    for (int i = this.index; i < this.old.size() - this.offset; ++i) {
                        this.addChange(2, i);
                    }
                    this.done = true;
                }
            }
        }
        this.oiHadNext = bl2;
    }

    private void ensureSets() {
        if (this.h_old == null) {
            this.h_old = new HashSet(this.old);
            this.h_new = new HashSet(this.nue);
            if (this.h_old.size() != this.old.size()) {
                throw new IllegalStateException("Duplicate elements - size of list does not match size of equivalent HashSet " + this.identifyDuplicates(this.old));
            }
            if (this.h_new.size() != this.nue.size()) {
                throw new IllegalStateException("Duplicate elements - size of list does not match size of equivalent HashSet " + this.identifyDuplicates(this.nue));
            }
        }
    }

    private String identifyDuplicates(List list) {
        Integer n;
        Object object;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            n = (Integer)hashMap.get(object);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            hashMap.put(object, n);
        }
        object2 = new StringBuffer("Duplicates: ");
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            n = object.next();
            Integer n2 = (Integer)hashMap.get(n);
            if (n2 <= 1) continue;
            ((StringBuffer)object2).append("[" + n2 + " occurances of " + n + "]");
        }
        return ((StringBuffer)object2).toString();
    }

    private void ensureInit() {
        if (this.lastOld == null) {
            this.lastOld = this.oi.next();
        }
        if (this.lastNue == null) {
            this.lastNue = this.ni.next();
        }
    }

    private void done() {
        this.writeChange();
        this.currChange = null;
        this.oi = null;
        this.ni = null;
        this.h_old = null;
        this.h_new = null;
    }

    List getChanges() {
        if (this.oi != null) {
            this.go();
        }
        return this.changes;
    }

    private void addChange(int n, int n2) {
        if (this.currChange == null) {
            this.currChange = new Change(n2 + this.offset, n);
        } else if (this.currChange.getType() == n) {
            this.currChange.inc();
        } else {
            this.writeChange();
            this.currChange = new Change(n2 + this.offset, n);
        }
    }

    private void writeChange() {
        if (this.currChange == null) {
            return;
        }
        this.changes.add(this.currChange);
        int n = this.currChange.getType();
        if (n == 1) {
            this.offset += this.currChange.getEnd() - this.currChange.getStart() + 1;
        } else if (n == 2) {
            this.offset -= this.currChange.getEnd() - this.currChange.getStart() + 1;
        }
        if (!$assertionsDisabled && this.currChange.getStart() > this.currChange.getEnd()) {
            throw new AssertionError((Object)("Start must be > end - " + this.currChange.getStart() + " < " + this.currChange.getEnd()));
        }
        this.currChange = null;
    }

    static {
        $assertionsDisabled = !ParallelIterator.class.desiredAssertionStatus();
    }
}

