/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import java.util.Arrays;
import org.netbeans.modules.java.navigation.spi.strings.Abbreviator;

public final class AbbreviatorImpl
extends Abbreviator {
    private float[] buf = new float[50];
    private float maxWeight = 0.0f;
    private float minWeight = 0.0f;
    private final int[] lengths = new int[13];
    private boolean allUpper = false;

    public float[] process(char[] cArray, float f) {
        this.buf = this.ensureCapacity(this.buf, cArray.length);
        Arrays.fill(this.lengths, 0);
        float[] fArray = this.iterChars(cArray, this.buf, f, false);
        if (this.allUpper) {
            fArray = this.iterChars(cArray, this.buf, f, true);
        }
        return fArray;
    }

    public int[] getLengthsForLastRun() {
        return (int[])this.lengths.clone();
    }

    public float getMaxWeightForLastRun() {
        return this.maxWeight;
    }

    public float getMinWeightForLastRun() {
        return this.minWeight;
    }

    private float[] iterChars(char[] cArray, float[] fArray, float f, boolean bl) {
        this.allUpper = true;
        this.maxWeight = 0.0f;
        float[] fArray2 = this.buf;
        char c = '*';
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        for (int i = 0; i < cArray.length; ++i) {
            boolean bl8 = Character.isUpperCase(cArray[i]);
            boolean bl9 = this.isPlosiveOrGlottal(c, cArray[i]) || (cArray[i] == 'c' || cArray[i] == 'C') && bl7 && i < cArray.length - 1 && cArray[i + 1] != 'h' && cArray[i + 1] != 'H';
            boolean bl10 = this.isSiliblant(c, cArray[i]);
            boolean bl11 = this.isFricative(cArray[i]);
            boolean bl12 = this.isVowel(cArray[i]);
            boolean bl13 = !Character.isLetter(cArray[i]);
            this.allUpper &= bl8;
            if (!bl && bl8 && !bl2) {
                fArray2[i] = bl7 || i == 0 ? 1.0f : 0.95f;
            } else if (bl9 && !bl3) {
                fArray2[i] = 0.8f;
                if (bl4 && (!bl2 || bl)) {
                    fArray2[i - 1] = 0.75f;
                }
            } else if (bl10) {
                fArray2[i] = 0.6f;
                if (this.isDipthongStart(c) && (!bl2 || bl)) {
                    int n = i - 1;
                    fArray2[n] = fArray2[n] + 1.0f;
                }
            } else if (this.isDipthong(c, cArray[i])) {
                fArray2[i] = 0.5f;
                fArray2[i - 1] = 0.65f;
            } else {
                fArray2[i] = this.isPalatal(cArray[i]) ? (bl3 ? 0.5f : 0.3f) : (this.isVowel(cArray[i]) ? (bl5 ? 0.125f : (bl7 ? 0.76f : 0.2f)) : (this.isFricative(cArray[i]) ? 0.5f : (!Character.isLetter(cArray[i]) ? 1.0f : 0.45f)));
            }
            if (c == cArray[i]) {
                int n = i;
                fArray2[n] = fArray2[n] - 0.1f;
            }
            if (bl7) {
                fArray2[i] = Math.min(fArray2[i] + 0.45f, 1.0f);
            }
            bl2 = bl8;
            bl6 = bl11;
            bl4 = bl10;
            bl5 = bl12;
            bl3 = bl9;
            bl7 = bl13;
            this.maxWeight = Math.max(fArray2[i], this.maxWeight);
            this.minWeight = Math.min(fArray2[i], this.minWeight);
            int n = i;
            fArray2[n] = fArray2[n] + (f - 0.5f) / 9.0f;
            int n2 = (int)(fArray2[i] * 10.0f - 1.0f);
            while (n2 >= 0) {
                int n3 = n2--;
                this.lengths[n3] = this.lengths[n3] + 1;
            }
            c = cArray[i];
        }
        fArray2[0] = Math.max(1.0f, fArray2[0] + 0.2f);
        return fArray2;
    }

    private float[] ensureCapacity(float[] fArray, int n) {
        if (fArray.length >= n) {
            return fArray;
        }
        return new float[n + n / 2];
    }

    private boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y';
    }

    private boolean isPlosiveOrGlottal(char c, char c2) {
        boolean bl = (c == 'n' || c == 'N') && Character.isUpperCase(c) == Character.isUpperCase(c2);
        return c2 == 'p' || c2 == 't' || c2 == 'b' || c2 == 'd' || c2 == 'g' && !bl || c2 == 'k' || c2 == 'q' || c2 == 'P' || c2 == 'T' || c2 == 'B' || c2 == 'D' || c2 == 'G' && !bl || c2 == 'K' || c2 == 'Q';
    }

    private boolean isFricative(char c) {
        return c == 'f' || c == 'j' || c == 'h' || c == 'v' || c == 'F' || c == 'J' || c == 'H' || c == 'V';
    }

    private boolean isSiliblant(char c, char c2) {
        return c2 == 's' || c2 == 'z' || c2 == 'X' || c2 == 'S' || c2 == 'Z' || c2 == 'x' || this.isDipthong(c, c2);
    }

    private boolean isDipthongStart(char c) {
        return c == 's' || c == 'c' || c == 't' || c == 'p' || c == 'S' || c == 'C' || c == 'T' || c == 'P';
    }

    private boolean isDipthongEnd(char c) {
        return c == 'h' || c == 'h';
    }

    private boolean isPalatal(char c) {
        return c == 'm' || c == 'n' || c == 'r' || c == 'l' || c == 'M' || c == 'N' || c == 'R' || c == 'L';
    }

    private boolean isDipthong(char c, char c2) {
        return this.isDipthongStart(c) && this.isDipthongEnd(c2);
    }
}

