/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import org.netbeans.modules.java.navigation.spi.strings.Abbreviator;

final class Entry
implements Comparable {
    private final char[] c;
    private final float importance;
    final int index;
    private float target = 0.0f;
    private final Abbreviator abbrev = Abbreviator.getInstance();
    private boolean skip = false;

    Entry(char[] cArray, float f, int n) {
        this.c = cArray;
        this.importance = f;
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int fullLength() {
        return this.c.length;
    }

    public int length() {
        return this.target == 0.0f ? this.c.length : this.getLengths()[(int)(this.target * 10.0f)];
    }

    public int compareTo(Object object) {
        return (int)(this.importance * 10000.0f - ((Entry)object).importance * 10000.0f);
    }

    public float getImportance() {
        return this.importance;
    }

    public void setTargetWeight(float f) {
        this.target = f;
    }

    public int[] getLengths() {
        this.abbrev.process(this.c, this.target);
        return this.abbrev.getLengthsForLastRun();
    }

    public int getLengthAtTarget() {
        int n = this.c.length;
        float[] fArray = this.abbrev.process(this.c, this.importance);
        for (int i = this.c.length - 1; i >= 0; --i) {
            if (!(fArray[i] <= this.target)) continue;
            --n;
        }
        return n;
    }

    private float[] getWeights() {
        float[] fArray = this.abbrev.process(this.c, this.importance);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.c.length; ++i) {
            stringBuffer.append(this.c[i]);
            stringBuffer.append(':');
            stringBuffer.append(fArray[i]);
            if (i == fArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return fArray;
    }

    public void setSkip(boolean bl) {
        this.skip = bl;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public char[] elide(int n) {
        char[] cArray = new char[this.c.length];
        if (this.c.length == 1) {
            cArray[0] = this.c[0];
            return cArray;
        }
        System.arraycopy(this.c, 0, cArray, 0, this.c.length);
        float[] fArray = this.getWeights();
        int n2 = cArray.length;
        for (int i = cArray.length - 1; i >= 0 && n2 > n; --i) {
            if (!(fArray[i] <= this.target)) continue;
            cArray[i] = '\u0000';
            --n2;
        }
        if (n2 == this.c.length) {
            return cArray;
        }
        char[] cArray2 = new char[n2];
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\u0000') continue;
            cArray2[n3] = cArray[i];
            ++n3;
        }
        return cArray2;
    }

    public String toString() {
        if (this.skip) {
            // empty if block
        }
        if (this.target == 0.0f) {
            return new String(this.c);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.c.length; ++i) {
            if (this.c[i] == '\u0000') continue;
            stringBuffer.append(this.c[i]);
        }
        return stringBuffer.toString();
    }
}

