/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.spi.strings.WeightedStringPainter;
import org.netbeans.modules.java.navigation.strings.Markup;
import org.netbeans.modules.java.navigation.strings.WeightedStringPainterImpl;

public final class WeightedStringImpl
extends WeightedString {
    private static final WeightedStringPainter painter = new WeightedStringPainterImpl();
    private Object[] chars = new Object[15];
    private float[] importances = new float[15];
    private int count = -1;
    int length = 0;
    private float minImportance = 10.0f;
    private float maxImportance = 0.0f;
    private final Markup markup = new Markup();

    public char[] getCharsSegment(int n) {
        return (char[])this.chars[n];
    }

    public int allMarkupTypes() {
        return this.markup.allMarkupTypes();
    }

    public void startMarkupRun(int n) {
        this.markup.start(this.count + 1, n);
    }

    public void endMarkupRun() {
        this.markup.end(this.count + 1);
    }

    public int getMarkupFor(int n) {
        return this.markup.get(n);
    }

    public float minImportance() {
        return (double)this.minImportance == 2.0 ? 0.0f : this.minImportance;
    }

    public float maxImportance() {
        return this.maxImportance;
    }

    public WeightedStringPainter getPainter() {
        return painter;
    }

    public void append(String string, float f) {
        this.append(string.toCharArray(), f);
    }

    public void append(char[] cArray, float f) {
        if (cArray.length == 0) {
            return;
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Importance must be between 0.0f and 1.0f but received " + f);
        }
        ++this.count;
        this.ensureCapacity(this.count + 1);
        this.chars[this.count] = cArray;
        this.importances[this.count] = f;
        this.length += cArray.length;
        this.minImportance = Math.min(this.minImportance, f);
        this.maxImportance = Math.max(this.maxImportance, f);
    }

    public void clear() {
        this.count = -1;
        this.length = 0;
        this.minImportance = 2.0f;
        this.maxImportance = 0.0f;
        this.markup.clear();
    }

    private void ensureCapacity(int n) {
        if (this.chars.length < n + 1) {
            Object[] objectArray = this.chars;
            this.chars = new Object[n * 2];
            System.arraycopy(objectArray, 0, this.chars, 0, objectArray.length);
            float[] fArray = this.importances;
            this.importances = new float[n * 2];
            System.arraycopy(fArray, 0, this.importances, 0, fArray.length);
        }
    }

    int getCount() {
        return this.count;
    }

    float getImportance(int n) {
        return this.importances[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.length + 1);
        for (int i = 0; i <= this.count; ++i) {
            stringBuffer.append((char[])this.chars[i]);
        }
        return stringBuffer.toString();
    }
}

