/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.spi.strings.WeightedStringPainter;
import org.netbeans.modules.java.navigation.strings.Entry;
import org.netbeans.modules.java.navigation.strings.WeightedStringImpl;

final class WeightedStringPainterImpl
implements WeightedStringPainter {
    private int currSeg = 0;
    private boolean willAbbreviate = false;
    private ArrayList abbrevInfos = new ArrayList(20);

    WeightedStringPainterImpl() {
    }

    public void paint(Graphics graphics, int n, int n2, WeightedString weightedString, int n3, boolean bl) {
        this.doPaint(graphics, n, n2, (WeightedStringImpl)weightedString, n3, bl);
    }

    private void doPaint(Graphics graphics, int n, int n2, WeightedStringImpl weightedStringImpl, int n3, boolean bl) {
        this.willAbbreviate = this.configureFrom(weightedStringImpl, n3);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        if ((weightedStringImpl.allMarkupTypes() & 2) != 0) {
            n3 = Math.max(2, n3 - n3 / 3);
        }
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (map == null && Boolean.getBoolean("swing.aatext")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (map != null) {
            graphics2D.addRenderingHints(map);
        }
        char[] cArray = this.first(weightedStringImpl);
        int n4 = 0;
        while (cArray != null) {
            n4 = weightedStringImpl.getMarkupFor(this.index());
            this.setupGraphics(graphics, n4, font, color, bl);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawChars(cArray, 0, cArray.length, n, n2);
            int n5 = graphics.getFontMetrics().charsWidth(cArray, 0, cArray.length);
            if ((n4 & 0x100) != 0) {
                graphics.drawLine(n, n2 + 1, n + n5, n2 + 1);
            }
            if ((n4 & 1) != 0) {
                int n6 = n2 - (fontMetrics.getAscent() - 2) / 2;
                graphics.setColor(color);
                graphics.drawLine(n, n6, n + n5, n6);
            }
            n += n5;
            cArray = this.next(weightedStringImpl);
        }
    }

    private void setupGraphics(Graphics graphics, int n, Font font, Color color, boolean bl) {
        if (n == 0) {
            graphics.setColor(color);
            graphics.setFont(font);
        }
        Font font2 = graphics.getFont();
        if ((n & 2) != 0) {
            if ((n & 0x80) != 0) {
                if (font2.getStyle() != 3) {
                    graphics.setFont(graphics.getFont().deriveFont(3));
                }
            } else if (font2.getStyle() != 1) {
                graphics.setFont(graphics.getFont().deriveFont(1));
            }
        } else if ((n & 0x80) != 0) {
            if (font2.getStyle() != 2) {
                graphics.setFont(graphics.getFont().deriveFont(2));
            }
        } else if (graphics.getFont().getStyle() != 0) {
            graphics.setFont(graphics.getFont().deriveFont(0));
        }
        if (bl) {
            if ((n & 4) != 0) {
                graphics.setColor(Color.GRAY);
            } else if ((n & 8) != 0) {
                graphics.setColor(Color.LIGHT_GRAY);
            } else if ((n & 0x200) != 0) {
                graphics.setColor(Color.RED);
            } else if ((n & 0x10) != 0) {
                graphics.setColor(Color.BLUE);
            } else if ((n & 0x20) != 0) {
                graphics.setColor(new Color(0, 150, 0));
            } else if ((n & 0x40) != 0) {
                graphics.setColor(new Color(150, 0, 150));
            } else {
                graphics.setColor(color);
            }
        }
    }

    private boolean configureFrom(WeightedStringImpl weightedStringImpl, int n) {
        return this.config(weightedStringImpl, n) != null;
    }

    Entry[] config(WeightedStringImpl weightedStringImpl, int n) {
        this.currSeg = 0;
        if (n >= weightedStringImpl.length) {
            return null;
        }
        this.ensureCapacity(weightedStringImpl);
        return this.weightAndElide(weightedStringImpl, n);
    }

    private void ensureCapacity(WeightedStringImpl weightedStringImpl) {
    }

    private char[] first(WeightedStringImpl weightedStringImpl) {
        this.currSeg = 0;
        while (this.currSeg <= weightedStringImpl.getCount() && this.willAbbreviate && ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).isSkip) {
            ++this.currSeg;
        }
        return this.current(weightedStringImpl);
    }

    private char[] current(WeightedStringImpl weightedStringImpl) {
        char[] cArray;
        if (this.currSeg > weightedStringImpl.getCount()) {
            this.currSeg = weightedStringImpl.getCount() + 1;
            cArray = null;
        } else {
            cArray = this.willAbbreviate ? this.seg(weightedStringImpl) : weightedStringImpl.getCharsSegment(this.currSeg);
        }
        return cArray;
    }

    private char[] next(WeightedStringImpl weightedStringImpl) {
        ++this.currSeg;
        while (this.currSeg <= weightedStringImpl.getCount() && this.willAbbreviate && ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).isSkip) {
            ++this.currSeg;
        }
        return this.current(weightedStringImpl);
    }

    private int index() {
        return this.currSeg;
    }

    private char[] seg(WeightedStringImpl weightedStringImpl) {
        char[] cArray = ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).abbrev;
        char[] cArray2 = cArray != null ? cArray : weightedStringImpl.getCharsSegment(this.currSeg);
        return cArray2;
    }

    private Entry[] weightAndElide(WeightedStringImpl weightedStringImpl, int n) {
        AbbrevInfo abbrevInfo;
        int n2;
        int n3;
        Object object;
        float f;
        int n4;
        Object[] objectArray = new Entry[weightedStringImpl.getCount() + 1];
        this.abbrevInfos.clear();
        int[] nArray = new int[11];
        int[] nArray2 = new int[11];
        for (n4 = 0; n4 < objectArray.length; ++n4) {
            char[] cArray = weightedStringImpl.getCharsSegment(n4);
            f = weightedStringImpl.getImportance(n4);
            objectArray[n4] = new Entry(cArray, f, n4);
            this.abbrevInfos.add(new AbbrevInfo());
            object = ((Entry)objectArray[n4]).getLengths();
            for (n3 = 0; n3 <= 10; ++n3) {
                int n5 = n3;
                nArray[n5] = nArray[n5] + object[n3];
                int n6 = n3;
                nArray2[n6] = nArray2[n6] + (f == 1.0f ? (Object)((Entry)objectArray[n4]).fullLength() : object[n3]);
            }
        }
        Arrays.sort(objectArray);
        n4 = 1;
        int n7 = 0;
        for (n7 = 0; n7 <= 10 && nArray2[n7] > n; ++n7) {
        }
        if (n7 > 10) {
            n4 = 0;
            for (n7 = 0; n7 <= 10 && nArray[n7] > n; ++n7) {
            }
        }
        if (n7 >= 10) {
            n7 = 9;
        }
        f = (float)(n7 + 1) / 10.0f;
        object = null;
        n3 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (n4 == 0 || ((Entry)objectArray[n2]).getImportance() < 1.0f) {
                ((Entry)objectArray[n2]).setTargetWeight(f);
                abbrevInfo = (AbbrevInfo)this.abbrevInfos.get(((Entry)objectArray[n2]).getIndex());
                abbrevInfo.abbrev = ((Entry)objectArray[n2]).elide(-1);
                n3 += abbrevInfo.abbrev.length;
                continue;
            }
            object = objectArray[n2];
            n3 += ((Entry)objectArray[n2]).length();
        }
        Arrays.sort(objectArray, new IndexComparator());
        if (n3 > n) {
            for (n2 = objectArray.length - 1; n2 >= 0 && !(((Entry)objectArray[n2]).getImportance() >= 1.0f); --n2) {
                ((AbbrevInfo)this.abbrevInfos.get((int)n2)).isSkip = true;
                ((Entry)objectArray[n2]).setSkip(true);
                n3 -= ((Entry)objectArray[n2]).getLengthAtTarget();
            }
        }
        if (object != null && n3 > n) {
            ((Entry)object).setTargetWeight(0.56f);
            abbrevInfo = (AbbrevInfo)this.abbrevInfos.get(((Entry)object).getIndex());
            abbrevInfo.abbrev = ((Entry)object).elide(-1);
        }
        return objectArray;
    }

    private static final class IndexComparator
    implements Comparator {
        private IndexComparator() {
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return entry.index - entry2.index;
        }
    }

    private static class AbbrevInfo {
        boolean isSkip = false;
        char[] abbrev = null;

        private AbbrevInfo() {
        }
    }
}

