/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class ExitDialog
extends JPanel
implements ActionListener {
    static boolean SAVE_ALL_UNCONDITIONALLY = false;
    private static Object[] exitOptions;
    private static Dialog exitDialog;
    private static boolean result;
    JList list;
    DefaultListModel listModel;

    private ExitDialog(Set set) {
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        Set set2 = ExitDialog.getModifiedFiles(set);
        if (!set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                DataObject dataObject = (DataObject)iterator.next();
                this.listModel.addElement(dataObject);
            }
            this.draw();
        }
    }

    private void draw() {
        this.list = new JList(this.listModel);
        this.list.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExitDialog.this.updateSaveButton();
            }
        });
        if (!this.listModel.isEmpty()) {
            this.list.setSelectedIndex(0);
        } else {
            this.updateSaveButton();
        }
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(12, 12, 11, 0), jScrollPane.getBorder()));
        this.add((Component)jScrollPane, "Center");
        this.list.setCellRenderer(new ExitDlgListCellRenderer());
        this.list.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ExitDialog.class).getString("ACSN_ListOfChangedFiles"));
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ExitDialog.class).getString("ACSD_ListOfChangedFiles"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ExitDialog.class).getString("ACSD_ExitDialog"));
    }

    private void updateSaveButton() {
        ((JButton)exitOptions[0]).setEnabled(this.list.getSelectedIndex() != -1);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(300, dimension.width), Math.max(150, dimension.height));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (exitOptions[0].equals(actionEvent.getSource())) {
            this.save(false);
        } else if (exitOptions[1].equals(actionEvent.getSource())) {
            this.save(true);
        } else if (exitOptions[2].equals(actionEvent.getSource())) {
            this.theEnd();
        } else if (NotifyDescriptor.CANCEL_OPTION.equals(actionEvent.getSource())) {
            exitDialog.setVisible(false);
        }
    }

    private void save(boolean bl) {
        Object[] objectArray = bl ? this.listModel.toArray() : this.list.getSelectedValues();
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DataObject dataObject = (DataObject)objectArray[i];
            n2 = this.listModel.indexOf(dataObject);
            this.save(dataObject);
        }
        if (this.listModel.isEmpty()) {
            this.theEnd();
        } else {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.listModel.size() - 1) {
                n2 = this.listModel.size() - 1;
            }
            this.list.setSelectedIndex(n2);
        }
    }

    private void save(DataObject dataObject) {
        try {
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            this.listModel.removeElement(dataObject);
        }
        catch (IOException iOException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            Throwable throwable = errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)ExitDialog.class).getString("EXC_Save"));
            errorManager.notify(4096, throwable);
        }
    }

    private static void doSave(DataObject dataObject) {
        try {
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            Throwable throwable = errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)ExitDialog.class).getString("EXC_Save"));
            errorManager.notify(4096, throwable);
        }
    }

    private void theEnd() {
        for (int i = this.listModel.size() - 1; i >= 0; --i) {
            DataObject dataObject = (DataObject)this.listModel.getElementAt(i);
            dataObject.setModified(false);
        }
        result = true;
        exitDialog.setVisible(false);
        exitDialog.dispose();
    }

    public static boolean showDialog(Set set) {
        return ExitDialog.innerShowDialog(ExitDialog.getModifiedFiles(set));
    }

    private static Set getModifiedFiles(Set set) {
        HashSet<DataObject> hashSet = new HashSet<DataObject>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            if (!dataObject.isModified()) continue;
            hashSet.add(dataObject);
        }
        return hashSet;
    }

    private static boolean innerShowDialog(Set set) {
        if (!set.isEmpty()) {
            if (SAVE_ALL_UNCONDITIONALLY) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    DataObject dataObject = (DataObject)iterator.next();
                    ExitDialog.doSave(dataObject);
                }
                return true;
            }
            exitDialog = null;
            if (exitDialog == null) {
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)ExitDialog.class);
                JButton jButton = new JButton();
                jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Save"));
                JButton jButton2 = new JButton();
                jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_SaveAll"));
                JButton jButton3 = new JButton();
                jButton3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DiscardAll"));
                jButton.setText(resourceBundle.getString("CTL_Save"));
                jButton.setMnemonic(resourceBundle.getString("CTL_Save_MNM").charAt(0));
                jButton2.setText(resourceBundle.getString("CTL_SaveAll"));
                jButton2.setMnemonic(resourceBundle.getString("CTL_SaveAll_MNM").charAt(0));
                jButton3.setText(resourceBundle.getString("CTL_DiscardAll"));
                jButton3.setMnemonic(resourceBundle.getString("CTL_DiscardAll_MNM").charAt(0));
                exitOptions = new Object[]{jButton, jButton2, jButton3};
                ExitDialog exitDialog = null;
                exitDialog = new ExitDialog(set);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)exitDialog, resourceBundle.getString("CTL_ExitTitle"), true, exitOptions, NotifyDescriptor.CANCEL_OPTION, 1, null, (ActionListener)exitDialog);
                dialogDescriptor.setAdditionalOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
                ExitDialog.exitDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            }
            result = false;
            exitDialog.setVisible(true);
            return result;
        }
        return true;
    }

    static {
        result = false;
    }

    private class ExitDlgListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border hasFocusBorder;
        protected Border noFocusBorder;

        public ExitDlgListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataObject dataObject = (DataObject)object;
            if (!dataObject.isValid()) {
                SwingUtilities.invokeLater(new Runnable(this, dataObject){
                    private final /* synthetic */ DataObject val$obj;
                    private final /* synthetic */ ExitDlgListCellRenderer this$1;
                    {
                        this.this$1 = exitDlgListCellRenderer;
                        this.val$obj = dataObject;
                    }

                    public void run() {
                        ExitDlgListCellRenderer.access$100((ExitDlgListCellRenderer)this.this$1).listModel.removeElement(this.val$obj);
                    }
                });
                this.setText("");
                return this;
            }
            Node node = dataObject.getNodeDelegate();
            ImageIcon imageIcon = new ImageIcon(node.getIcon(1));
            super.setIcon(imageIcon);
            this.setText(node.getDisplayName());
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? this.hasFocusBorder : this.noFocusBorder);
            return this;
        }

        static /* synthetic */ ExitDialog access$100(ExitDlgListCellRenderer exitDlgListCellRenderer) {
            return exitDlgListCellRenderer.ExitDialog.this;
        }
    }
}

