/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class OpenProjectList {
    public static final Comparator PROJECT_BY_DISPLAYNAME;
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    private static OpenProjectList INSTANCE;
    private static final ErrorManager ERR;
    private static final RequestProcessor OPENING_RP;
    private List openProjects = new ArrayList();
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private List recentTemplates;
    private final PropertyChangeSupport pchSupport = new PropertyChangeSupport(this);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$SubprojectProvider;

    OpenProjectList() {
        this.recentProjects = new RecentProjectList(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjectList getDefault() {
        URL uRL;
        boolean bl = false;
        Object object = OpenProjectList.class;
        synchronized (object) {
            if (INSTANCE == null) {
                bl = true;
                INSTANCE = new OpenProjectList();
                OpenProjectList.INSTANCE.openProjects = OpenProjectList.loadProjectList();
                OpenProjectList.INSTANCE.recentTemplates = new ArrayList(OpenProjectListSettings.getInstance().getRecentTemplates());
                uRL = OpenProjectListSettings.getInstance().getMainProjectURL();
                OpenProjectList.INSTANCE.recentProjects.load();
                Iterator iterator = OpenProjectList.INSTANCE.openProjects.iterator();
                while (iterator.hasNext()) {
                    Project project = (Project)iterator.next();
                    try {
                        if (uRL == null || !uRL.equals(project.getProjectDirectory().getURL())) continue;
                        OpenProjectList.INSTANCE.mainProject = project;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                }
            }
        }
        if (bl) {
            object = new ArrayList(OpenProjectList.INSTANCE.openProjects).iterator();
            while (object.hasNext()) {
                uRL = (Project)object.next();
                OpenProjectList.notifyOpened((Project)uRL);
            }
        }
        return INSTANCE;
    }

    public void open(Project project) {
        this.open(new Project[]{project}, false);
    }

    public void open(Project project, boolean bl) {
        this.open(new Project[]{project}, bl);
    }

    public void open(Project[] projectArray, boolean bl) {
        this.open(projectArray, bl, false);
    }

    public void open(final Project[] projectArray, final boolean bl, boolean bl2) {
        if (projectArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl2) {
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame frame = WindowManager.getDefault().getMainWindow();
            final JDialog jDialog = new JDialog(frame, NbBundle.getMessage((Class)OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel openingProjectPanel = new OpeningProjectPanel(progressHandle);
            jDialog.getContentPane().add(openingProjectPanel);
            jDialog.setDefaultCloseOperation(0);
            jDialog.pack();
            Rectangle rectangle = frame.getBounds();
            int n = rectangle.x + rectangle.width / 2;
            int n2 = rectangle.y + rectangle.height / 2;
            Dimension dimension = jDialog.getPreferredSize();
            jDialog.setBounds(n - dimension.width / 2, n2 - dimension.height / 2, dimension.width, dimension.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projectArray, bl, progressHandle, openingProjectPanel);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                1.access$100(this.this$1).setVisible(false);
                                1.access$100(this.this$1).dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }

                static /* synthetic */ JDialog access$100(1 var0) {
                    return var0.jDialog;
                }
            });
            jDialog.setVisible(true);
        } else {
            this.doOpen(projectArray, bl, null, null);
        }
        long l2 = System.currentTimeMillis();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "opening projects took: " + (l2 - l) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projectArray, boolean bl, ProgressHandle progressHandle, OpeningProjectPanel openingProjectPanel) {
        int n;
        Project project;
        if (!$assertionsDisabled && Arrays.asList(projectArray).contains(null)) {
            throw new AssertionError((Object)"Projects can't be null");
        }
        boolean bl2 = false;
        int n2 = 1000;
        int n3 = n2 / 2;
        double d = 0.0;
        LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>();
        if (progressHandle != null) {
            progressHandle.start(n2);
            progressHandle.progress(0);
        }
        if (openingProjectPanel != null) {
            if (!$assertionsDisabled && projectArray.length <= 0) {
                throw new AssertionError((Object)"at least one project to open");
            }
            openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName());
        }
        HashMap<Project, Set> hashMap = new HashMap<Project, Set>();
        LinkedList<Project> linkedList = new LinkedList<Project>(Arrays.asList(projectArray));
        while (!linkedList.isEmpty()) {
            SubprojectProvider subprojectProvider;
            Set set;
            Project project2 = (Project)linkedList.remove(0);
            Set set2 = set = bl ? (Set)hashMap.get(project2) : Collections.EMPTY_SET;
            if (set == null) {
                subprojectProvider = (SubprojectProvider)project2.getLookup().lookup(class$org$netbeans$spi$project$SubprojectProvider == null ? OpenProjectList.class$("org.netbeans.spi.project.SubprojectProvider") : class$org$netbeans$spi$project$SubprojectProvider);
                set = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.EMPTY_SET;
                hashMap.put(project2, set);
            }
            linkedHashSet.add(project2);
            subprojectProvider = set.iterator();
            while (subprojectProvider.hasNext()) {
                project = (Project)subprojectProvider.next();
                if (linkedHashSet.contains(project) || linkedList.contains(project)) continue;
                linkedList.add(project);
            }
            double d2 = ((double)n3 - d) / (double)(linkedList.size() + 1);
            n = (int)d;
            if (progressHandle == null || n >= (int)(d += d2)) continue;
            progressHandle.progress((int)d);
        }
        double d3 = (n2 - n3) / linkedHashSet.size();
        Object object = linkedHashSet.iterator();
        while (object.hasNext()) {
            project = (Project)object.next();
            if (openingProjectPanel != null) {
                openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)project).getDisplayName());
            }
            bl2 |= this.doOpenProject(project);
            n = (int)d;
            if (progressHandle == null || n >= (int)(d += d3)) continue;
            progressHandle.progress((int)d);
        }
        object = this;
        synchronized (object) {
            OpenProjectList.saveProjectList(this.openProjects);
            if (bl2) {
                this.recentProjects.save();
            }
        }
        if (progressHandle != null) {
            progressHandle.finish();
        }
        final boolean bl3 = bl2;
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, null, null);
                if (bl3) {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] projectArray) {
        boolean bl = false;
        boolean bl2 = false;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            for (int i = 0; i < projectArray.length; ++i) {
                if (!this.openProjects.contains(projectArray[i])) continue;
                if (!bl) {
                    bl = this.isMainProject(projectArray[i]);
                }
                this.openProjects.remove(projectArray[i]);
                this.recentProjects.add(projectArray[i]);
                OpenProjectList.notifyClosed(projectArray[i]);
                bl2 = true;
            }
            if (bl2) {
                OpenProjectList.saveProjectList(this.openProjects);
            }
            if (bl) {
                this.mainProject = null;
                OpenProjectList.saveMainProject(this.mainProject);
            }
            if (bl2) {
                this.recentProjects.save();
            }
        }
        if (bl2) {
            this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, null, null);
        }
        if (bl) {
            this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
        }
        if (bl2) {
            this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
        }
    }

    public synchronized Project[] getOpenProjects() {
        Project[] projectArray = new Project[this.openProjects.size()];
        this.openProjects.toArray(projectArray);
        return projectArray;
    }

    public synchronized boolean isOpen(Project project) {
        Iterator iterator = this.openProjects.iterator();
        while (iterator.hasNext()) {
            Project project2 = (Project)iterator.next();
            if (!project.getProjectDirectory().equals(project2.getProjectDirectory())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMainProject(Project project) {
        return this.mainProject != null && project != null && this.mainProject.getProjectDirectory().equals(project.getProjectDirectory());
    }

    public synchronized Project getMainProject() {
        return this.mainProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProject(Project project) {
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (!this.openProjects.contains(project)) {
                throw new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)project).getDisplayName() + " is not open and cannot be set as main.");
            }
            this.mainProject = project;
            OpenProjectList.saveMainProject(project);
        }
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public synchronized List getRecentProjects() {
        return this.recentProjects.getProjects();
    }

    public synchronized boolean isRecentProjectsEmpty() {
        return this.recentProjects.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public List getTemplatesLRU(Project project) {
        ArrayList arrayList = this.getTemplateNamesLRU(project);
        ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    arrayList2.add(dataObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    iterator.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
                continue;
            }
            iterator.remove();
        }
        return arrayList2;
    }

    public void updateTemplatesLRU(FileObject fileObject) {
        String string = fileObject.getPath();
        if (this.recentTemplates.contains(string)) {
            this.recentTemplates.remove(string);
        }
        this.recentTemplates.add(0, string);
        if (this.recentTemplates.size() > 100) {
            this.recentTemplates.remove(100);
        }
        OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList(this.recentTemplates));
    }

    static void shutdown() {
        if (INSTANCE != null) {
            Iterator iterator = OpenProjectList.INSTANCE.openProjects.iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                OpenProjectList.notifyClosed(project);
            }
        }
    }

    public static Project fileToProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.isFolder()) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    private static List URLs2Projects(Collection collection) {
        ArrayList<Project> arrayList = new ArrayList<Project>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null || !fileObject.isFolder()) continue;
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project == null) continue;
                arrayList.add(project);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                ErrorManager.getDefault().notify(1, throwable);
            }
        }
        return arrayList;
    }

    private static List projects2URLs(Collection collection) {
        ArrayList<URL> arrayList = new ArrayList<URL>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            try {
                URL uRL = project.getProjectDirectory().getURL();
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return arrayList;
    }

    private static void notifyOpened(Project project) {
        Lookup.Result result = project.getLookup().lookup(new Lookup.Template(ProjectOpenedHook.class));
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            ProjectOpenedHook projectOpenedHook = (ProjectOpenedHook)iterator.next();
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
                OpenProjectList.INSTANCE.openProjects.remove(project);
            }
            catch (Error error) {
                ErrorManager.getDefault().notify((Throwable)error);
                OpenProjectList.INSTANCE.openProjects.remove(project);
            }
        }
    }

    private static void notifyClosed(Project project) {
        Lookup.Result result = project.getLookup().lookup(new Lookup.Template(ProjectOpenedHook.class));
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            ProjectOpenedHook projectOpenedHook = (ProjectOpenedHook)iterator.next();
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
            }
            catch (Error error) {
                ErrorManager.getDefault().notify((Throwable)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOpenProject(final Project project) {
        boolean bl;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (this.openProjects.contains(project)) {
                return false;
            }
            this.openProjects.add(project);
            bl = this.recentProjects.remove(project);
        }
        OpenProjectList.notifyOpened(project);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                ProjectUtilities.openProjectFiles(project);
                return null;
            }
        });
        return bl;
    }

    private static List loadProjectList() {
        List list = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List list2 = OpenProjectList.URLs2Projects(list);
        return list2;
    }

    private static void saveProjectList(List list) {
        List list2 = OpenProjectList.projects2URLs(list);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(list2);
    }

    private static void saveMainProject(Project project) {
        try {
            URL uRL = project == null ? null : project.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(uRL);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    private ArrayList getTemplateNamesLRU(Project project) {
        FileObject fileObject;
        String string;
        int n;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(10);
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] stringArray = recommendedTemplates == null ? new String[]{} : recommendedTemplates.getRecommendedTypes();
        PrivilegedTemplates privilegedTemplates = (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] stringArray2 = privilegedTemplates == null ? null : privilegedTemplates.getPrivilegedTemplates();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(privilegedTemplates == null ? new String[]{} : stringArray2));
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator<Object> iterator = this.recentTemplates.iterator();
        for (n = 0; n < 10 && iterator.hasNext(); ++n) {
            string = (String)iterator.next();
            fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                iterator.remove();
                continue;
            }
            if (!OpenProjectList.isRecommended(project, fileObject)) continue;
            arrayList.add(fileObject);
            arrayList2.remove(string);
        }
        iterator = arrayList2.iterator();
        for (n = arrayList.size(); n < 10 && iterator.hasNext(); ++n) {
            string = (String)iterator.next();
            fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    static boolean isRecommended(Project project, FileObject fileObject) {
        if (OpenProjectList.getRecommendedTypes(project) == null || OpenProjectList.getRecommendedTypes(project).length == 0) {
            return true;
        }
        Object object = fileObject.getAttribute("templateCategory");
        if (object != null) {
            if (!$assertionsDisabled && !(object instanceof String)) {
                throw new AssertionError((Object)(fileObject + " attr templateCategory = " + object));
            }
            Iterator iterator = OpenProjectList.getCategories((String)object).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(project)).contains(string)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return recommendedTemplates == null ? null : recommendedTemplates.getRecommendedTypes();
    }

    private static List getCategories(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !OpenProjectList.class.desiredAssertionStatus();
        PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
        ERR = ErrorManager.getDefault().getInstance(OpenProjectList.class.getName());
        OPENING_RP = new RequestProcessor("Opening projects", 1);
    }

    public static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        public int compare(Object object, Object object2) {
            if (!(object instanceof Project)) {
                return 1;
            }
            if (!(object2 instanceof Project)) {
                return -1;
            }
            Project project = (Project)object;
            Project project2 = (Project)object2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
        }
    }

    private static class RecentProjectList {
        private List recentProjects;
        private int size;

        public RecentProjectList(int n) {
            this.size = n;
            this.recentProjects = new ArrayList(n);
            if (ERR.isLoggable(1)) {
                ERR.log("created a RecentProjectList: size=" + n);
            }
        }

        public void add(Project project) {
            int n = this.getIndex(project);
            if (n == -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("add new recent project: " + project);
                }
                if (this.recentProjects.size() == this.size) {
                    this.recentProjects.remove(this.size - 1);
                }
                this.recentProjects.add(0, new ProjectReference(project));
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("re-add recent project: " + project);
                }
                this.recentProjects.remove(n);
                this.recentProjects.add(0, new ProjectReference(project));
            }
        }

        public boolean remove(Project project) {
            int n = this.getIndex(project);
            if (n != -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("remove recent project: " + project);
                }
                this.recentProjects.remove(n);
                return true;
            }
            return false;
        }

        public List getProjects() {
            ArrayList<Project> arrayList = new ArrayList<Project>(this.recentProjects.size());
            ArrayList arrayList2 = new ArrayList(this.recentProjects);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ProjectReference projectReference = (ProjectReference)iterator.next();
                Project project = projectReference.getProject();
                if (project == null || !project.getProjectDirectory().isValid()) {
                    this.remove(project);
                    if (!ERR.isLoggable(1)) continue;
                    ERR.log("removing dead recent project: " + project);
                    continue;
                }
                arrayList.add(project);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects: " + arrayList);
            }
            return arrayList;
        }

        public boolean isEmpty() {
            boolean bl = this.recentProjects.isEmpty();
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects empty? " + bl);
            }
            return bl;
        }

        public void load() {
            List list = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list load: " + list);
            }
            this.recentProjects.clear();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.recentProjects.add(new ProjectReference((URL)iterator.next()));
            }
        }

        public void save() {
            ArrayList<URL> arrayList = new ArrayList<URL>(this.recentProjects.size());
            Iterator iterator = this.recentProjects.iterator();
            while (iterator.hasNext()) {
                ProjectReference projectReference = (ProjectReference)iterator.next();
                URL uRL = projectReference.getURL();
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list save: " + arrayList);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(arrayList);
        }

        private int getIndex(Project project) {
            URL uRL;
            try {
                if (project == null || project.getProjectDirectory() == null) {
                    return -1;
                }
                uRL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return -1;
            }
            int n = 0;
            Iterator iterator = this.recentProjects.iterator();
            while (iterator.hasNext()) {
                URL uRL2 = ((ProjectReference)iterator.next()).getURL();
                if (uRL.equals(uRL2)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private static class ProjectReference {
            private WeakReference projectReference;
            private URL projectURL;

            public ProjectReference(URL uRL) {
                this.projectURL = uRL;
            }

            public ProjectReference(Project project) {
                block2: {
                    this.projectReference = new WeakReference<Project>(project);
                    try {
                        this.projectURL = project.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!ERR.isLoggable(1)) break block2;
                        ERR.log("FSIE getting URL for project: " + project.getProjectDirectory());
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject fileObject;
                    Project project = null;
                    if (this.projectReference != null && (project = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(project)) {
                            return project;
                        }
                        return null;
                    }
                    if (ERR.isLoggable(1)) {
                        ERR.log("no active project reference for " + this.projectURL);
                    }
                    if (this.projectURL != null && (fileObject = URLMapper.findFileObject((URL)this.projectURL)) != null && fileObject.isFolder()) {
                        try {
                            project = ProjectManager.getDefault().findProject(fileObject);
                            if (project != null) {
                                this.projectReference = new WeakReference<Project>(project);
                                if (ERR.isLoggable(1)) {
                                    ERR.log("found " + project);
                                }
                                return project;
                            }
                        }
                        catch (IOException iOException) {
                            if (!ERR.isLoggable(1)) break block9;
                            ERR.log("could not load recent project from " + this.projectURL);
                        }
                    }
                }
                if (ERR.isLoggable(1)) {
                    ERR.log("no recent project in " + this.projectURL);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }
        }
    }
}

