/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openide.filesystems.FileUtil;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class OpenProjectListSettings
extends SystemOption {
    private static final String OPEN_PROJECTS_URLS = "OpenProjectsURLs";
    private static final String LAST_OPEN_PROJECT_DIR = "LastOpenProjectDir";
    private static final String OPEN_SUBPROJECTS = "OpenSubprojects";
    private static final String OPEN_AS_MAIN = "OpenAsMain";
    private static final String MAIN_PROJECT_URL = "MainProjectURL";
    private static final String RECENT_PROJECTS_URLS = "RecentProjectsURLs";
    private static final String PROP_PROJECTS_FOLDER = "projectsFolder";
    private static final String RECENT_TEMPLATES = "recentlyUsedTemplates";
    private static final String PROP_PROJECT_CATEGORY = "lastSelectedProjectCategory";
    private static final String PROP_PROJECT_TYPE = "lastSelectedProjectType";
    private static final long serialVersionUID = 8754987489474L;

    public static OpenProjectListSettings getInstance() {
        return (OpenProjectListSettings)SystemOption.findObject((Class)OpenProjectListSettings.class, (boolean)true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)OpenProjectListSettings.class, (String)"TXT_UISettings");
    }

    public List getOpenProjectsURLs() {
        List list = (List)this.getProperty(OPEN_PROJECTS_URLS);
        return list == null ? new ArrayList(3) : list;
    }

    public void setOpenProjectsURLs(List list) {
        this.putProperty(OPEN_PROJECTS_URLS, list, true);
    }

    public boolean isOpenSubprojects() {
        Boolean bl = (Boolean)this.getProperty(OPEN_SUBPROJECTS);
        return bl == null ? true : bl;
    }

    public void setOpenSubprojects(boolean bl) {
        this.putProperty(OPEN_SUBPROJECTS, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isOpenAsMain() {
        Boolean bl = (Boolean)this.getProperty(OPEN_AS_MAIN);
        return bl == null ? true : bl;
    }

    public void setOpenAsMain(boolean bl) {
        this.putProperty(OPEN_AS_MAIN, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public URL getMainProjectURL() {
        return (URL)this.getProperty(MAIN_PROJECT_URL);
    }

    public void setMainProjectURL(URL uRL) {
        this.putProperty(MAIN_PROJECT_URL, uRL, true);
    }

    public String getLastOpenProjectDir() {
        String string = (String)this.getProperty(LAST_OPEN_PROJECT_DIR);
        if (string == null) {
            string = this.getProjectsFolder().getAbsolutePath();
        }
        return string;
    }

    public void setLastOpenProjectDir(String string) {
        this.putProperty(LAST_OPEN_PROJECT_DIR, string, true);
    }

    public List getRecentProjectsURLs() {
        List list = (List)this.getProperty(RECENT_PROJECTS_URLS);
        return list == null ? new ArrayList(5) : list;
    }

    public void setRecentProjectsURLs(List list) {
        this.putProperty(RECENT_PROJECTS_URLS, list, true);
    }

    public File getProjectsFolder() {
        String string = (String)this.getProperty(PROP_PROJECTS_FOLDER);
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return FileUtil.normalizeFile((File)new File(string));
    }

    public void setProjectsFolder(File file) {
        if (file == null) {
            this.putProperty(PROP_PROJECTS_FOLDER, null);
        } else {
            this.putProperty(PROP_PROJECTS_FOLDER, file.getAbsolutePath());
        }
    }

    public List getRecentTemplates() {
        List list = (List)this.getProperty(RECENT_TEMPLATES);
        return list == null ? new ArrayList(100) : list;
    }

    public void setRecentTemplates(List list) {
        this.putProperty(RECENT_TEMPLATES, list, true);
    }

    public String getLastSelectedProjectCategory() {
        return (String)this.getProperty(PROP_PROJECT_CATEGORY);
    }

    public void setLastSelectedProjectCategory(String string) {
        this.putProperty(PROP_PROJECT_CATEGORY, string, true);
    }

    public String getLastSelectedProjectType() {
        return (String)this.getProperty(PROP_PROJECT_TYPE);
    }

    public void setLastSelectedProjectType(String string) {
        this.putProperty(PROP_PROJECT_TYPE, string, true);
    }
}

