/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectTab
extends TopComponent
implements ExplorerManager.Provider {
    public static final String ID_LOGICAL = "projectTabLogical_tc";
    public static final String ID_PHYSICAL = "projectTab_tc";
    private static final Image ICON_LOGICAL = Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.gif");
    private static final Image ICON_PHYSICAL = Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.gif");
    private static Map tabs = new HashMap();
    private final transient ExplorerManager manager;
    private transient Node rootNode;
    private String id;
    private final transient ProjectTreeView btv;
    private static final long serialVersionUID = 9374872358L;
    private final RequestProcessor RP = new RequestProcessor();
    static /* synthetic */ Class class$org$netbeans$api$project$Project;
    static /* synthetic */ Class class$org$netbeans$spi$project$ActionProvider;

    public ProjectTab(String string) {
        this();
        this.id = string;
        this.initValues(string);
    }

    public ProjectTab() {
        this.manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", new DelegatingAction("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true)));
        this.initComponents();
        this.btv = new ProjectTreeView();
        this.btv.setDragSource(true);
        this.btv.setRootVisible(false);
        this.add((Component)((Object)this.btv), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
    }

    private void initValues(String string) {
        String string2 = NbBundle.getMessage((Class)ProjectTab.class, (String)("LBL_" + string));
        this.setName(string2);
        this.setToolTipText(string2);
        if (string.equals(ID_LOGICAL)) {
            this.setIcon(ICON_LOGICAL);
        } else {
            this.setIcon(ICON_PHYSICAL);
        }
        if (this.rootNode == null) {
            this.rootNode = new ProjectsRootNode(string.equals(ID_LOGICAL) ? 1 : 0);
        }
        this.manager.setRootContext(this.rootNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static synchronized ProjectTab findDefault(String string) {
        ProjectTab projectTab = (ProjectTab)((Object)tabs.get(string));
        if (projectTab == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
            if (topComponent != null) {
                if (!(topComponent instanceof ProjectTab)) {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + ProjectTab.class.getName() + " Returned:" + topComponent.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                    projectTab = ProjectTab.getDefault(string);
                } else {
                    projectTab = (ProjectTab)topComponent;
                }
            } else {
                projectTab = ProjectTab.getDefault(string);
            }
        }
        return projectTab;
    }

    public static synchronized ProjectTab getDefault(String string) {
        ProjectTab projectTab = (ProjectTab)((Object)tabs.get(string));
        if (projectTab == null) {
            projectTab = new ProjectTab(string);
            tabs.put(string, projectTab);
        }
        return projectTab;
    }

    public static TopComponent getLogical() {
        return ProjectTab.getDefault(ID_LOGICAL);
    }

    public static TopComponent getPhysical() {
        return ProjectTab.getDefault(ID_PHYSICAL);
    }

    protected String preferredID() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.manager.getSelectedNodes(), (HelpCtx)(ID_LOGICAL.equals(this.id) ? new HelpCtx("ProjectTab_Projects") : new HelpCtx("ProjectTab_Files")));
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.btv.requestFocus();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.rootNode.getHandle());
        objectOutput.writeObject(this.btv.getExpandedPaths());
        objectOutput.writeObject(this.getSelectedPaths());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.id = (String)objectInput.readObject();
        this.rootNode = ((Node.Handle)objectInput.readObject()).getNode();
        List list = (List)objectInput.readObject();
        List list2 = null;
        try {
            list2 = (List)objectInput.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.initValues(this.id);
        if (System.getProperty("netbeans.keep.expansion") != null) {
            this.btv.expandNodes(list);
            this.selectPaths(list2);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public void selectNodeAsync(final FileObject fileObject) {
        this.setCursor(Utilities.createProgressCursor((Component)((Object)this)));
        this.open();
        this.requestActive();
        this.RP.post(new Runnable(){

            public void run() {
                ProjectsRootNode projectsRootNode = (ProjectsRootNode)ProjectTab.this.manager.getRootContext();
                Node node = projectsRootNode.findNode(fileObject);
                SwingUtilities.invokeLater(new Runnable(this, node){
                    private final /* synthetic */ Node val$selectedNode;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$selectedNode = node;
                    }

                    public void run() {
                        if (this.val$selectedNode != null) {
                            try {
                                ProjectTab.access$100(1.access$200(this.this$1)).setSelectedNodes(new Node[]{this.val$selectedNode});
                                ProjectTab.access$300(1.access$200(this.this$1)).scrollToNode(this.val$selectedNode);
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectTab == null ? (class$org$netbeans$modules$project$ui$ProjectTab = ProjectTab.class$("org.netbeans.modules.project.ui.ProjectTab")) : class$org$netbeans$modules$project$ui$ProjectTab), (String)("projectTabLogical_tc".equals(ProjectTab.access$400(1.access$200(this.this$1))) ? "MSG_NodeNotFound_ProjectsTab" : "MSG_NodeNotFound_FilesTab")));
                        }
                        1.access$200(this.this$1).setCursor(null);
                    }
                });
            }

            static /* synthetic */ ProjectTab access$200(1 var0) {
                return var0.ProjectTab.this;
            }
        });
    }

    public boolean selectNode(FileObject fileObject) {
        ProjectsRootNode projectsRootNode = (ProjectsRootNode)this.manager.getRootContext();
        Node node = projectsRootNode.findNode(fileObject);
        if (node != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node});
                this.btv.scrollToNode(node);
                return true;
            }
            catch (PropertyVetoException propertyVetoException) {
                return false;
            }
        }
        return false;
    }

    public void expandNode(Node node) {
        this.btv.expandNode(node);
    }

    private List getSelectedPaths() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Node node = this.manager.getRootContext();
        for (int i = 0; i < nodeArray.length; ++i) {
            String[] stringArray = NodeOp.createPath((Node)nodeArray[i], (Node)node);
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    private void selectPaths(List list) {
        if (list == null) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = this.manager.getRootContext();
        Node[] nodeArray = list.iterator();
        while (nodeArray.hasNext()) {
            String[] stringArray = (String[])nodeArray.next();
            try {
                Node node2 = NodeOp.findPath((Node)node, (String[])stringArray);
                if (node2 == null) continue;
                arrayList.add(node2);
            }
            catch (NodeNotFoundException nodeNotFoundException) {}
        }
        if (!arrayList.isEmpty()) {
            nodeArray = new Node[arrayList.size()];
            arrayList.toArray(nodeArray);
            try {
                this.manager.setSelectedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ ProjectTreeView access$300(ProjectTab projectTab) {
        return projectTab.btv;
    }

    static /* synthetic */ String access$400(ProjectTab projectTab) {
        return projectTab.id;
    }

    private class DelegatingAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action explorerAction;
        private String projectAction;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DelegatingAction(String string, Action action) {
            this.projectAction = string;
            this.explorerAction = action;
            ProjectTab.this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            action.addPropertyChangeListener(this);
        }

        private boolean isProject() {
            Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
            if (nodeArray.length == 1) {
                return nodeArray[0].getParentNode() == ProjectTab.this.rootNode;
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isProject()) {
                Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
                Project project = (Project)nodeArray[0].getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectTab.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project);
                if (!$assertionsDisabled && project == null) {
                    throw new AssertionError();
                }
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(class$org$netbeans$spi$project$ActionProvider == null ? (class$org$netbeans$spi$project$ActionProvider = ProjectTab.class$("org.netbeans.spi.project.ActionProvider")) : class$org$netbeans$spi$project$ActionProvider);
                actionProvider.invokeAction(this.projectAction, nodeArray[0].getLookup());
            } else {
                this.explorerAction.actionPerformed(actionEvent);
            }
        }

        public void updateIsEnabled() {
            if (this.isProject()) {
                Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
                Project project = (Project)nodeArray[0].getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectTab.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project);
                if (project == null) {
                    this.setEnabled(false);
                    return;
                }
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(class$org$netbeans$spi$project$ActionProvider == null ? (class$org$netbeans$spi$project$ActionProvider = ProjectTab.class$("org.netbeans.spi.project.ActionProvider")) : class$org$netbeans$spi$project$ActionProvider);
                String[] stringArray = actionProvider != null ? actionProvider.getSupportedActions() : new String[]{};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!"delete".equals(stringArray[i])) continue;
                    this.setEnabled(actionProvider.isActionEnabled(this.projectAction, nodeArray[0].getLookup()));
                    return;
                }
                this.setEnabled(false);
            } else {
                this.setEnabled(this.explorerAction.isEnabled());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateIsEnabled();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$ui$ProjectTab == null ? (class$org$netbeans$modules$project$ui$ProjectTab = ProjectTab.class$("org.netbeans.modules.project.ui.ProjectTab")) : class$org$netbeans$modules$project$ui$ProjectTab).desiredAssertionStatus();
        }
    }

    private class ProjectTreeView
    extends BeanTreeView {
        private ProjectTreeView() {
        }

        public void scrollToNode(Node node) {
            TreeNode treeNode = Visualizer.findVisualizer((Node)node);
            if (treeNode == null) {
                return;
            }
            TreeModel treeModel = this.tree.getModel();
            if (!(treeModel instanceof DefaultTreeModel)) {
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)treeModel).getPathToRoot(treeNode));
            Rectangle rectangle = this.tree.getPathBounds(treePath);
            if (rectangle != null) {
                this.tree.scrollRectToVisible(rectangle);
            }
        }

        public List getExpandedPaths() {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            TreeNode treeNode = Visualizer.findVisualizer((Node)ProjectTab.this.rootNode);
            TreePath treePath = new TreePath(treeNode);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
            while (enumeration != null && enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                Node node = Visualizer.findNode((Object)treePath2.getLastPathComponent());
                String[] stringArray = NodeOp.createPath((Node)node, (Node)ProjectTab.this.rootNode);
                arrayList.add(stringArray);
            }
            return arrayList;
        }

        public void expandNodes(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                TreePath treePath = this.stringPath2TreePath(stringArray);
                if (treePath == null) continue;
                this.showPath(treePath);
            }
        }

        private TreePath stringPath2TreePath(String[] stringArray) {
            try {
                Node node = NodeOp.findPath((Node)ProjectTab.this.rootNode, (String[])stringArray);
                Object[] objectArray = new TreeNode[stringArray.length + 1];
                for (int i = stringArray.length; i >= 0; --i) {
                    if (node == null) {
                        return null;
                    }
                    objectArray[i] = Visualizer.findVisualizer((Node)node);
                    node = node.getParentNode();
                }
                return new TreePath(objectArray);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
    }
}

