/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectUtilities {
    static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    static final String OPEN_FILES_ELEMENT = "open-files";
    static final String FILE_ELEMENT = "file";
    static OpenCloseProjectDocument OPEN_CLOSE_PROJECT_DOCUMENT_IMPL;
    private static final ErrorManager ERR;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");

            public void run() {
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                        this.ptLogial.expandNode(node2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject dataObject) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Node node = dataObject.getNodeDelegate();
                Action action = node.getPreferredAction();
                if (action instanceof ContextAwareAction) {
                    action = ((ContextAwareAction)action).createContextAwareInstance(node.getLookup());
                }
                if (action != null) {
                    action.actionPerformed(new ActionEvent(node, 1001, ""));
                }
                ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
                ProjectTab projectTab2 = ProjectTab.findDefault("projectTab_tc");
                SwingUtilities.invokeLater(new Runnable(this, projectTab, projectTab2){
                    private final /* synthetic */ ProjectTab val$ptLogial;
                    private final /* synthetic */ ProjectTab val$ptPhysical;
                    private final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$ptLogial = projectTab;
                        this.val$ptPhysical = projectTab2;
                    }

                    public void run() {
                        boolean bl = this.val$ptLogial.selectNode(3.access$100(this.this$0).getPrimaryFile());
                        if (!bl) {
                            this.val$ptPhysical.selectNode(3.access$100(this.this$0).getPrimaryFile());
                        }
                    }
                });
            }

            static /* synthetic */ DataObject access$100(3 var0) {
                return var0.dataObject;
            }
        });
    }

    public static void makeProjectTabVisible(boolean bl) {
        ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
        projectTab.open();
        if (bl) {
            projectTab.requestActive();
        } else {
            projectTab.requestVisible();
        }
    }

    public static String canUseFileName(FileObject fileObject, String string, String string2, String string3, boolean bl) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (bl) {
            if (File.separatorChar == '\\') {
                n = 3;
                bl3 = true;
                bl2 = true;
            } else {
                n = 1;
                bl2 = true;
            }
        }
        if (!bl2 && string2.indexOf(47) != -1 || !bl3 && string2.indexOf(92) != -1) {
            if (!$assertionsDisabled && n != 0 && n != 1) {
                throw new AssertionError((Object)("Invalid error variant: " + n));
            }
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_not_valid_filename", (Object)string2, (Object)new Integer(n));
        }
        if (fileObject == null) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_fs_is_readonly");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('/');
        }
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        if (fileObject.getFileObject(stringBuffer.toString()) != null) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    public static boolean closeAllDocuments(Project[] projectArray) {
        if (projectArray == null) {
            throw new IllegalArgumentException("No projects are specified.");
        }
        if (projectArray.length == 0) {
            return true;
        }
        Map map = OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.close(projectArray);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                ProjectUtilities.storeProjectOpenFiles(project, (SortedSet)map.get(project));
            }
        }
        return map != null;
    }

    private static void storeProjectOpenFiles(Project project, SortedSet sortedSet) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration != null) {
            auxiliaryConfiguration.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
            Document document = XMLUtil.createDocument((String)OPEN_FILES_ELEMENT, (String)OPEN_FILES_NS, null, null);
            Element element = document.createElementNS(OPEN_FILES_NS, OPEN_FILES_ELEMENT);
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                Element element2 = element.getOwnerDocument().createElement(FILE_ELEMENT);
                element2.appendChild(element2.getOwnerDocument().createTextNode((String)iterator.next()));
                element.appendChild(element2);
            }
            auxiliaryConfiguration.putConfigurationFragment(element, false);
        }
    }

    public static void openProjectFiles(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration;
        boolean bl = ERR.isLoggable(1);
        if (bl) {
            ERR.log("Trying to open files from " + project + "...");
        }
        if ((auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class)) == null) {
            if (bl) {
                ERR.log("No AuxiliaryConfiguration in " + project);
            }
            return;
        }
        Element element = auxiliaryConfiguration.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
        if (element == null) {
            if (bl) {
                ERR.log("No open-files in private.xml");
            }
            return;
        }
        NodeList nodeList = element.getElementsByTagName(FILE_ELEMENT);
        if (nodeList == null) {
            if (bl) {
                ERR.log("No file in open-files");
            }
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            FileObject fileObject;
            String string = nodeList.item(i).getChildNodes().item(0).getNodeValue();
            if (bl) {
                ERR.log("Will try to open " + string);
            }
            try {
                fileObject = URLMapper.findFileObject((URL)new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("MalformedURLException in " + string));
                }
                continue;
            }
            if (fileObject == null) {
                if (!bl) continue;
                ERR.log("Could not find " + string);
                continue;
            }
            OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.open(fileObject);
        }
        auxiliaryConfiguration.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
    }

    static {
        $assertionsDisabled = !ProjectUtilities.class.desiredAssertionStatus();
        OPEN_CLOSE_PROJECT_DOCUMENT_IMPL = new OpenCloseProjectDocument(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean open(FileObject fileObject) {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("DataObject must exist for " + fileObject));
                    }
                    return false;
                }
                EditCookie editCookie = (EditCookie)dataObject.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = ProjectUtilities.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ProjectUtilities.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (editCookie != null) {
                    editCookie.edit();
                } else if (openCookie != null) {
                    openCookie.open();
                } else {
                    if (ERR.isLoggable(1)) {
                        ERR.log("No EditCookie nor OpenCookie for " + dataObject);
                    }
                    return false;
                }
                return true;
            }

            public Map close(Project[] projectArray) {
                Project project;
                FileObject fileObject;
                Object object;
                Object object2;
                List<Project> list = Arrays.asList(projectArray);
                HashSet<Object> hashSet = new HashSet<Object>();
                HashSet<Object> hashSet2 = new HashSet<Object>();
                HashMap hashMap = new HashMap();
                Iterator iterator = WindowManager.getDefault().getRegistry().getOpened().iterator();
                while (iterator.hasNext()) {
                    Project project2;
                    object2 = (TopComponent)iterator.next();
                    if (object2 instanceof ExplorerManager.Provider || (object = WindowManager.getDefault().findMode((TopComponent)object2)) == null || !"editor".equals(object.getName()) || (fileObject = (DataObject)object2.getLookup().lookup(class$org$openide$loaders$DataObject == null ? ProjectUtilities.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null || !list.contains(project2 = FileOwnerQuery.getOwner((FileObject)(project = fileObject.getPrimaryFile())))) continue;
                    hashSet.add(fileObject);
                    hashSet2.add(object2);
                    if (!hashMap.containsKey(project2)) {
                        hashMap.put(project2, new TreeSet());
                    }
                    URL uRL = null;
                    try {
                        uRL = fileObject.getPrimaryFile().getURL();
                        ((SortedSet)hashMap.get(project2)).add(uRL.toExternalForm());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("FileStateInvalidException in " + fileObject.getPrimaryFile()));
                        }
                    }
                }
                object2 = DataObject.getRegistry().getModifiedSet().iterator();
                while (object2.hasNext()) {
                    object = (DataObject)object2.next();
                    if (object == null || !list.contains(project = FileOwnerQuery.getOwner((FileObject)(fileObject = object.getPrimaryFile()))) || hashSet.contains(object)) continue;
                    hashSet.add(object);
                }
                if (!hashSet.isEmpty() && ExitDialog.showDialog(hashSet)) {
                    object = hashSet2.iterator();
                    while (object.hasNext()) {
                        ((TopComponent)object.next()).close();
                    }
                } else if (!hashSet.isEmpty()) {
                    hashMap = null;
                }
                return hashMap;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$project$ui$ProjectUtilities == null ? (class$org$netbeans$modules$project$ui$ProjectUtilities = ProjectUtilities.class$("org.netbeans.modules.project.ui.ProjectUtilities")) : class$org$netbeans$modules$project$ui$ProjectUtilities).desiredAssertionStatus();
            }
        };
        ERR = ErrorManager.getDefault().getInstance(ProjectUtilities.class.getName());
    }

    static interface OpenCloseProjectDocument {
        public boolean open(FileObject var1);

        public Map close(Project[] var1);
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean bl) {
            this.show = bl;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor waitCursor) {
            if (SwingUtilities.isEventDispatchThread()) {
                waitCursor.run();
            } else {
                SwingUtilities.invokeLater(waitCursor);
            }
        }

        public void run() {
            try {
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                Component component = jFrame.getGlassPane();
                component.setVisible(this.show);
                component.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            }
        }
    }
}

