/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.PhysicalView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class ProjectsRootNode
extends AbstractNode {
    static final int PHYSICAL_VIEW = 0;
    static final int LOGICAL_VIEW = 1;
    private static final String ICON_BASE = "org/netbeans/modules/project/ui/resources/projectsRootNode";
    private static final String ACTIONS_FOLDER = "ProjectsTabActions";
    private ResourceBundle bundle;
    private final int type;
    static /* synthetic */ Class class$org$netbeans$api$project$Project;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$ui$LogicalViewProvider;
    static /* synthetic */ Class class$org$netbeans$modules$project$ui$PhysicalView$PathFinder;

    public ProjectsRootNode(int n) {
        super((Children)new ProjectChildren(n));
        this.setIconBase(ICON_BASE);
        this.type = n;
    }

    public String getName() {
        return "OpenProjects";
    }

    public String getDisplayName() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)ProjectsRootNode.class);
        }
        return this.bundle.getString("LBL_OpenProjectsNode_Name");
    }

    public boolean canRename() {
        return false;
    }

    public Node.Handle getHandle() {
        return new Handle(this.type);
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.type == 0) {
            return new Action[0];
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        DataFolder dataFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(ACTIONS_FOLDER));
        Iterator iterator = new FolderLookup((DataObject.Container)dataFolder).getLookup().lookup(new Lookup.Template(Object.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Action) {
                arrayList.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            arrayList.add(null);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    Node findNode(FileObject fileObject) {
        ProjectChildren projectChildren = (ProjectChildren)this.getChildren();
        if (projectChildren.type == 1) {
            int n;
            Node[] nodeArray = projectChildren.getNodes(true);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            int n2 = n = project != null ? 0 : 1;
            while (n < 2) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node;
                    Project project2 = (Project)nodeArray[i].getLookup().lookup(class$org$netbeans$api$project$Project == null ? ProjectsRootNode.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
                    if (!$assertionsDisabled && project2 == null) {
                        throw new AssertionError((Object)("Should have had a Project in lookup of " + nodeArray[i]));
                    }
                    if (n == 0 && project2 != project) continue;
                    LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project2.getLookup().lookup(class$org$netbeans$spi$project$ui$LogicalViewProvider == null ? ProjectsRootNode.class$("org.netbeans.spi.project.ui.LogicalViewProvider") : class$org$netbeans$spi$project$ui$LogicalViewProvider);
                    if (logicalViewProvider == null || (node = logicalViewProvider.findPath(nodeArray[i], (Object)fileObject)) == null) continue;
                    return node;
                }
                ++n;
            }
            return null;
        }
        if (projectChildren.type == 0) {
            Node[] nodeArray = projectChildren.getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node;
                PhysicalView.PathFinder pathFinder = (PhysicalView.PathFinder)nodeArray[i].getLookup().lookup(class$org$netbeans$modules$project$ui$PhysicalView$PathFinder == null ? ProjectsRootNode.class$("org.netbeans.modules.project.ui.PhysicalView$PathFinder") : class$org$netbeans$modules$project$ui$PhysicalView$PathFinder);
                if (pathFinder == null || (node = pathFinder.findPath(nodeArray[i], fileObject)) == null) continue;
                return node;
            }
            return null;
        }
        return null;
    }

    static SearchInfo alwaysSearchableSearchInfo(SearchInfo searchInfo) {
        return new AlwaysSearchableSearchInfo(searchInfo);
    }

    static {
        $assertionsDisabled = !ProjectsRootNode.class.desiredAssertionStatus();
    }

    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(SearchInfo searchInfo) {
            this.delegate = searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    private static final class BadgingNode
    extends FilterNode
    implements PropertyChangeListener {
        private static String badgedNamePattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectsRootNode == null ? (class$org$netbeans$modules$project$ui$ProjectsRootNode = ProjectsRootNode.class$("org.netbeans.modules.project.ui.ProjectsRootNode")) : class$org$netbeans$modules$project$ui$ProjectsRootNode), (String)"LBL_MainProject_BadgedNamePattern");

        public BadgingNode(Node node, boolean bl) {
            super(node, null, (Lookup)(bl ? new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfoBySubnodes((Node)node)))}) : node.getLookup()));
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        }

        public String getDisplayName() {
            String string = super.getDisplayName();
            return this.isMain() ? MessageFormat.format(badgedNamePattern, string) : string;
        }

        public String getHtmlDisplayName() {
            String string = this.getOriginal().getHtmlDisplayName();
            String string2 = null;
            if (this.isMain() && string == null) {
                string2 = super.getDisplayName();
                try {
                    string2 = XMLUtil.toElementContent((String)string2);
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return this.isMain() ? "<b>" + (string == null ? string2 : string) + "</b>" : string;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireDisplayNameChange(null, null);
            }
        }

        private boolean isMain() {
            Project project = (Project)this.getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectsRootNode.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project);
            return project != null && OpenProjectList.getDefault().isMainProject(project);
        }
    }

    static class ProjectChildren
    extends Children.Keys
    implements ChangeListener,
    PropertyChangeListener {
        private Map sources2projects = new WeakHashMap();
        int type;

        public ProjectChildren(int n) {
            this.type = n;
            OpenProjectList.getDefault().addPropertyChangeListener(this);
        }

        public void addNotify() {
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            Iterator iterator = this.sources2projects.keySet().iterator();
            while (iterator.hasNext()) {
                Sources sources = (Sources)iterator.next();
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            Project project = (Project)object;
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(class$org$netbeans$spi$project$ui$LogicalViewProvider == null ? (class$org$netbeans$spi$project$ui$LogicalViewProvider = ProjectsRootNode.class$("org.netbeans.spi.project.ui.LogicalViewProvider")) : class$org$netbeans$spi$project$ui$LogicalViewProvider);
            Node[] nodeArray2 = null;
            if (this.type == 0) {
                nodeArray = ProjectUtils.getSources((Project)project);
                nodeArray.removeChangeListener((ChangeListener)this);
                nodeArray.addChangeListener((ChangeListener)this);
                this.sources2projects.put(nodeArray, new WeakReference<Project>(project));
                nodeArray2 = PhysicalView.createNodesForProject(project);
            } else if (logicalViewProvider == null) {
                ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply a LogicalViewProvider in its lookup");
                nodeArray = ProjectUtils.getSources((Project)project);
                nodeArray.removeChangeListener((ChangeListener)this);
                nodeArray.addChangeListener((ChangeListener)this);
                nodeArray2 = PhysicalView.createNodesForProject(project);
                nodeArray2 = nodeArray2.length > 0 ? new Node[]{nodeArray2[0]} : new Node[]{Node.EMPTY};
            } else {
                nodeArray2 = new Node[]{logicalViewProvider.createLogicalView()};
                if (nodeArray2[0].getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectsRootNode.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project) != project) {
                    ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                }
            }
            nodeArray = new Node[nodeArray2.length];
            for (int i = 0; i < nodeArray2.length; ++i) {
                nodeArray[i] = this.type == 0 && !PhysicalView.isProjectDirNode(nodeArray2[i]) ? nodeArray2[i] : new BadgingNode(nodeArray2[i], this.type == 1);
            }
            return nodeArray;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("OpenProjects".equals(propertyChangeEvent.getPropertyName())) {
                this.setKeys(this.getKeys());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WeakReference weakReference = (WeakReference)this.sources2projects.get(changeEvent.getSource());
            if (weakReference == null) {
                return;
            }
            Project project = (Project)weakReference.get();
            if (project == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(this, project){
                private final /* synthetic */ Project val$project;
                private final /* synthetic */ ProjectChildren this$0;
                {
                    this.this$0 = projectChildren;
                    this.val$project = project;
                }

                public void run() {
                    ProjectChildren.access$000(this.this$0, this.val$project);
                }
            });
        }

        public Collection getKeys() {
            List<Project> list = Arrays.asList(OpenProjectList.getDefault().getOpenProjects());
            Collections.sort(list, OpenProjectList.PROJECT_BY_DISPLAYNAME);
            return list;
        }

        static /* synthetic */ void access$000(ProjectChildren projectChildren, Object object) {
            projectChildren.refreshKey(object);
        }
    }

    private static class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;
        private int viewType;

        public Handle(int n) {
            this.viewType = n;
        }

        public Node getNode() {
            return new ProjectsRootNode(this.viewType);
        }
    }
}

