/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class TemplateChooserPanelGUI
extends JPanel
implements PropertyChangeListener,
AsyncGUIJob {
    private static final Dimension PREF_DIM;
    private final List listeners = new ArrayList();
    private FileObject templatesFolder;
    private TemplatesPanelGUI.Builder builder = new FileChooserBuilder();
    private Project project;
    private String category;
    private String template;
    private boolean isWarmUp = true;
    private ListCellRenderer projectCellRenderer;
    private JLabel jLabel1;
    private JComboBox projectsComboBox;
    private JPanel templatesPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TemplateChooserPanelGUI() {
        this.initComponents();
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getMessage((Class)TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_Name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues(Project project, String string, String string2) {
        boolean bl;
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError((Object)"Project can not be null");
        }
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            this.project = project;
            this.category = string;
            this.template = string2;
            bl = this.isWarmUp;
        }
        if (!bl) {
            this.selectProject(this.project);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(this.category);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedTemplateByName(this.template);
        }
    }

    private void initValues(Project project) {
        Project[] projectArray = OpenProjectList.getDefault().getOpenProjects();
        Arrays.sort(projectArray, OpenProjectList.PROJECT_BY_DISPLAYNAME);
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(projectArray);
        this.projectsComboBox.setModel(defaultComboBoxModel);
        this.selectProject(project);
    }

    private void selectProject(Project project) {
        if (project != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.projectsComboBox.getModel();
            if (defaultComboBoxModel.getIndexOf(project) == -1) {
                defaultComboBoxModel.insertElementAt(project, 0);
            }
            this.projectsComboBox.setSelectedItem(project);
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject() {
        boolean bl;
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            bl = this.isWarmUp;
        }
        if (bl) {
            return this.project;
        }
        return (Project)this.projectsComboBox.getSelectedItem();
    }

    public FileObject getTemplate() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireChange();
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public String getCategoryName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedCategoryName();
    }

    public String getTemplateName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplateName();
    }

    public void setCategory(String string) {
        ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(string);
    }

    public void addNotify() {
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
        super.addNotify();
        if (this.projectCellRenderer == null) {
            this.projectCellRenderer = new ProjectCellRenderer();
        }
        this.projectsComboBox.setRenderer(this.projectCellRenderer);
    }

    public void removeNotify() {
        super.removeNotify();
        this.projectCellRenderer = null;
        this.projectsComboBox.setRenderer(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.templatesPanel = new TemplatesPanelGUI(this.builder);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)TemplateChooserPanelGUI.class, (String)"MNE_TemplateChooserPanelGUI_jLabel1").charAt(0));
        this.jLabel1.setLabelFor(this.projectsComboBox);
        this.jLabel1.setText(NbBundle.getMessage((Class)TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)TemplateChooserPanelGUI.class, (String)"ACSN_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TemplateChooserPanelGUI.class, (String)"ACSD_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.templatesPanel, gridBagConstraints);
    }

    private static boolean isTemplate(DataObject dataObject) {
        if (dataObject.isTemplate()) {
            return true;
        }
        if (dataObject instanceof DataShadow) {
            return ((DataShadow)dataObject).getOriginal().isTemplate();
        }
        return false;
    }

    private boolean hasChildren(Project project, DataObject dataObject) {
        if (!(dataObject instanceof DataFolder)) {
            return false;
        }
        DataFolder dataFolder = (DataFolder)dataObject;
        DataObject[] dataObjectArray = dataFolder.getChildren();
        boolean bl = false;
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (TemplateChooserPanelGUI.isTemplate(dataObjectArray[i]) && OpenProjectList.isRecommended(project, dataObjectArray[i].getPrimaryFile())) {
                if (dataObjectArray[i] instanceof DataShadow) continue;
                bl = true;
                break;
            }
            if (!(dataObjectArray[i] instanceof DataFolder) || !this.hasChildren(project, dataObjectArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void construct() {
        this.templatesFolder = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        ((TemplatesPanelGUI)this.templatesPanel).warmUp(this.templatesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        TemplateChooserPanelGUI templateChooserPanelGUI;
        Cursor cursor = null;
        try {
            String string;
            String string2;
            Project project;
            TemplateChooserPanelGUI templateChooserPanelGUI2 = this;
            synchronized (templateChooserPanelGUI2) {
                project = this.project;
                string2 = this.category;
                string = this.template;
            }
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.initValues(project);
            ((TemplatesPanelGUI)this.templatesPanel).doFinished(this.templatesFolder, string2, string);
            Object var8_7 = null;
            templateChooserPanelGUI = this;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            TemplateChooserPanelGUI templateChooserPanelGUI3 = this;
            synchronized (templateChooserPanelGUI3) {
                this.isWarmUp = false;
            }
            if (cursor != null) {
                this.setCursor(cursor);
            }
            throw throwable;
        }
        synchronized (templateChooserPanelGUI) {
            this.isWarmUp = false;
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    static {
        $assertionsDisabled = !TemplateChooserPanelGUI.class.desiredAssertionStatus();
        PREF_DIM = new Dimension(500, 340);
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private final class FileChooserBuilder
    implements TemplatesPanelGUI.Builder {
        private FileChooserBuilder() {
        }

        public Children createCategoriesChildren(DataFolder dataFolder) {
            return new TemplateChildren(dataFolder);
        }

        public Children createTemplatesChildren(DataFolder dataFolder) {
            return new FileChildren(dataFolder);
        }

        public void fireChange() {
            TemplateChooserPanelGUI.this.fireChange();
        }

        public char getCategoriesMnemonic() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI == null ? (class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI = TemplateChooserPanelGUI.class$("org.netbeans.modules.project.ui.TemplateChooserPanelGUI")) : class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI), (String)"MNE_Categories").charAt(0);
        }

        public String getCategoriesName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI == null ? (class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI = TemplateChooserPanelGUI.class$("org.netbeans.modules.project.ui.TemplateChooserPanelGUI")) : class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI), (String)"CTL_Categories");
        }

        public char getTemplatesMnemonic() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI == null ? (class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI = TemplateChooserPanelGUI.class$("org.netbeans.modules.project.ui.TemplateChooserPanelGUI")) : class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI), (String)"MNE_Files").charAt(0);
        }

        public String getTemplatesName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI == null ? (class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI = TemplateChooserPanelGUI.class$("org.netbeans.modules.project.ui.TemplateChooserPanelGUI")) : class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI), (String)"CTL_Files");
        }
    }

    private final class FileChildren
    extends Children.Keys {
        private DataFolder root;
        static final /* synthetic */ boolean $assertionsDisabled;

        public FileChildren(DataFolder dataFolder) {
            this.root = dataFolder;
            if (!$assertionsDisabled && this.root == null) {
                throw new AssertionError((Object)"Root can not be null");
            }
        }

        protected void addNotify() {
            this.setKeys(this.root.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            DataObject dataObject;
            if (object instanceof DataObject && TemplateChooserPanelGUI.isTemplate(dataObject = (DataObject)object) && OpenProjectList.isRecommended(TemplateChooserPanelGUI.this.getProject(), dataObject.getPrimaryFile())) {
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                return new Node[]{new FilterNode(dataObject.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[0];
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI == null ? (class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI = TemplateChooserPanelGUI.class$("org.netbeans.modules.project.ui.TemplateChooserPanelGUI")) : class$org$netbeans$modules$project$ui$TemplateChooserPanelGUI).desiredAssertionStatus();
        }
    }

    private final class TemplateChildren
    extends Children.Keys
    implements ActionListener {
        private final DataFolder folder;

        TemplateChildren(DataFolder dataFolder) {
            this.folder = dataFolder;
        }

        protected void addNotify() {
            super.addNotify();
            TemplateChooserPanelGUI.this.projectsComboBox.addActionListener(this);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            TemplateChooserPanelGUI.this.projectsComboBox.removeActionListener(this);
            super.removeNotify();
        }

        private void updateKeys() {
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
            DataObject[] dataObjectArray = this.folder.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                DataObject dataObject = dataObjectArray[i];
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.acceptTemplate(dataObject, fileObject) || !TemplateChooserPanelGUI.this.hasChildren((Project)TemplateChooserPanelGUI.this.projectsComboBox.getSelectedItem(), dataObject)) continue;
                arrayList.add(dataObject);
            }
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(Object object) {
            DataFolder dataFolder = (DataFolder)object;
            DataObject[] dataObjectArray = dataFolder.getChildren();
            boolean bl = false;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!(dataObjectArray[i] instanceof DataFolder) || TemplateChooserPanelGUI.isTemplate(dataObjectArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return new Node[]{new FilterNode(dataFolder.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[]{new FilterNode(dataFolder.getNodeDelegate(), (Children)new TemplateChildren(dataFolder))};
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = TemplateChooserPanelGUI.this.getCategoryName();
            String string2 = ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).getSelectedTemplateName();
            this.setKeys(Collections.EMPTY_SET);
            this.updateKeys();
            TemplateChooserPanelGUI.this.setCategory(string);
            ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).setSelectedTemplateByName(string2);
        }

        private boolean acceptTemplate(DataObject dataObject, FileObject fileObject) {
            if (dataObject instanceof DataFolder && !TemplateChooserPanelGUI.isTemplate((DataObject)((DataFolder)dataObject))) {
                Object object = fileObject.getAttribute("simple");
                return object == null || Boolean.TRUE.equals(object);
            }
            return false;
        }
    }
}

