/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

class ActionsUtil {
    public static LookupResultsCache lookupResultsCache;
    public static final ShortcutsManager SHORCUTS_MANAGER;
    public static HashMap pattern2format;

    ActionsUtil() {
    }

    public static Project[] getProjectsFromLookup(Lookup lookup, String string) {
        if (lookupResultsCache == null) {
            lookupResultsCache = new LookupResultsCache(new Class[]{Project.class, DataObject.class});
        }
        Project[] projectArray = lookupResultsCache.getProjects(lookup);
        if (string != null) {
            for (int i = 0; i < projectArray.length; ++i) {
                if (ActionsUtil.commandSupported(projectArray[i], string, lookup)) continue;
                return new Project[0];
            }
        }
        return projectArray;
    }

    public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Collection collection = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
        FileObject[] fileObjectArray = collection.iterator();
        while (fileObjectArray.hasNext()) {
            DataObject dataObject = (DataObject)fileObjectArray.next();
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project2 == null || !project2.equals(project)) continue;
            hashSet.add(fileObject);
        }
        fileObjectArray = new FileObject[hashSet.size()];
        hashSet.toArray(fileObjectArray);
        return fileObjectArray;
    }

    public static boolean commandSupported(Project project, String string, Lookup lookup) {
        List<String> list;
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        return actionProvider != null && (list = Arrays.asList(actionProvider.getSupportedActions())).contains(string) && (lookup == null || actionProvider.isActionEnabled(string, lookup));
    }

    public static String formatProjectSensitiveName(String string, Project[] projectArray) {
        if (projectArray == null || projectArray.length == 0) {
            return ActionsUtil.formatName(string, 0, null);
        }
        return ActionsUtil.formatName(string, projectArray.length, ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatName(String string, int n, String string2) {
        MessageFormat messageFormat = null;
        Serializable serializable = pattern2format;
        synchronized (serializable) {
            messageFormat = (MessageFormat)pattern2format.get(string);
            if (messageFormat == null) {
                messageFormat = new MessageFormat(string);
                pattern2format.put(string, messageFormat);
            }
        }
        serializable = new StringBuffer();
        messageFormat.format(new Object[]{new Integer(n), string2 == null ? "" : string2}, (StringBuffer)serializable, (FieldPosition)null);
        return ((StringBuffer)serializable).toString();
    }

    static {
        SHORCUTS_MANAGER = new ShortcutsManager();
        pattern2format = new HashMap();
    }

    private static class LookupResultsCache
    implements LookupListener {
        private Class[] watch;
        private Reference lruLookup;
        private List lruResults;
        private Project[] projects;

        LookupResultsCache(Class[] classArray) {
            this.watch = classArray;
        }

        public synchronized Project[] getProjects(Lookup lookup) {
            Object object;
            Object object2;
            Lookup lookup2;
            Lookup lookup3 = lookup2 = this.lruLookup != null ? (Lookup)this.lruLookup.get() : null;
            if (lookup != lookup2) {
                if (this.lruResults != null) {
                    object2 = this.lruResults.iterator();
                    while (object2.hasNext()) {
                        object = (Lookup.Result)((Reference)object2.next()).get();
                        if (object == null) continue;
                        object.removeLookupListener((LookupListener)this);
                    }
                    this.lruResults = null;
                }
                this.makeDirty();
                lookup2 = null;
            }
            if (lookup2 == null) {
                lookup2 = lookup;
                this.lruLookup = new CleanableWeakReference(lookup2);
                this.lruResults = new ArrayList();
                for (int i = 0; i < this.watch.length; ++i) {
                    object = lookup.lookup(new Lookup.Template(this.watch[i]));
                    object.allItems();
                    object.addLookupListener((LookupListener)this);
                    this.lruResults.add(new CleanableWeakReference(object));
                }
            }
            if (this.isDirty()) {
                Object object3;
                object2 = new HashSet();
                object = lookup2.lookup(new Lookup.Template(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ActionsUtil.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project)).allInstances();
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    object3 = (Project)object4.next();
                    object2.add(object3);
                }
                object4 = lookup2.lookup(new Lookup.Template(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ActionsUtil.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)).allInstances();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    DataObject dataObject = (DataObject)object3.next();
                    FileObject fileObject = dataObject.getPrimaryFile();
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    if (project == null) continue;
                    object2.add(project);
                }
                this.projects = new Project[object2.size()];
                object2.toArray(this.projects);
            }
            return this.projects;
        }

        private boolean isDirty() {
            return this.projects == null;
        }

        private synchronized void makeDirty() {
            this.projects = null;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.makeDirty();
        }

        static /* synthetic */ Project[] access$202(LookupResultsCache lookupResultsCache, Project[] projectArray) {
            lookupResultsCache.projects = projectArray;
            return projectArray;
        }

        private class CleanableWeakReference
        extends WeakReference
        implements Runnable {
            public CleanableWeakReference(Object object) {
                super(object, Utilities.activeReferenceQueue());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LookupResultsCache lookupResultsCache = LookupResultsCache.this;
                synchronized (lookupResultsCache) {
                    LookupResultsCache.this.lruLookup = null;
                    LookupResultsCache.this.lruResults = null;
                    LookupResultsCache.access$202(LookupResultsCache.this, null);
                }
            }
        }
    }

    public static class ShortcutsManager {
        HashMap shorcuts = new HashMap();
        HashMap actions = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAction(String string, Action action) {
            Object object = this;
            synchronized (object) {
                Set set = (Set)this.actions.get(string);
                if (set == null) {
                    set = new WeakSet();
                    this.actions.put(string, set);
                }
                set.add(action);
            }
            object = this.getShortcut(string);
            if (object != null) {
                action.putValue("AcceleratorKey", object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerShortcut(String string, Object object) {
            Object object2;
            HashSet hashSet = null;
            Object object3 = this;
            synchronized (object3) {
                object2 = this.getShortcut(string);
                if (object2 != null && object2.equals(object) || object2 == null && object == null) {
                    return;
                }
                this.shorcuts.put(string, object);
                Set set = (Set)this.actions.get(string);
                if (set != null && !set.isEmpty()) {
                    hashSet = new HashSet();
                    hashSet.addAll(set);
                }
            }
            if (hashSet != null) {
                object3 = hashSet.iterator();
                while (object3.hasNext()) {
                    object2 = (Action)object3.next();
                    if (object2 == null) continue;
                    object2.putValue("AcceleratorKey", object);
                }
            }
        }

        public synchronized Object getShortcut(String string) {
            return this.shorcuts.get(string);
        }
    }
}

