/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NewFileWizard;
import org.netbeans.modules.project.ui.NoProjectNew;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class NewFile
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup,
PopupMenuListener {
    private static final Icon ICON;
    private static final String NAME;
    private static final String POPUP_NAME;
    private static final String FILE_POPUP_NAME;
    private static final String TEMPLATE_NAME_FORMAT;
    private JMenu subMenu;
    public static String TEMPLATE_PROPERTY;
    public static String IN_PROJECT_PROPERTY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NewFile() {
        this((Lookup)null);
    }

    public NewFile(Lookup lookup) {
        super((String)null, NAME, ICON, lookup);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newFile.gif");
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.refresh(this.getLookup());
    }

    protected void refresh(Lookup lookup) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                NewFile.this.setEnabled(OpenProjectList.getDefault().getOpenProjects().length > 0);
                NewFile.this.setDisplayName(NAME);
            }
        });
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = new JMenuItem(this);
        jMenuItem.setIcon(null);
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)((String)this.getValue("Name")));
        return jMenuItem;
    }

    protected void actionPerformed(Lookup lookup) {
        this.doPerform(lookup, null, true);
    }

    private void doPerform(Lookup lookup, DataObject dataObject, boolean bl) {
        Object object;
        Set set;
        if (lookup == null) {
            lookup = this.getLookup();
        }
        if (!bl) {
            NoProjectNew.showDialog(dataObject, this.preselectedFolder(lookup));
            return;
        }
        NewFileWizard newFileWizard = new NewFileWizard(this.preselectedProject(lookup));
        DataFolder dataFolder = this.preselectedFolder(lookup);
        if (dataFolder != null) {
            newFileWizard.setTargetFolder(dataFolder);
        }
        try {
            Set set2 = set = dataObject == null ? newFileWizard.instantiate() : newFileWizard.instantiate(dataObject);
            if (set == null || set.isEmpty()) {
                return;
            }
            object = set.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                DataObject dataObject2 = null;
                if (e instanceof DataObject) {
                    dataObject2 = (DataObject)e;
                } else if (e instanceof FileObject) {
                    try {
                        dataObject2 = DataObject.find((FileObject)((FileObject)e));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(e);
                        }
                    }
                } else if (!$assertionsDisabled) {
                    throw new AssertionError(e);
                }
                if (dataObject2 == null) continue;
                ProjectUtilities.openAndSelectNewObject(dataObject2);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        set = Templates.getProject((WizardDescriptor)newFileWizard);
        object = Templates.getTemplate((WizardDescriptor)newFileWizard);
        OpenProjectList.getDefault().updateTemplatesLRU((FileObject)object);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new NewFile(lookup);
    }

    public JMenuItem getSubmenuPopupPresenter() {
        if (this.subMenu == null) {
            this.subMenu = new JMenu(POPUP_NAME);
            this.subMenu.getPopupMenu().addPopupMenuListener(this);
        }
        return this.subMenu;
    }

    private void fillSubMenu() {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(this.getLookup(), null);
        if (projectArray != null && projectArray.length > 0) {
            this.fillSubMenu(this.subMenu, projectArray[0]);
        } else {
            this.fillNonProjectSubMenu(this.subMenu);
        }
    }

    private Project preselectedProject(Lookup lookup) {
        Project project = null;
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length > 0) {
            project = projectArray[0];
        }
        if (project == null && (project = OpenProjectList.getDefault().getMainProject()) == null) {
            project = OpenProjectList.getDefault().getOpenProjects()[0];
        }
        if (project == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"Action should be disabled");
        }
        return project;
    }

    private DataFolder preselectedFolder(Lookup lookup) {
        DataObject dataObject;
        DataFolder dataFolder = null;
        dataFolder = (DataFolder)lookup.lookup(DataFolder.class);
        if (dataFolder == null && (dataObject = (DataObject)lookup.lookup(DataObject.class)) != null) {
            dataFolder = dataObject.getFolder();
        }
        return dataFolder;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh(Lookup.EMPTY);
    }

    private void fillSubMenu(JMenu jMenu, Project project) {
        jMenu.removeAll();
        PopupListener popupListener = new PopupListener();
        JMenuItem jMenuItem = new JMenuItem(FILE_POPUP_NAME, (Icon)this.getValue("SmallIcon"));
        jMenuItem.addActionListener(popupListener);
        jMenuItem.putClientProperty(TEMPLATE_PROPERTY, null);
        jMenu.add(jMenuItem);
        List list = OpenProjectList.getDefault().getTemplatesLRU(project);
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            Node node = dataObject.getNodeDelegate();
            JMenuItem jMenuItem2 = new JMenuItem(MessageFormat.format(TEMPLATE_NAME_FORMAT, node.getDisplayName()), new ImageIcon(node.getIcon(1)));
            jMenuItem2.addActionListener(popupListener);
            jMenuItem2.putClientProperty(TEMPLATE_PROPERTY, dataObject);
            if (bl) {
                jMenu.add(new JPopupMenu.Separator());
                bl = false;
            }
            jMenu.add(jMenuItem2);
        }
    }

    private void fillNonProjectSubMenu(JMenu jMenu) {
        DataObject[] dataObjectArray;
        jMenu.removeAll();
        PopupListener popupListener = new PopupListener();
        DataFolder dataFolder = this.preselectedFolder(this.getLookup());
        boolean bl = dataFolder == null ? false : (dataObjectArray = dataFolder.getPrimaryFile()) != null && dataObjectArray.canWrite();
        dataObjectArray = NoProjectNew.getTemplates();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            Node node = dataObjectArray[i].getNodeDelegate();
            JMenuItem jMenuItem = new JMenuItem(MessageFormat.format(TEMPLATE_NAME_FORMAT, node.getDisplayName()), new ImageIcon(node.getIcon(1)));
            jMenuItem.addActionListener(popupListener);
            jMenuItem.putClientProperty(TEMPLATE_PROPERTY, dataObjectArray[i]);
            jMenuItem.putClientProperty(IN_PROJECT_PROPERTY, Boolean.FALSE);
            jMenuItem.setEnabled(bl);
            jMenu.add(jMenuItem);
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.fillSubMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    static {
        $assertionsDisabled = !NewFile.class.desiredAssertionStatus();
        ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/newFile.gif"));
        NAME = NbBundle.getMessage((Class)NewFile.class, (String)"LBL_NewFileAction_Name");
        POPUP_NAME = NbBundle.getMessage((Class)NewFile.class, (String)"LBL_NewFileAction_PopupName");
        FILE_POPUP_NAME = NbBundle.getMessage((Class)NewFile.class, (String)"LBL_NewFileAction_File_PopupName");
        TEMPLATE_NAME_FORMAT = NbBundle.getMessage((Class)NewFile.class, (String)"LBL_NewFileAction_Template_PopupName");
        TEMPLATE_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.Template";
        IN_PROJECT_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.InProject";
    }

    public static final class WithSubMenu
    extends NewFile {
        public WithSubMenu() {
        }

        private WithSubMenu(Lookup lookup) {
            super(lookup);
        }

        public JMenuItem getPopupPresenter() {
            return this.getSubmenuPopupPresenter();
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new WithSubMenu(lookup);
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Boolean bl = (Boolean)jMenuItem.getClientProperty(IN_PROJECT_PROPERTY);
            DataObject dataObject = (DataObject)jMenuItem.getClientProperty(TEMPLATE_PROPERTY);
            if (bl != null && bl == Boolean.FALSE) {
                NewFile.this.doPerform(null, dataObject, false);
            } else {
                NewFile.this.doPerform(null, dataObject, true);
            }
        }
    }
}

