/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NewProject
extends BasicAction {
    private static final Icon ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/newProject.gif"));
    private static final String NAME = NbBundle.getMessage((Class)NewProject.class, (String)"LBL_NewProjectAction_Name");
    private boolean isPreselect = false;
    private RequestProcessor.Task bodyTask;

    public NewProject() {
        super(NAME, ICON);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newProject.gif");
        this.bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

            public void run() {
                NewProject.this.doPerform();
            }
        });
    }

    public static NewProject newSample() {
        NewProject newProject = new NewProject();
        newProject.setDisplayName("New Sample");
        newProject.isPreselect = true;
        return newProject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.bodyTask.schedule(0);
        if ("waitFinished".equals(actionEvent.getActionCommand())) {
            this.bodyTask.waitFinished();
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fileObject) {
        NewProjectWizard newProjectWizard = new NewProjectWizard(fileObject);
        if (this.isPreselect) {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", this.getValue("PRESELECT_CATEGORY"));
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", this.getValue("PRESELECT_TEMPLATE"));
        } else {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", null);
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", null);
        }
        FileObject fileObject2 = (FileObject)this.getValue("existingSourcesFolder");
        if (fileObject2 != null) {
            newProjectWizard.putProperty("existingSourcesFolder", fileObject2);
        }
        return newProjectWizard;
    }

    private void doPerform() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Project");
        NewProjectWizard newProjectWizard = this.prepareWizardDescriptor(fileObject);
        try {
            final Set set = newProjectWizard.instantiate();
            Object object = newProjectWizard.getProperty("setAsMain");
            boolean bl = true;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            final boolean bl2 = bl;
            ProjectManager.getDefault().clearNonProjectCache();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectUtilities.WaitCursor.show();
                    if (set != null && !set.isEmpty()) {
                        Object object;
                        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
                        LinkedList<Project> linkedList2 = new LinkedList<Project>();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            FileObject fileObject;
                            DataObject dataObject;
                            block15: {
                                object = iterator.next();
                                if (object instanceof DataObject) {
                                    dataObject = (DataObject)object;
                                    fileObject = dataObject.getPrimaryFile();
                                } else {
                                    if (object instanceof FileObject) {
                                        fileObject = (FileObject)object;
                                        try {
                                            dataObject = DataObject.find((FileObject)fileObject);
                                            break block15;
                                        }
                                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                                            continue;
                                        }
                                    }
                                    ErrorManager.getDefault().log(16, "Found unrecognized object " + object + " in result set from instantiate()");
                                    continue;
                                }
                            }
                            if (fileObject.isFolder()) {
                                try {
                                    Project project = ProjectManager.getDefault().findProject(fileObject);
                                    if (project != null) {
                                        linkedList2.add(project);
                                        continue;
                                    }
                                    linkedList.add(dataObject);
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                                }
                                continue;
                            }
                            linkedList.add(dataObject);
                        }
                        iterator = linkedList2.size() > 0 ? (Project)linkedList2.get(0) : null;
                        OpenProjectList.getDefault().open(linkedList2.toArray(new Project[0]), false, true);
                        if (bl2 && iterator != null) {
                            OpenProjectList.getDefault().setMainProject((Project)iterator);
                        }
                        ProjectUtilities.makeProjectTabVisible(true);
                        if (linkedList.isEmpty() && iterator != null) {
                            ProjectUtilities.selectAndExpandProject(iterator);
                        } else {
                            object = linkedList.iterator();
                            while (object.hasNext()) {
                                ProjectUtilities.openAndSelectNewObject((DataObject)object.next());
                            }
                        }
                    }
                    ProjectUtilities.WaitCursor.hide();
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }
}

