/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.xml.parsers.DocumentInputSource;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.netbeans.modules.xml.text.completion.EmptyQuery;
import org.netbeans.modules.xml.text.completion.Util;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class GrammarManager
implements DocumentListener {
    private int state = 3;
    static final int VALID = 1;
    static final int INVALID = 3;
    private GrammarQuery grammar;
    private final XMLSyntaxSupport syntax;
    private final Document doc;
    private Position[] guarded;
    private Position maxGuarded;
    private int environmentElementsCount = -1;

    public GrammarManager(Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        this.doc = document;
        this.syntax = xMLSyntaxSupport;
    }

    public synchronized GrammarQuery getGrammar() {
        switch (this.state) {
            case 1: {
                return this.grammar;
            }
            case 3: {
                this.loadGrammar();
                return this.grammar;
            }
        }
        throw new IllegalStateException();
    }

    public synchronized void invalidateGrammar() {
        if (this.state == 1) {
            String string = Util.THIS.getString("MSG_loading_cancel");
            StatusDisplayer.getDefault().setStatusText(string);
        }
        this.doc.removeDocumentListener(this);
        this.guarded = new Position[0];
        this.state = 3;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkDocumentEnvironment(documentEvent);
        if (this.isGuarded(documentEvent.getOffset(), documentEvent.getLength())) {
            this.invalidateGrammar();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkDocumentEnvironment(documentEvent);
        if (this.isGuarded(documentEvent.getOffset(), documentEvent.getLength())) {
            this.invalidateGrammar();
        }
    }

    private void checkDocumentEnvironment(DocumentEvent documentEvent) {
        long l = System.currentTimeMillis();
        try {
            LinkedList linkedList = this.getEnvironmentElements();
            if (linkedList.size() != this.environmentElementsCount) {
                this.invalidateGrammar();
                this.environmentElementsCount = linkedList.size();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private boolean isGuarded(int n, int n2) {
        if (this.maxGuarded != null && n > this.maxGuarded.getOffset()) {
            return false;
        }
        for (int i = 0; i < this.guarded.length; i += 2) {
            int n3 = this.guarded[i].getOffset();
            int n4 = this.guarded[i + 1].getOffset();
            if (n3 < n && n < n4) {
                return true;
            }
            int n5 = n + n2;
            if (n >= n3 || n3 >= n5) continue;
            return true;
        }
        return false;
    }

    private synchronized void grammarLoaded(GrammarQuery grammarQuery) {
        String string = grammarQuery != null ? Util.THIS.getString("MSG_loading_done") : Util.THIS.getString("MSG_loading_failed");
        this.grammar = grammarQuery == null ? EmptyQuery.INSTANCE : grammarQuery;
        this.state = 1;
        StatusDisplayer.getDefault().setStatusText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGrammar() {
        GrammarQuery grammarQuery = null;
        try {
            Enumeration enumeration;
            GrammarQueryManager grammarQueryManager;
            DataObject dataObject;
            block10: {
                String string = Util.THIS.getString("MSG_loading");
                StatusDisplayer.getDefault().setStatusText(string);
                LinkedList linkedList = this.getEnvironmentElements();
                DocumentInputSource documentInputSource = new DocumentInputSource(this.doc);
                FileObject fileObject = null;
                Object object = this.doc.getProperty("stream");
                if (object instanceof DataObject) {
                    dataObject = (DataObject)object;
                    fileObject = dataObject.getPrimaryFile();
                }
                dataObject = new GrammarEnvironment(Collections.enumeration(linkedList), (InputSource)documentInputSource, fileObject);
                grammarQueryManager = GrammarQueryManager.getDefault();
                enumeration = grammarQueryManager.enabled((GrammarEnvironment)dataObject);
                if (enumeration != null) break block10;
                return;
            }
            try {
                ArrayList<Position> arrayList = new ArrayList<Position>(10);
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    if (!(node instanceof SyntaxNode)) continue;
                    SyntaxNode syntaxNode = (SyntaxNode)node;
                    int n2 = syntaxNode.getElementOffset();
                    int n3 = n2 + syntaxNode.getElementLength();
                    if (n3 > n) {
                        n = n3;
                    }
                    Position position = NbDocument.createPosition((Document)this.doc, (int)n2, (Position.Bias)Position.Bias.Forward);
                    arrayList.add(position);
                    Position position2 = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Backward);
                    arrayList.add(position2);
                }
                this.guarded = arrayList.toArray(new Position[arrayList.size()]);
                this.maxGuarded = NbDocument.createPosition((Document)this.doc, (int)n, (Position.Bias)Position.Bias.Backward);
                grammarQuery = grammarQueryManager.getGrammar((GrammarEnvironment)dataObject);
            }
            catch (BadLocationException badLocationException) {
                grammarQuery = null;
            }
        }
        finally {
            this.doc.addDocumentListener(this);
            this.grammarLoaded(grammarQuery);
        }
    }

    private LinkedList getEnvironmentElements() throws BadLocationException {
        LinkedList<SyntaxNode> linkedList = new LinkedList<SyntaxNode>();
        for (SyntaxElement syntaxElement = this.syntax.getElementChain(1); syntaxElement != null; syntaxElement = syntaxElement.getNext()) {
            if (!(syntaxElement instanceof SyntaxNode)) continue;
            SyntaxNode syntaxNode = (SyntaxNode)syntaxElement;
            linkedList.add(syntaxNode);
            if (1 == syntaxNode.getNodeType()) break;
        }
        return linkedList;
    }
}

