/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.folding;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.xml.text.folding.XmlFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class XmlFoldManager
implements FoldManager,
SettingsChangeListener,
DocumentModelListener {
    private FoldOperation operation;
    private Timer timer;
    private TimerTask timerTask;
    private int foldsUpdateInterval = 500;
    private long foldsGenerationTime = -1L;
    private DocumentModel model = null;
    private Vector changes = new Vector();
    private static final boolean debug = false;
    private static final boolean lightDebug = false;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$folding$XmlFoldManager;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public void release() {
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.model != null) {
            this.model.removeDocumentModelListener((DocumentModelListener)this);
            this.model = null;
        }
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (!(this.getDocument() instanceof BaseDocument)) {
            return;
        }
        if (this.getDocument().getLength() > 0) {
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private void initModelAndFolds() {
        try {
            this.model = DocumentModel.getDocumentModel((Document)((BaseDocument)this.getDocument()));
            this.model.addDocumentModelListener((DocumentModelListener)this);
            this.addElementsRecursivelly(this.changes, this.model.getRootElement());
        }
        catch (DocumentModelException documentModelException) {
            ErrorManager.getDefault().notify((Throwable)documentModelException);
        }
    }

    private void addElementsRecursivelly(Vector vector, DocumentElement documentElement) {
        try {
            if (!documentElement.equals((Object)this.model.getRootElement()) && !this.isOneLineElement(documentElement)) {
                vector.add(new DocumentModelChangeInfo(documentElement, 1));
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        Iterator iterator = documentElement.getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentElement documentElement2 = (DocumentElement)iterator.next();
            this.addElementsRecursivelly(vector, documentElement2);
        }
    }

    public void documentElementAdded(DocumentElement documentElement) {
        this.checkElement2FoldConsistency(documentElement);
    }

    public void documentElementRemoved(DocumentElement documentElement) {
        if (!documentElement.equals((Object)this.model.getRootElement()) && !documentElement.getType().equals("content")) {
            this.changes.add(new DocumentModelChangeInfo(documentElement, 2));
        }
        this.checkElement2FoldConsistency(documentElement);
        this.restartTimer();
    }

    public void documentElementChanged(DocumentElement documentElement) {
        this.checkElement2FoldConsistency(documentElement);
    }

    public void checkElement2FoldConsistency(DocumentElement documentElement) {
        boolean bl = false;
        for (DocumentElement documentElement2 = this.model.getLeafElementForOffset(documentElement.getStartOffset()); documentElement2 != null && !documentElement2.equals((Object)this.model.getRootElement()); documentElement2 = documentElement2.getParentElement()) {
            if (documentElement2.getType().equals("content")) continue;
            try {
                Fold fold = this.getFold(this.getOperation().getHierarchy(), documentElement2);
                boolean bl2 = this.isOneLineElement(documentElement2);
                if (fold != null && bl2) {
                    this.changes.add(new DocumentModelChangeInfo(documentElement2, 2));
                    bl = true;
                }
                if (fold == null && !bl2) {
                    this.changes.add(new DocumentModelChangeInfo(documentElement2, 1));
                    bl = true;
                }
                if (fold == null || bl2 || this.getFoldTypeForElement(documentElement2) == fold.getType() && fold.getDescription().equals("<" + documentElement2.getName() + ">")) continue;
                this.changes.add(new DocumentModelChangeInfo(documentElement2, 2));
                this.changes.add(new DocumentModelChangeInfo(documentElement2, 1));
                continue;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
        }
        if (bl) {
            this.restartTimer();
        }
    }

    private FoldType getFoldTypeForElement(DocumentElement documentElement) {
        if (documentElement.getType().equals("tag") || documentElement.getType().equals("tag")) {
            return XmlFoldTypes.TAG;
        }
        if (documentElement.getType().equals("pi")) {
            return XmlFoldTypes.PI;
        }
        if (documentElement.getType().equals("doctype")) {
            return XmlFoldTypes.DOCTYPE;
        }
        if (documentElement.getType().equals("comment")) {
            return XmlFoldTypes.COMMENT;
        }
        if (documentElement.getType().equals("cdata")) {
            return XmlFoldTypes.CDATA;
        }
        return null;
    }

    public void documentElementAttributesChanged(DocumentElement documentElement) {
    }

    private void restartTimer() {
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, this.foldsUpdateInterval);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                try {
                    if (XmlFoldManager.this.model == null) {
                        XmlFoldManager.this.initModelAndFolds();
                    }
                    XmlFoldManager.this.updateFolds();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds() {
        Document document = this.getDocument();
        if (!(document instanceof AbstractDocument)) {
            return;
        }
        ((AbstractDocument)document).readLock();
        try {
            FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
            foldHierarchy.lock();
            try {
                FoldHierarchyTransaction foldHierarchyTransaction = this.getOperation().openTransaction();
                try {
                    Iterator iterator = ((Vector)this.changes.clone()).iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        DocumentModelChangeInfo documentModelChangeInfo = (DocumentModelChangeInfo)iterator.next();
                        DocumentElement documentElement = documentModelChangeInfo.getDocumentElement();
                        if (documentModelChangeInfo.getChangeType() == 1 && documentElement.getStartOffset() < documentElement.getEndOffset() && !documentElement.getType().equals("content")) {
                            object = "";
                            FoldType foldType = XmlFoldTypes.TEXT;
                            if (documentElement.getType().equals("tag") || documentElement.getType().equals("empty_tag")) {
                                object = "<" + documentElement.getName() + ">";
                                foldType = XmlFoldTypes.TAG;
                            } else if (documentElement.getType().equals("pi")) {
                                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$folding$XmlFoldManager == null ? XmlFoldManager.class$("org.netbeans.modules.xml.text.folding.XmlFoldManager") : class$org$netbeans$modules$xml$text$folding$XmlFoldManager), (String)"LBL_PI");
                                foldType = XmlFoldTypes.PI;
                            } else if (documentElement.getType().equals("doctype")) {
                                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$folding$XmlFoldManager == null ? XmlFoldManager.class$("org.netbeans.modules.xml.text.folding.XmlFoldManager") : class$org$netbeans$modules$xml$text$folding$XmlFoldManager), (String)"LBL_DOCTYPE");
                                foldType = XmlFoldTypes.DOCTYPE;
                            } else if (documentElement.getType().equals("comment")) {
                                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$folding$XmlFoldManager == null ? XmlFoldManager.class$("org.netbeans.modules.xml.text.folding.XmlFoldManager") : class$org$netbeans$modules$xml$text$folding$XmlFoldManager), (String)"LBL_COMMENT");
                                foldType = XmlFoldTypes.COMMENT;
                            } else if (documentElement.getType().equals("cdata")) {
                                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$folding$XmlFoldManager == null ? XmlFoldManager.class$("org.netbeans.modules.xml.text.folding.XmlFoldManager") : class$org$netbeans$modules$xml$text$folding$XmlFoldManager), (String)"LBL_CDATA");
                                foldType = XmlFoldTypes.CDATA;
                            }
                            if (this.getFold(foldHierarchy, documentElement) != null) continue;
                            this.getOperation().addToHierarchy(foldType, (String)object, false, Math.max(0, documentElement.getStartOffset()), Math.min(this.getDocument().getLength(), documentElement.getEndOffset() + 1), 0, 0, null, foldHierarchyTransaction);
                            continue;
                        }
                        if (documentModelChangeInfo.getChangeType() != 2 || (object = this.getFold(foldHierarchy, documentElement)) == null) continue;
                        this.getOperation().removeFromHierarchy(object, foldHierarchyTransaction);
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                finally {
                    foldHierarchyTransaction.commit();
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        this.changes.clear();
    }

    private void dumpFolds(Fold fold, String string) {
        System.out.println(string + fold);
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.dumpFolds(fold.getFold(i), string + "  ");
        }
    }

    private Fold getFold(FoldHierarchy foldHierarchy, DocumentElement documentElement) {
        int n = documentElement.getStartOffset();
        int n2 = documentElement.getEndOffset();
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)documentElement.getStartOffset());
        if (fold == null || fold.getStartOffset() != documentElement.getStartOffset()) {
            return null;
        }
        if (fold.getEndOffset() == documentElement.getEndOffset() || fold.getEndOffset() - 1 == documentElement.getEndOffset()) {
            return fold;
        }
        return this.getFold(foldHierarchy, fold, documentElement);
    }

    private Fold getFold(FoldHierarchy foldHierarchy, Fold fold, DocumentElement documentElement) {
        int n = 0;
        if (n < fold.getFoldCount()) {
            Fold fold2 = fold.getFold(n);
            if (fold2.getStartOffset() == documentElement.getStartOffset()) {
                if (fold2.getEndOffset() == documentElement.getEndOffset() || fold2.getEndOffset() - 1 == documentElement.getEndOffset()) {
                    return fold;
                }
                return this.getFold(foldHierarchy, fold2, documentElement);
            }
            return null;
        }
        return null;
    }

    private boolean isOneLineElement(DocumentElement documentElement) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)documentElement.getDocument();
        return Utilities.getLineOffset((BaseDocument)baseDocument, (int)documentElement.getStartOffset()) == Utilities.getLineOffset((BaseDocument)baseDocument, (int)documentElement.getEndOffset());
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
    }

    private Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    public long getLastFoldsGenerationTime() {
        return this.foldsGenerationTime;
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    private static final class DocumentModelChangeInfo {
        static final int ELEMENT_ADDED = 1;
        static final int ELEMENT_REMOVED = 2;
        private DocumentElement de;
        private int type;

        public DocumentModelChangeInfo(DocumentElement documentElement, int n) {
            this.de = documentElement;
            this.type = n;
        }

        public DocumentElement getDocumentElement() {
            return this.de;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "" + (this.type == 1 ? "[ADD]" : "[REMOVE]") + " " + this.de;
        }
    }
}

