/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.xml.text.indent.Util;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;

public class DTDFormatter
extends ExtFormatter {
    public DTDFormatter(Class clazz) {
        super(clazz);
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new XMLFormatSupport(formatWriter);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indentNewLine(Document document, int n) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+ XMLFormatter::indentNewLine: doc = " + document);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+             ::indentNewLine: offset = " + n);
        }
        if (document instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)document;
            baseDocument.atomicLock();
            try {
                baseDocument.insertString(n, "\n", null);
                int n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)(++n - 1));
                int n3 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n2);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("+             ::indentNewLine: fullLine = " + n2);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("+             ::indentNewLine: indent   = " + n3);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("+             ::indentNewLine: offset   = " + n);
                }
                String string = this.getIndentString(baseDocument, n3);
                baseDocument.insertString(n, string, null);
                n += string.length();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("+             ::indentNewLine: offset = " + n);
                }
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    badLocationException.printStackTrace();
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return n;
        }
        return super.indentNewLine(document, n);
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new XMLFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            FormatTokenPosition formatTokenPosition;
            XMLFormatSupport xMLFormatSupport = (XMLFormatSupport)this.createFormatSupport(formatWriter);
            if (xMLFormatSupport.isLineStart(formatTokenPosition = xMLFormatSupport.getFormatStartPosition()) && !xMLFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("XMLFormatSupport::StripEndWhitespaceLayer::format: position = " + formatTokenPosition);
                    }
                    if ((formatTokenPosition = xMLFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = xMLFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

