/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class XMLFormatter
extends ExtFormatter {
    private static final Pattern VALID_TAG_NAME = Pattern.compile("[\\w+|-]*");
    private static final int WORKUNITS_MAX = 100;

    public XMLFormatter(Class clazz) {
        super(clazz);
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new XMLFormatSupport(formatWriter);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
    }

    public Writer reformat(final BaseDocument baseDocument, final int n, final int n2, final boolean bl) throws BadLocationException, IOException {
        TokenItem tokenItem = null;
        final XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport().get(XMLSyntaxSupport.class);
        if (xMLSyntaxSupport == null) {
            return null;
        }
        if (n == n2) {
            int n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n2);
            tokenItem = xMLSyntaxSupport.getTokenChain(n3, n3 + 1);
            if (tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().endsWith(">") && !tokenItem.getImage().endsWith("/>")) {
                int[] nArray;
                while ((tokenItem = tokenItem.getPrevious()) != null && tokenItem.getTokenID() != XMLTokenIDs.TAG) {
                }
                if (tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith("<") && !tokenItem.getImage().startsWith("</") && ((nArray = xMLSyntaxSupport.findMatchingBlock(tokenItem.getOffset(), false)) != null && nArray[0] > n2 || nArray == null)) {
                    int n4 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)tokenItem.getOffset());
                    int n5 = n4 + this.getShiftWidth();
                    this.changeRowIndent(baseDocument, n, n5);
                    return null;
                }
            }
            int n6 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n2, (boolean)false);
            this.changeRowIndent(baseDocument, n, n6);
            return null;
        }
        if (!bl && n2 - n > 50000) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        XMLFormatter.this.doReformat(baseDocument, xMLSyntaxSupport, n, n2, bl, true);
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                    }
                }
            }, 0, Math.max(0, Thread.currentThread().getPriority() - 1));
        } else {
            this.doReformat(baseDocument, xMLSyntaxSupport, n, n2, bl, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReformat(BaseDocument baseDocument, XMLSyntaxSupport xMLSyntaxSupport, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        ProgressHandle progressHandle = null;
        if (bl2) {
            progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getBundle((Class)XMLFormatter.class).getString("MSG_code_reformat"));
            progressHandle.start();
            progressHandle.switchToDeterminate(100);
        }
        HackedBaseDocument hackedBaseDocument = new HackedBaseDocument(baseDocument.getKitClass(), false);
        hackedBaseDocument.insertString(0, baseDocument.getText(0, baseDocument.getLength()), null);
        XMLSyntaxSupport xMLSyntaxSupport2 = new XMLSyntaxSupport(hackedBaseDocument);
        int n8 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        int n9 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        int n10 = n9 - n8;
        hackedBaseDocument.atomicLock();
        try {
            n7 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n2);
            n6 = -1;
            n5 = 0;
            TokenItem tokenItem = null;
            block8: do {
                try {
                    int n11 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n7);
                    if (n11 == -1) {
                        n11 = n7;
                    }
                    tokenItem = xMLSyntaxSupport2.getTokenChain(n11, n11 + 1);
                    if (bl2 && (n4 = 100 - (n3 = Utilities.getLineOffset((BaseDocument)hackedBaseDocument, (int)n11)) * 100 / n10) % 10 == 0 && n5 < n4) {
                        n5 = n4;
                        progressHandle.progress((int)((double)n4 * 0.8));
                    }
                    if (tokenItem == null || tokenItem.getNext() == null) continue;
                    if (tokenItem.getOffset() <= n6) {
                        n6 = -1;
                    }
                    if (tokenItem.getTokenID() != XMLTokenIDs.TAG || !tokenItem.getImage().startsWith("</")) continue;
                    String string = tokenItem.getImage().substring(2);
                    n4 = -1;
                    while (tokenItem != null) {
                        if (tokenItem.getOffset() > n6) {
                            if (tokenItem.getTokenID() == XMLTokenIDs.TAG && !xMLSyntaxSupport2.isSingletonTag(tokenItem)) {
                                if (tokenItem.getImage().substring(1).trim().equals(string) && tokenItem.getImage().startsWith("<") && !tokenItem.getImage().startsWith("</")) {
                                    if (n4 == 0) {
                                        hackedBaseDocument.remove(n7, n11 - n7);
                                        n11 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)tokenItem.getOffset());
                                        n4 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n11);
                                        hackedBaseDocument.insertString(n7, hackedBaseDocument.getText(n4, n11 - n4), null);
                                        if (bl) continue block8;
                                        int n12 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n7) - 1));
                                        int n13 = Utilities.getRowIndent((BaseDocument)hackedBaseDocument, (int)n7) + this.getShiftWidth();
                                        int n14 = 0;
                                        while (n12 > n4) {
                                            int n15 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n12);
                                            if (n15 > -1 && (tokenItem = xMLSyntaxSupport2.getTokenChain(n15, n15 + 1)) != null && tokenItem.getTokenContextPath().contains(XMLDefaultTokenContext.contextPath)) {
                                                this.changeRowIndent(hackedBaseDocument, n12, n13);
                                                n14 = n14 + Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n12) - n15;
                                            }
                                            n12 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(n12 - 1));
                                        }
                                        n7 += n14;
                                        n6 = n4;
                                        continue block8;
                                    }
                                    --n4;
                                } else if (tokenItem.getImage().length() > 1 && tokenItem.getImage().substring(2).equals(string)) {
                                    ++n4;
                                }
                            }
                            tokenItem = tokenItem.getPrevious();
                            continue;
                        }
                        n6 = -1;
                        continue block8;
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(16, (Throwable)exception);
                }
            } while ((n7 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(n7 - 1))) > n && n7 > 0);
        }
        finally {
            hackedBaseDocument.atomicUnlock();
        }
        baseDocument.atomicLock();
        try {
            for (n7 = n8; n7 <= n9; ++n7) {
                int n16;
                n6 = Utilities.getRowStartFromLineOffset((BaseDocument)hackedBaseDocument, (int)n7);
                n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)hackedBaseDocument, (int)n6);
                int n17 = n5 - n6;
                if (n5 <= 0 || (n4 = (n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n16 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n7)))) - n16) == n17) continue;
                if (n3 > 0) {
                    baseDocument.remove(n16, n3 - n16);
                }
                baseDocument.insertString(n16, hackedBaseDocument.getText(n6, n5 - n6), null);
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
        if (bl2) {
            progressHandle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray;
        block28: {
            nArray = super.getReformatBlock(jTextComponent, string);
            try {
                int n;
                int n2;
                String string2;
                TokenItem tokenItem;
                BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                int n3 = jTextComponent.getCaret().getDot();
                XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport().get(XMLSyntaxSupport.class);
                if (xMLSyntaxSupport == null) {
                    return nArray;
                }
                if (string.charAt(0) == '>') {
                    TokenItem tokenItem2;
                    tokenItem = tokenItem2 = xMLSyntaxSupport.getTokenChain(n3 - 1, n3);
                    if (tokenItem2.getTokenID() == XMLDefaultTokenContext.TAG && !tokenItem2.getImage().endsWith("/>")) {
                        while ((tokenItem2 = tokenItem2.getPrevious()) != null && tokenItem2.getTokenID() != XMLTokenIDs.TAG) {
                        }
                        if (tokenItem2 != null && tokenItem2.getTokenID() == XMLTokenIDs.TAG) {
                            if (tokenItem2.getImage().startsWith("</")) {
                                string2 = tokenItem2.getImage().substring(2).trim();
                                n2 = -1;
                                while (tokenItem2 != null) {
                                    if (tokenItem2.getTokenID() == XMLTokenIDs.TAG) {
                                        if (tokenItem2.getImage().substring(1).trim().equals(string2) && tokenItem2.getImage().startsWith("<") && !tokenItem2.getImage().startsWith("</")) {
                                            if (n2 == 0) {
                                                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                                                return new int[]{n4, n3};
                                            }
                                            --n2;
                                        } else if (tokenItem2.getImage().length() > 1 && tokenItem2.getImage().substring(2).equals(string2)) {
                                            ++n2;
                                        }
                                    }
                                    tokenItem2 = tokenItem2.getPrevious();
                                }
                            } else {
                                int[] nArray2;
                                string2 = tokenItem2.getImage().substring(1);
                                n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(tokenItem.getOffset() + tokenItem.getImage().length()));
                                if (n2 != -1 && Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenItem.getOffset()) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2) && ((nArray2 = xMLSyntaxSupport.findMatchingBlock(tokenItem2.getOffset(), false)) != null && nArray2[0] < n3 || nArray2 == null) && VALID_TAG_NAME.matcher(string2).matches()) {
                                    baseDocument.atomicLock();
                                    try {
                                        baseDocument.insertString(n3, "</" + string2 + ">", null);
                                    }
                                    catch (BadLocationException badLocationException) {
                                    }
                                    finally {
                                        baseDocument.atomicUnlock();
                                    }
                                    jTextComponent.setCaretPosition(n3);
                                }
                            }
                        }
                    }
                }
                if (string.charAt(0) != '\n' || (n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3) - 1) <= 0 || (tokenItem = xMLSyntaxSupport.getTokenChain(n - 1, n)) == null || tokenItem.getTokenID() != XMLTokenIDs.TAG || !tokenItem.getImage().equals(">")) break block28;
                while ((tokenItem = tokenItem.getPrevious()) != null && tokenItem.getTokenID() != XMLTokenIDs.TAG) {
                }
                if (tokenItem == null || tokenItem.getTokenID() != XMLTokenIDs.TAG || !tokenItem.getImage().startsWith("<") || tokenItem.getImage().startsWith("</")) break block28;
                string2 = tokenItem.getImage().substring(1);
                tokenItem = xMLSyntaxSupport.getTokenChain(n3, n3 + 1);
                if (tokenItem == null || tokenItem.getTokenID() != XMLTokenIDs.TAG || !tokenItem.getImage().startsWith("</" + string2)) break block28;
                n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenItem.getOffset());
                baseDocument.atomicLock();
                try {
                    baseDocument.insertString(n3, "\n", null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2);
                int n6 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n2 - 1)));
                int n7 = n6 + this.getShiftWidth();
                this.changeRowIndent(baseDocument, n5, n7);
                jTextComponent.setCaretPosition(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5));
                int n8 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n2 + 1));
                int n9 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8);
                return new int[]{n8, n9};
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
        return nArray;
    }

    private class HackedBaseDocument
    extends BaseDocument {
        public HackedBaseDocument(Class clazz, boolean bl) {
            super(clazz, bl);
        }

        boolean notifyModifyCheckStart(int n, String string) throws BadLocationException {
            return false;
        }

        protected void fireInsertUpdate(DocumentEvent documentEvent) {
        }

        protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new XMLFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            FormatTokenPosition formatTokenPosition;
            XMLFormatSupport xMLFormatSupport = (XMLFormatSupport)this.createFormatSupport(formatWriter);
            if (xMLFormatSupport.isLineStart(formatTokenPosition = xMLFormatSupport.getFormatStartPosition()) && !xMLFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = xMLFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = xMLFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

