/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.navigator.FilterActions;
import org.netbeans.modules.xml.text.navigator.FiltersDescription;
import org.netbeans.modules.xml.text.navigator.FiltersManager;
import org.netbeans.modules.xml.text.navigator.NavigatorTreeCellRenderer;
import org.netbeans.modules.xml.text.navigator.TapPanel;
import org.netbeans.modules.xml.text.navigator.TreeNodeAdapter;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class NavigatorContent
extends JPanel
implements PropertyChangeListener {
    private static final boolean DEBUG = false;
    private static NavigatorContent navigatorContentInstance = null;
    static boolean showAttributes = true;
    static boolean showContent = true;
    private JPanel active = null;
    private final JPanel emptyPanel;
    private JLabel msgLabel;
    private DataObject peerDO = null;
    private WeakHashMap uiCache = new WeakHashMap();
    private boolean editorOpened = false;
    private static final Icon WAIT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/wait.gif"));
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie$Observable;

    public static synchronized NavigatorContent getDefault() {
        if (navigatorContentInstance == null) {
            navigatorContentInstance = new NavigatorContent();
        }
        return navigatorContentInstance;
    }

    private NavigatorContent() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBackground(Color.WHITE);
        this.emptyPanel.setLayout(new BorderLayout());
        this.msgLabel = new JLabel();
        this.emptyPanel.add((Component)this.msgLabel, "Center");
    }

    public void navigate(DataObject dataObject) {
        EditorCookie editorCookie;
        if (this.peerDO != null && this.peerDO != dataObject) {
            this.closeDocument(this.peerDO);
        }
        if ((editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) == null) {
            ErrorManager.getDefault().log(1, "The DataObject " + dataObject.getName() + "(class=" + dataObject.getClass().getName() + ") has no EditorCookie!?");
        } else {
            try {
                BaseDocument baseDocument = (BaseDocument)editorCookie.openDocument();
                if (baseDocument != null) {
                    this.navigate(dataObject, baseDocument);
                    this.peerDO = dataObject;
                    this.editorOpened = editorCookie.getOpenedPanes() != null && editorCookie.getOpenedPanes().length > 0;
                }
            }
            catch (UserQuestionException userQuestionException) {
                this.showDocumentTooLarge();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public void navigate(final DataObject dataObject, final BaseDocument baseDocument) {
        NavigatorContentPanel navigatorContentPanel;
        this.showScanningPanel();
        WeakReference weakReference = (WeakReference)this.uiCache.get(dataObject);
        if (weakReference != null) {
            NavigatorContentPanel navigatorContentPanel2 = (NavigatorContentPanel)weakReference.get();
            if (navigatorContentPanel2 != null) {
                NavigatorContentPanel navigatorContentPanel3 = navigatorContentPanel = baseDocument == navigatorContentPanel2.getDocument() ? navigatorContentPanel2 : null;
                if (navigatorContentPanel == null) {
                    this.uiCache.remove(dataObject);
                }
            } else {
                navigatorContentPanel = null;
            }
        } else {
            navigatorContentPanel = null;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block12: {
                    try {
                        DocumentModel documentModel = navigatorContentPanel == null ? DocumentModel.getDocumentModel((Document)baseDocument) : null;
                        if (navigatorContentPanel != null || documentModel != null) {
                            if (documentModel != null) {
                                documentModel.readLock();
                            }
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, documentModel){
                                    private final /* synthetic */ DocumentModel val$model;
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$model = documentModel;
                                    }

                                    public void run() {
                                        NavigatorContent.access$100(1.access$000(this.this$1));
                                        JPanel jPanel = null;
                                        if (1.access$200(this.this$1) == null) {
                                            jPanel = 1.access$000(this.this$1).new NavigatorContentPanel(this.val$model);
                                            NavigatorContent.access$400(1.access$000(this.this$1)).put(1.access$300(this.this$1), new WeakReference<JPanel>(jPanel));
                                            EditorCookie.Observable observable = (EditorCookie.Observable)1.access$300(this.this$1).getCookie(class$org$openide$cookies$EditorCookie$Observable == null ? (class$org$openide$cookies$EditorCookie$Observable = NavigatorContent.class$("org.openide.cookies.EditorCookie$Observable")) : class$org$openide$cookies$EditorCookie$Observable);
                                            if (observable != null) {
                                                observable.addPropertyChangeListener((PropertyChangeListener)1.access$000(this.this$1));
                                            } else {
                                                ErrorManager.getDefault().log(1, "The DataObject " + 1.access$300(this.this$1).getName() + "(class=" + 1.access$300(this.this$1).getClass().getName() + ") has no EditorCookie.Observable!");
                                            }
                                        } else {
                                            jPanel = 1.access$200(this.this$1);
                                        }
                                        1.access$000(this.this$1).removeAll();
                                        1.access$000(this.this$1).add((Component)jPanel, "Center");
                                        1.access$000(this.this$1).revalidate();
                                        1.access$000(this.this$1).repaint();
                                    }
                                });
                                break block12;
                            }
                            catch (InterruptedException interruptedException) {
                                ErrorManager.getDefault().notify(16, (Throwable)interruptedException);
                                break block12;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                ErrorManager.getDefault().notify(65536, (Throwable)invocationTargetException);
                                break block12;
                            }
                            finally {
                                if (documentModel != null) {
                                    documentModel.readUnlock();
                                }
                            }
                        }
                        NavigatorContent.this.showCannotNavigate();
                    }
                    catch (DocumentModelException documentModelException) {
                        ErrorManager.getDefault().notify(1, (Throwable)documentModelException);
                    }
                }
            }

            static /* synthetic */ NavigatorContent access$000(1 var0) {
                return var0.NavigatorContent.this;
            }

            static /* synthetic */ JPanel access$200(1 var0) {
                return var0.navigatorContentPanel;
            }

            static /* synthetic */ DataObject access$300(1 var0) {
                return var0.dataObject;
            }
        });
    }

    public void release() {
        this.removeAll();
        this.repaint();
        this.closeDocument(this.peerDO);
    }

    private void closeDocument(DataObject dataObject) {
        EditorCookie editorCookie;
        if (dataObject != null && (editorCookie = (EditorCookie)this.peerDO.getCookie(EditorCookie.class)) != null) {
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
                ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.editorOpened) {
                    editorCookie.close();
                }
            }
            this.editorOpened = false;
        }
    }

    public void showDocumentTooLarge() {
        this.removeAll();
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setText(NbBundle.getMessage((Class)NavigatorContent.class, (String)"LBL_TooLarge"));
        this.msgLabel.setHorizontalAlignment(0);
        this.add((Component)this.emptyPanel, "Center");
        this.repaint();
    }

    public void showCannotNavigate() {
        this.removeAll();
        this.msgLabel.setIcon(null);
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setText(NbBundle.getMessage((Class)NavigatorContent.class, (String)"LBL_CannotNavigate"));
        this.msgLabel.setHorizontalAlignment(0);
        this.add((Component)this.emptyPanel, "Center");
        this.repaint();
    }

    private void showScanningPanel() {
        this.removeAll();
        this.msgLabel.setIcon(WAIT_ICON);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setForeground(Color.BLACK);
        this.msgLabel.setText(NbBundle.getMessage((Class)NavigatorContent.class, (String)"LBL_Scan"));
        this.add((Component)this.emptyPanel, "North");
        this.repaint();
    }

    private void showWaitPanel() {
        this.removeAll();
        this.msgLabel.setIcon(null);
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setText(NbBundle.getMessage((Class)NavigatorContent.class, (String)"LBL_Wait"));
        this.add((Component)this.emptyPanel, "North");
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "document") {
            if (propertyChangeEvent.getNewValue() == null) {
                final DataObject dataObject = ((DataEditorSupport)propertyChangeEvent.getSource()).getDataObject();
                if (dataObject != null) {
                    this.editorOpened = false;
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie != null) {
                        ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (dataObject.isValid()) {
                                NavigatorContent.this.navigate(dataObject);
                            }
                        }
                    });
                }
            } else {
                this.editorOpened = true;
            }
        }
    }

    static /* synthetic */ void access$100(NavigatorContent navigatorContent) {
        navigatorContent.showWaitPanel();
    }

    static /* synthetic */ WeakHashMap access$400(NavigatorContent navigatorContent) {
        return navigatorContent.uiCache;
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private JTree tree;
        private FiltersManager filters;
        private Document doc;
        public static final String ATTRIBUTES_FILTER = "attrs";
        public static final String CONTENT_FILTER = "content";

        public NavigatorContentPanel(DocumentModel documentModel) {
            this.doc = documentModel.getDocument();
            this.setLayout(new BorderLayout());
            this.tree = new PatchedJTree();
            TreeModel treeModel = this.createTreeModel(documentModel);
            this.tree.setModel(treeModel);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.tree.setCellRenderer(new NavigatorTreeCellRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter mouseAdapter = new MouseAdapter(this){
                private final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = navigatorContentPanel;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = NavigatorContentPanel.access$500(this.this$1).getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        TreePath treePath = NavigatorContentPanel.access$500(this.this$1).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)treePath.getLastPathComponent();
                        if (mouseEvent.getClickCount() == 2) {
                            NavigatorContentPanel.access$600(this.this$1, treeNodeAdapter, false);
                        }
                        if (mouseEvent.getClickCount() == 1) {
                            NavigatorContentPanel.access$600(this.this$1, treeNodeAdapter, true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter);
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(defaultTreeSelectionModel);
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open");
            this.tree.getActionMap().put("open", new AbstractAction(this, defaultTreeSelectionModel){
                private final /* synthetic */ TreeSelectionModel val$selectionModel;
                private final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = navigatorContentPanel;
                    this.val$selectionModel = treeSelectionModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = this.val$selectionModel.getLeadSelectionPath();
                    TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)treePath.getLastPathComponent();
                    NavigatorContentPanel.access$600(this.this$1, treeNodeAdapter, false);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)jScrollPane, "Center");
            TapPanel tapPanel = new TapPanel();
            JLabel jLabel = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"LBL_Filter"));
            jLabel.setBorder(new EmptyBorder(0, 5, 5, 0));
            tapPanel.add(jLabel);
            tapPanel.setOrientation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String string = Utilities.keyToString((KeyStroke)keyStroke);
            tapPanel.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"TIP_TapPanel", (Object)string));
            this.filters = this.createFilters();
            this.filters.hookChangeListener(this);
            tapPanel.add(this.filters.getComponent());
            this.add((Component)tapPanel, "South");
            MouseAdapter mouseAdapter2 = new MouseAdapter(this){
                private final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = navigatorContentPanel;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && mouseEvent.getModifiers() == 4) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        JMenuItem[] jMenuItemArray = new FilterActions(NavigatorContentPanel.access$700(this.this$1)).createMenuItems();
                        for (int i = 0; i < jMenuItemArray.length; ++i) {
                            jPopupMenu.add(jMenuItemArray[i]);
                        }
                        jPopupMenu.pack();
                        jPopupMenu.show(NavigatorContentPanel.access$500(this.this$1), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter2);
            TreeNode treeNode = (TreeNode)treeModel.getRoot();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = treeNode.getChildAt(i);
                if (treeNode2.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{treeNode, treeNode2}));
            }
        }

        public Document getDocument() {
            return this.doc;
        }

        private void openAndFocusElement(TreeNodeAdapter treeNodeAdapter, boolean bl) {
            BaseDocument baseDocument = (BaseDocument)treeNodeAdapter.getDocumentElement().getDocument();
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
            if (dataObject == null) {
                return;
            }
            EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(class$org$openide$cookies$EditorCookie$Observable == null ? (class$org$openide$cookies$EditorCookie$Observable = NavigatorContent.class$("org.openide.cookies.EditorCookie$Observable")) : class$org$openide$cookies$EditorCookie$Observable);
            if (observable == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(this, observable, treeNodeAdapter, bl){
                private final /* synthetic */ EditorCookie.Observable val$ec;
                private final /* synthetic */ TreeNodeAdapter val$selected;
                private final /* synthetic */ boolean val$selectLineOnly;
                private final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = navigatorContentPanel;
                    this.val$ec = observable;
                    this.val$selected = treeNodeAdapter;
                    this.val$selectLineOnly = bl;
                }

                public void run() {
                    JEditorPane[] jEditorPaneArray = this.val$ec.getOpenedPanes();
                    if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                        NavigatorContentPanel.access$800(this.this$1, jEditorPaneArray[0], this.val$selected, !this.val$selectLineOnly);
                    } else if (!this.val$selectLineOnly) {
                        this.val$ec.open();
                        try {
                            this.val$ec.openDocument();
                            jEditorPaneArray = this.val$ec.getOpenedPanes();
                            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                NavigatorContentPanel.access$800(this.this$1, jEditorPaneArray[0], this.val$selected, true);
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }

        private void selectElementInPane(JEditorPane jEditorPane, TreeNodeAdapter treeNodeAdapter, boolean bl) {
            RequestProcessor.getDefault().post(new Runnable(this, jEditorPane, treeNodeAdapter){
                private final /* synthetic */ JEditorPane val$pane;
                private final /* synthetic */ TreeNodeAdapter val$tna;
                private final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = navigatorContentPanel;
                    this.val$pane = jEditorPane;
                    this.val$tna = treeNodeAdapter;
                }

                public void run() {
                    this.val$pane.setCaretPosition(this.val$tna.getDocumentElement().getStartOffset());
                }
            });
            if (bl) {
                Container container = jEditorPane;
                while (!(container instanceof TopComponent)) {
                    container = container.getParent();
                }
                ((TopComponent)container).requestActive();
            }
        }

        private TreeModel createTreeModel(DocumentModel documentModel) {
            DocumentElement documentElement = documentModel.getRootElement();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(null);
            TreeNodeAdapter treeNodeAdapter = new TreeNodeAdapter(documentElement, defaultTreeModel, this.tree, null);
            defaultTreeModel.setRoot(treeNodeAdapter);
            return defaultTreeModel;
        }

        private FiltersManager createFilters() {
            FiltersDescription filtersDescription = new FiltersDescription();
            filtersDescription.addFilter(ATTRIBUTES_FILTER, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"LBL_ShowAttributes"), NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"LBL_ShowAttributesTip"), showAttributes, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/a.png")), null);
            filtersDescription.addFilter(CONTENT_FILTER, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"LBL_ShowContent"), NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$navigator$NavigatorContent == null ? (class$org$netbeans$modules$xml$text$navigator$NavigatorContent = NavigatorContent.class$("org.netbeans.modules.xml.text.navigator.NavigatorContent")) : class$org$netbeans$modules$xml$text$navigator$NavigatorContent), (String)"LBL_ShowContentTip"), showContent, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/content.png")), null);
            return FiltersDescription.createManager(filtersDescription);
        }

        public void filterStateChanged(ChangeEvent changeEvent) {
            showAttributes = this.filters.isSelected(ATTRIBUTES_FILTER);
            showContent = this.filters.isSelected(CONTENT_FILTER);
            this.tree.repaint();
        }

        static /* synthetic */ JTree access$500(NavigatorContentPanel navigatorContentPanel) {
            return navigatorContentPanel.tree;
        }

        static /* synthetic */ void access$600(NavigatorContentPanel navigatorContentPanel, TreeNodeAdapter treeNodeAdapter, boolean bl) {
            navigatorContentPanel.openAndFocusElement(treeNodeAdapter, bl);
        }

        static /* synthetic */ FiltersManager access$700(NavigatorContentPanel navigatorContentPanel) {
            return navigatorContentPanel.filters;
        }

        static /* synthetic */ void access$800(NavigatorContentPanel navigatorContentPanel, JEditorPane jEditorPane, TreeNodeAdapter treeNodeAdapter, boolean bl) {
            navigatorContentPanel.selectElementInPane(jEditorPane, treeNodeAdapter, bl);
        }

        private class PatchedJTree
        extends JTree {
            private boolean firstPaint = true;

            public void paint(Graphics graphics) {
                if (this.firstPaint) {
                    int n = graphics.getFontMetrics(this.getFont()).getHeight();
                    this.setRowHeight(n + 2);
                    this.firstPaint = false;
                }
                super.paint(graphics);
            }
        }
    }
}

