/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.xml.text.navigator.NavigatorContent;

public class TreeNodeAdapter
implements TreeNode,
DocumentElementListener {
    private DocumentElement de;
    private DefaultTreeModel tm;
    private TreeNode parent;
    private JTree tree;
    private ArrayList children;
    private ArrayList textElements;
    private String textContent;
    private boolean containsError = false;
    private int childrenErrorCount = 0;
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final int ATTRIBS_MAX_LEN = 30;
    private static final int TEXT_MAX_LEN = 30;

    public TreeNodeAdapter(DocumentElement documentElement, DefaultTreeModel defaultTreeModel, JTree jTree, TreeNode treeNode) {
        this(documentElement, defaultTreeModel, jTree, treeNode, true);
    }

    public TreeNodeAdapter(DocumentElement documentElement, DefaultTreeModel defaultTreeModel, JTree jTree, TreeNode treeNode, boolean bl) {
        this.de = documentElement;
        this.tm = defaultTreeModel;
        this.tree = jTree;
        this.parent = treeNode;
        this.children = new ArrayList();
        this.textElements = new ArrayList();
        if (bl) {
            this.createChildrenAdapters();
        }
        documentElement.addDocumentElementListener((DocumentElementListener)this);
        this.childTextElementChanged();
    }

    public String getDocumentContent() {
        return this.textContent;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DocumentElement getDocumentElement() {
        return this.de;
    }

    public TreeNodeAdapter getChildTreeNode(DocumentElement documentElement) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)this.getChildAt(i);
            if (!treeNodeAdapter.getDocumentElement().equals((Object)documentElement)) continue;
            return treeNodeAdapter;
        }
        return null;
    }

    public boolean containsError() {
        return this.containsError;
    }

    public int getChildrenErrorCount() {
        return this.childrenErrorCount;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean bl) {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            String string;
            String string2 = "";
            AttributeSet attributeSet = this.getDocumentElement().getAttributes();
            if (attributeSet.getAttributeCount() > 0) {
                string = this.getAttribsText();
                if (NavigatorContent.showAttributes) {
                    string2 = string.length() > 30 ? string.substring(0, 30) + "..." : string.toString();
                }
            }
            string = "";
            String string3 = this.getDocumentContent();
            if (NavigatorContent.showContent) {
                string = string3.length() > 30 ? string3.substring(0, 30) + "..." : string3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bl ? "<html>" : "");
            stringBuffer.append(bl && this.containsError ? "<font color=FF0000><b>" : "");
            stringBuffer.append(this.getDocumentElement().getName());
            stringBuffer.append(bl && this.containsError ? "</b></font>" : "");
            stringBuffer.append(bl ? "<font color=888888>" : "");
            if (string2.trim().length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
            }
            stringBuffer.append(bl ? "</font>" : "");
            if (string.trim().length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            stringBuffer.append(bl ? "</html>" : "");
            return stringBuffer.toString();
        }
        if (this.de.getType().equals("pi")) {
            String string = this.getPIText();
            string = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string;
        }
        if (this.de.getType().equals("doctype")) {
            String string = this.getDoctypeText();
            String string4 = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string4;
        }
        if (this.de.getType().equals("cdata")) {
            String string = this.getCDATAText();
            String string5 = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string5;
        }
        return this.de.getName() + " [unknown content]";
    }

    public String getToolTipText() {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            return this.getAttribsText() + " " + this.getDocumentContent();
        }
        if (this.de.getType().equals("pi")) {
            return this.getPIText();
        }
        if (this.de.getType().equals("doctype")) {
            return this.getDoctypeText();
        }
        if (this.de.getType().equals("cdata")) {
            return this.getCDATAText();
        }
        return "";
    }

    private String getPIText() {
        String string = null;
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            int n = "<?".length() + this.de.getName().length();
            if (n > string.length() - 1) {
                n = string.length() - 1;
            }
            if (string.length() > 0) {
                string = string.substring(n, string.length() - 1).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    private String getDoctypeText() {
        String string = "???";
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            if (string.length() > 0) {
                string = string.substring("<!DOCTYPE ".length() + this.de.getName().length(), string.length() - 1).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    private String getCDATAText() {
        String string = "???";
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            if (string.length() > 0) {
                string = string.substring("<![CDATA[".length(), string.length() - "]]>".length()).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    public void childrenReordered(DocumentElementEvent documentElementEvent) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TreeNodeAdapter.this.tm.nodeStructureChanged(TreeNodeAdapter.this);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getAttribsText() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = this.getDocumentElement().getAttributes().getAttributeNames();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.getDocumentElement().getAttributes().getAttribute(string);
                stringBuffer.append(string);
                stringBuffer.append("=\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public void elementAdded(DocumentElementEvent documentElementEvent) {
        DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> +EVENT called on " + this.hashCode() + " - " + this.de + ": element " + documentElement + " is going to be added");
        }
        if (documentElement.getType().equals("content")) {
            this.textElements.add(new TextElementWrapper(documentElement));
            this.childTextElementChanged();
        } else if (documentElement.getType().equals("error")) {
            this.markNodeAsErrorInAWT(this);
        } else if (!documentElement.getType().equals("comment")) {
            TreeNodeAdapter treeNodeAdapter = new TreeNodeAdapter(documentElement, this.tm, this.tree, this, true);
            int n = this.getVisibleChildIndex(documentElement);
            if (this.getChildTreeNode(documentElement) == null) {
                this.children.add(n, treeNodeAdapter);
                final int n2 = this.getIndex(treeNodeAdapter);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            TreeNodeAdapter.this.tm.nodesWereInserted(TreeNodeAdapter.this, new int[]{n2});
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (debug) {
                System.out.println("<<<EVENT finished (node " + treeNodeAdapter + " added)");
            }
        }
        if (this.de.equals((Object)this.de.getDocumentModel().getRootElement())) {
            this.tree.expandPath(new TreePath(this));
        }
    }

    private void markNodeAsErrorInAWT(final TreeNodeAdapter treeNodeAdapter) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TreeNodeAdapter.this.markNodeAsError(treeNodeAdapter);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.markNodeAsError(treeNodeAdapter);
        }
    }

    private void markNodeAsError(TreeNodeAdapter treeNodeAdapter) {
        treeNodeAdapter.containsError = true;
        TreeNodeAdapter treeNodeAdapter2 = treeNodeAdapter;
        this.tm.nodeChanged(treeNodeAdapter);
        while ((treeNodeAdapter2 = (TreeNodeAdapter)treeNodeAdapter2.getParent()) != null) {
            if (treeNodeAdapter2.getParent() != null) {
                ++treeNodeAdapter2.childrenErrorCount;
            }
            this.tm.nodeChanged(treeNodeAdapter2);
        }
    }

    private int getVisibleChildIndex(DocumentElement documentElement) {
        int n = 0;
        Iterator iterator = this.getDocumentElement().getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentElement documentElement2 = (DocumentElement)iterator.next();
            if (documentElement2.equals((Object)documentElement)) {
                return n;
            }
            if (documentElement2.getType().equals("content") || documentElement2.getType().equals("error") || documentElement2.getType().equals("comment")) continue;
            ++n;
        }
        return -1;
    }

    public void elementRemoved(DocumentElementEvent documentElementEvent) {
        DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> -EVENT on " + this.hashCode() + " - " + this.de + ": element " + documentElement + " is going to be removed ");
        }
        if (documentElement.getType().equals("content")) {
            if (debug) {
                System.out.println(">>> removing CONTENT element");
            }
            Iterator iterator = this.textElements.iterator();
            ArrayList<TextElementWrapper> arrayList = new ArrayList<TextElementWrapper>();
            while (iterator.hasNext()) {
                TextElementWrapper textElementWrapper = (TextElementWrapper)iterator.next();
                if (!documentElement.equals((Object)textElementWrapper.getDocumentElement())) continue;
                arrayList.add(textElementWrapper);
            }
            this.textElements.removeAll(arrayList);
            this.childTextElementChanged();
        } else if (documentElement.getType().equals("error")) {
            this.unmarkNodeAsErrorInAWT(this);
        } else if (!documentElement.getType().equals("comment")) {
            if (debug) {
                System.out.println(">>> removing tag element");
            }
            final TreeNode treeNode = this.getChildTreeNodeForDE(documentElement);
            final int n = this.getIndex(treeNode);
            if (treeNode != null) {
                this.children.remove(treeNode);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            TreeNodeAdapter.this.tm.nodesWereRemoved(TreeNodeAdapter.this, new int[]{n}, new Object[]{treeNode});
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (debug) {
                System.out.println("Warning: TreeNode for removed element doesn't exist!!!");
            }
        }
        if (debug) {
            System.out.println("<<<EVENT finished (node removed)");
        }
    }

    private void unmarkNodeAsErrorInAWT(final TreeNodeAdapter treeNodeAdapter) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    treeNodeAdapter.containsError = false;
                    TreeNodeAdapter treeNodeAdapter2 = treeNodeAdapter;
                    TreeNodeAdapter.this.tm.nodeChanged(treeNodeAdapter);
                    while ((treeNodeAdapter2 = (TreeNodeAdapter)treeNodeAdapter2.getParent()) != null) {
                        if (treeNodeAdapter2.getParent() != null) {
                            treeNodeAdapter2.childrenErrorCount--;
                        }
                        TreeNodeAdapter.this.tm.nodeChanged(treeNodeAdapter2);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void attributesChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("Attributes of treenode " + this + " has changed.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TreeNodeAdapter.this.tm.nodeChanged(TreeNodeAdapter.this);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void contentChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("treenode " + this + " changed.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TreeNodeAdapter.this.tm.nodeChanged(TreeNodeAdapter.this);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private TreeNode getChildTreeNodeForDE(DocumentElement documentElement) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)iterator.next();
            if (!treeNodeAdapter.getDocumentElement().equals((Object)documentElement)) continue;
            return treeNodeAdapter;
        }
        return null;
    }

    private void createChildrenAdapters() {
        Iterator iterator = this.de.getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentElement documentElement = (DocumentElement)iterator.next();
            if (documentElement.getType().equals("content")) {
                this.textElements.add(new TextElementWrapper(documentElement));
                this.childTextElementChanged();
                continue;
            }
            if (documentElement.getType().equals("error")) {
                this.markNodeAsErrorInAWT(this);
                continue;
            }
            if (documentElement.getType().equals("comment") || this.getChildTreeNode(documentElement) != null) continue;
            this.children.add(new TreeNodeAdapter(documentElement, this.tm, this.tree, this));
        }
    }

    public void childTextElementChanged() {
        Iterator iterator = this.getDocumentElement().getChildren().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            DocumentElement documentElement = (DocumentElement)iterator.next();
            if (!documentElement.getType().equals("content")) continue;
            try {
                int n = documentElement.getEndOffset() - documentElement.getStartOffset() + 1;
                n = n > documentElement.getDocument().getLength() ? documentElement.getDocument().getLength() : n;
                stringBuffer.append(documentElement.getDocument().getText(documentElement.getStartOffset(), n).trim());
            }
            catch (BadLocationException badLocationException) {
                stringBuffer.append("???");
            }
        }
        this.textContent = stringBuffer.toString();
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TreeNodeAdapter.this.tm.nodeChanged(TreeNodeAdapter.this);
                    }
                });
            } else {
                this.tm.nodeChanged(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final class TextElementWrapper
    implements DocumentElementListener {
        private DocumentElement de;

        public TextElementWrapper(DocumentElement documentElement) {
            this.de = documentElement;
            documentElement.addDocumentElementListener((DocumentElementListener)this);
        }

        public DocumentElement getDocumentElement() {
            return this.de;
        }

        public void contentChanged(DocumentElementEvent documentElementEvent) {
            TreeNodeAdapter.this.childTextElementChanged();
        }

        public void elementAdded(DocumentElementEvent documentElementEvent) {
            System.err.println("????? a child node added into a text element!!!!");
        }

        public void elementRemoved(DocumentElementEvent documentElementEvent) {
        }

        public void childrenReordered(DocumentElementEvent documentElementEvent) {
        }

        public void attributesChanged(DocumentElementEvent documentElementEvent) {
        }
    }
}

