/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.DTDKit;
import org.netbeans.modules.xml.text.syntax.DTDTokenContext;
import org.netbeans.modules.xml.text.syntax.XMLKit;

public class XMLSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "xml-settings-initializer";

    public XMLSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class clazz, Map map) {
        if (clazz == null) {
            return;
        }
        if (clazz == BaseKit.class) {
            new XMLTokenColoringInitializer().updateSettingsMap(clazz, map);
            new DTDTokenColoringInitializer().updateSettingsMap(clazz, map);
        }
        if (clazz == DTDKit.class) {
            map.put("abbrev-map", this.getDTDAbbrevMap());
            SettingsUtil.updateListSetting((Map)map, (String)"token-context-list", (Object[])new TokenContext[]{DTDTokenContext.context});
        }
        if (clazz == XMLKit.class) {
            map.put("code-folding-enable", Boolean.TRUE);
            map.put("abbrev-map", this.getXMLAbbrevMap());
            SettingsUtil.updateListSetting((Map)map, (String)"token-context-list", (Object[])new TokenContext[]{XMLDefaultTokenContext.context});
            map.put("identifier-acceptor", this.getXMLIdentifierAcceptor());
        }
        if (clazz == XMLKit.class || clazz == DTDKit.class) {
            map.put("abbrev-reset-acceptor", new Acceptor(){

                public boolean accept(char c) {
                    return AcceptorFactory.NON_JAVA_IDENTIFIER.accept(c) && c != '!' && c != '?';
                }
            });
        }
    }

    Map getXMLAbbrevMap() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("?xm", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        treeMap.put("!do", "<!DOCTYPE ");
        treeMap.put("!cd", "<![CDATA[|]]>");
        treeMap.put("!at", "<!ATTLIST |>");
        treeMap.put("!el", "<!ELEMENT |>");
        treeMap.put("!en", "<!ENTITY |>");
        treeMap.put("pu", "PUBLIC \"|\"");
        treeMap.put("sy", "SYSTEM \"|\"");
        return treeMap;
    }

    Map getDTDAbbrevMap() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("!at", "<!ATTLIST |>");
        treeMap.put("!el", "<!ELEMENT |>");
        treeMap.put("!en", "<!ENTITY |>");
        treeMap.put("!no", "<!NOTATION |>");
        treeMap.put("cd", "CDATA");
        treeMap.put("em", "EMPTY");
        treeMap.put("en", "ENTITY");
        treeMap.put("ens", "ENTITIES");
        treeMap.put("fi", "#FIXED");
        treeMap.put("im", "#IMPLIED");
        treeMap.put("nm", "NMTOKEN");
        treeMap.put("nms", "NMTOKENS");
        treeMap.put("nn", "NOTATION");
        treeMap.put("pc", "#PCDATA");
        treeMap.put("pu", "PUBLIC \"|\"");
        treeMap.put("re", "#REQUIRED");
        treeMap.put("rf", "IDREF");
        treeMap.put("rfs", "IDREFS");
        treeMap.put("sy", "SYSTEM \"|\"");
        return treeMap;
    }

    Acceptor getXMLIdentifierAcceptor() {
        return new Acceptor(){

            public boolean accept(char c) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '/': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    static class DTDTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        public DTDTokenColoringInitializer() {
            super((TokenContext)DTDTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl) {
            return new Coloring(null, Color.BLACK, null);
        }
    }

    static class XMLTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        public XMLTokenColoringInitializer() {
            super((TokenContext)XMLDefaultTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl) {
            return new Coloring(null, Color.BLACK, null);
        }
    }
}

