/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.CDATASectionImpl;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.DocumentTypeImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xml.text.syntax.dom.TextImpl;
import org.openide.ErrorManager;
import org.openide.util.WeakListeners;

public class XMLSyntaxSupport
extends ExtSyntaxSupport
implements XMLTokenIDs {
    private Reference reference = new SoftReference<Object>(null);
    private String systemId = null;
    private String publicId = null;
    private volatile boolean requestedAutoCompletion = false;
    private char lastInsertedChar = (char)88;
    private final DocumentMonitor documentMonitor = new DocumentMonitor();
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    public XMLSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        DocumentListener documentListener = WeakListeners.document((DocumentListener)this.documentMonitor, (Object)baseDocument);
        baseDocument.addDocumentListener(documentListener);
    }

    public TokenItem getPreviousToken(int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw new BadLocationException("Offset " + n + " cannot be less than 0.", n);
        }
        TokenItem tokenItem = null;
        int n2 = 11;
        int n3 = this.getDocument().getLength();
        if (n > n3) {
            throw new BadLocationException("Offset " + n + " cannot be higher that document length " + n3 + " .", n);
        }
        int n4 = Math.min(n3, n);
        int n5 = Math.min(n3, n);
        while (tokenItem == null) {
            if ((n4 = Math.max(n4 - n2, 0)) == 0) {
                n5 = Math.min(n5 + n2, n3);
            }
            tokenItem = this.getTokenChain(n4, n5);
            if (n4 != 0 || n5 != n3 || tokenItem != null) continue;
            throw new IllegalStateException("Token at " + n + " cannot be located!\nInspected range:[" + n4 + ", " + n5 + "].");
        }
        while (tokenItem.getOffset() + tokenItem.getImage().length() < n) {
            TokenItem tokenItem2 = tokenItem.getNext();
            if (tokenItem2 == null) {
                if (tokenItem.getOffset() + tokenItem.getImage().length() >= n3) {
                    return tokenItem;
                }
                throw new IllegalStateException("Token at " + n + " cannot be located!\nPrevious token: " + tokenItem);
            }
            tokenItem = tokenItem2;
        }
        return tokenItem;
    }

    public SyntaxElement getElementChain(int n) throws BadLocationException {
        TokenItem tokenItem = this.getPreviousToken(n);
        if (tokenItem == null) {
            return null;
        }
        TokenID tokenID = tokenItem.getTokenID();
        TokenItem tokenItem2 = tokenItem;
        if (tokenID == CHARACTER) {
            while (tokenID == CHARACTER && (tokenItem = tokenItem.getPrevious()) != null) {
                tokenID = tokenItem.getTokenID();
                tokenItem2 = tokenItem;
            }
            if (tokenID == XMLDefaultTokenContext.TAG && tokenItem.getImage().endsWith(">")) {
                return this.createElement(tokenItem.getNext());
            }
            if (tokenID != VALUE && tokenID != TEXT && tokenID != CDATA_SECTION) {
                if (tokenID == XMLDefaultTokenContext.TAG) {
                    if (tokenItem.getImage().startsWith("<")) {
                        return this.createElement(tokenItem);
                    }
                    while ((tokenID = (tokenItem = tokenItem.getPrevious()).getTokenID()) != XMLDefaultTokenContext.TAG) {
                    }
                    return this.createElement(tokenItem);
                }
                return this.createElement(tokenItem2);
            }
        }
        if (tokenID == XMLDefaultTokenContext.WS || tokenID == XMLDefaultTokenContext.ARGUMENT || tokenID == XMLDefaultTokenContext.OPERATOR || tokenID == XMLDefaultTokenContext.VALUE) {
            while (!((tokenID = (tokenItem = tokenItem.getPrevious()).getTokenID()) == XMLDefaultTokenContext.TAG || tokenID == XMLDefaultTokenContext.DECLARATION && tokenItem.getImage().trim().length() > 0 || this.isInPI(tokenID, false))) {
            }
        }
        if (tokenID == TEXT) {
            while (tokenID == TEXT || tokenID == CHARACTER) {
                tokenItem2 = tokenItem;
                if ((tokenItem = tokenItem.getPrevious()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return this.createElement(tokenItem2);
        }
        if (tokenID == CDATA_SECTION) {
            return this.createElement(tokenItem);
        }
        if (tokenID == XMLDefaultTokenContext.TAG) {
            if (tokenItem.getImage().startsWith("<")) {
                return this.createElement(tokenItem);
            }
            while ((tokenID = (tokenItem = tokenItem.getPrevious()).getTokenID()) != XMLDefaultTokenContext.TAG) {
            }
            return this.createElement(tokenItem);
        }
        if (tokenID == XMLDefaultTokenContext.ERROR) {
            return new SyntaxElement.Error(this, tokenItem, XMLSyntaxSupport.getTokenEnd(tokenItem));
        }
        if (tokenID == XMLDefaultTokenContext.BLOCK_COMMENT) {
            while (tokenID == XMLDefaultTokenContext.BLOCK_COMMENT && !tokenItem.getImage().startsWith("<!--")) {
                tokenItem2 = tokenItem;
                tokenItem = tokenItem.getPrevious();
                tokenID = tokenItem.getTokenID();
            }
            return this.createElement(tokenItem2);
        }
        if (tokenID == XMLDefaultTokenContext.DECLARATION) {
            while (true) {
                tokenItem2 = tokenItem;
                if (tokenID == XMLDefaultTokenContext.DECLARATION && tokenItem.getImage().startsWith("<!") || (tokenItem = tokenItem.getPrevious()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return this.createElement(tokenItem2);
        }
        if (this.isInPI(tokenID, false)) {
            while ((tokenID = (tokenItem = tokenItem.getPrevious()).getTokenID()) != XMLDefaultTokenContext.PI_START) {
            }
        }
        if (tokenID == XMLDefaultTokenContext.PI_START) {
            return this.createElement(tokenItem);
        }
        return null;
    }

    private boolean isInPI(TokenID tokenID, boolean bl) {
        return tokenID == XMLDefaultTokenContext.PI_TARGET || tokenID == XMLDefaultTokenContext.PI_CONTENT || tokenID == XMLDefaultTokenContext.PI_END || bl && tokenID == XMLDefaultTokenContext.WS;
    }

    public SyntaxElement createElement(TokenItem tokenItem) throws BadLocationException {
        if (tokenItem == null) {
            return null;
        }
        TokenID tokenID = tokenItem.getTokenID();
        TokenItem tokenItem2 = tokenItem;
        int n = XMLSyntaxSupport.getTokenEnd(tokenItem);
        switch (tokenID.getNumericID()) {
            case 8: {
                while (tokenID == XMLDefaultTokenContext.BLOCK_COMMENT) {
                    n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                    if ((tokenItem = tokenItem.getNext()) == null) break;
                    tokenID = tokenItem.getTokenID();
                }
                return new CommentImpl(this, tokenItem2, n);
            }
            case 10: {
                boolean bl = false;
                while (tokenID == XMLDefaultTokenContext.DECLARATION || tokenID == XMLDefaultTokenContext.VALUE || bl) {
                    n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                    if (bl) {
                        if (tokenItem.getImage().endsWith("]>")) {
                            break;
                        }
                    } else if (tokenID == DECLARATION) {
                        bl = tokenItem.getImage().endsWith("[");
                    }
                    if ((tokenItem = tokenItem.getNext()) == null) break;
                    tokenID = tokenItem.getTokenID();
                }
                return new DocumentTypeImpl(this, tokenItem2, n);
            }
            case 3: {
                return new SyntaxElement.Error(this, tokenItem2, n);
            }
            case 1: 
            case 11: {
                while (tokenID == TEXT || tokenID == CHARACTER || tokenID == CDATA_SECTION) {
                    n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                    if ((tokenItem = tokenItem.getNext()) == null) break;
                    tokenID = tokenItem.getTokenID();
                }
                return new TextImpl(this, tokenItem2, n);
            }
            case 17: {
                return new CDATASectionImpl(this, tokenItem2, tokenItem2.getOffset() + tokenItem2.getImage().length());
            }
            case 4: {
                String string = tokenItem.getImage();
                if (string.startsWith("</")) {
                    String string2 = string.substring(2);
                    TokenID tokenID2 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
                    while (tokenID == XMLDefaultTokenContext.WS) {
                        n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                        tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
                    }
                    if (tokenID == XMLDefaultTokenContext.TAG && tokenItem.getImage().equals(">")) {
                        return new EndTag(this, tokenItem2, XMLSyntaxSupport.getTokenEnd(tokenItem), string2);
                    }
                    return new EndTag(this, tokenItem2, n, string2);
                }
                String string3 = string.substring(1);
                ArrayList<String> arrayList = new ArrayList<String>();
                TokenID tokenID3 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
                while (tokenID == XMLDefaultTokenContext.WS || tokenID == XMLDefaultTokenContext.ARGUMENT || tokenID == XMLDefaultTokenContext.OPERATOR || tokenID == XMLDefaultTokenContext.VALUE || tokenID == XMLDefaultTokenContext.CHARACTER) {
                    if (tokenID == XMLDefaultTokenContext.ARGUMENT) {
                        arrayList.add(tokenItem.getImage());
                    }
                    n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                    if ((tokenItem = tokenItem.getNext()) == null) break;
                    tokenID = tokenItem.getTokenID();
                }
                if (tokenID == XMLDefaultTokenContext.TAG && (tokenItem.getImage().equals("/>") || tokenItem.getImage().equals(">") || tokenItem.getImage().equals("?>"))) {
                    if (tokenItem.getImage().equals("/>")) {
                        return new EmptyTag(this, tokenItem2, XMLSyntaxSupport.getTokenEnd(tokenItem), string3, arrayList);
                    }
                    if (tokenItem.getImage().equals("?>")) {
                        return new EmptyTag(this, tokenItem2, XMLSyntaxSupport.getTokenEnd(tokenItem), string3, arrayList);
                    }
                    return new StartTag(this, tokenItem2, XMLSyntaxSupport.getTokenEnd(tokenItem), string3, arrayList);
                }
                return new StartTag(this, tokenItem2, n, string3, arrayList);
            }
            case 13: {
                do {
                    n = XMLSyntaxSupport.getTokenEnd(tokenItem);
                } while ((tokenItem = tokenItem.getNext()) != null && this.isInPI(tokenID = tokenItem.getTokenID(), true));
                return new ProcessingInstructionImpl(this, tokenItem2, n);
            }
        }
        throw new BadLocationException("Cannot create SyntaxElement at " + tokenItem, tokenItem.getOffset());
    }

    public String getEndTag(int n) throws BadLocationException {
        SyntaxElement syntaxElement = this.getElementChain(n);
        if (syntaxElement != null) {
            syntaxElement = syntaxElement.getPrevious();
        } else if (n > 0) {
            syntaxElement = this.getElementChain(n - 1);
        } else {
            return "";
        }
        int n2 = 0;
        while (syntaxElement != null) {
            block9: {
                block11: {
                    block10: {
                        if (syntaxElement instanceof EmptyTag) break block9;
                        if (!(syntaxElement instanceof StartTag)) break block10;
                        ++n2;
                        break block11;
                    }
                    if (!(syntaxElement instanceof EndTag)) break block9;
                    --n2;
                }
                if (n2 == 1) {
                    String string = ((StartTag)syntaxElement).getTagName();
                    return string;
                }
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return "";
    }

    public List getPreviousLevelTags(int n) throws BadLocationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Vector<String> vector = new Vector<String>();
        SyntaxElement syntaxElement = this.getElementChain(n);
        if (syntaxElement != null) {
            syntaxElement = syntaxElement.getPrevious();
        } else if (n > 0) {
            syntaxElement = this.getElementChain(n - 1);
        } else {
            return arrayList;
        }
        while (syntaxElement != null) {
            if (syntaxElement instanceof EndTag) {
                stack.push(((EndTag)syntaxElement).getTagName());
            } else if (syntaxElement instanceof EmptyTag) {
                if (stack.size() == 0) {
                    vector.add(((EmptyTag)syntaxElement).getTagName());
                }
            } else if (syntaxElement instanceof Tag) {
                String string = ((Tag)syntaxElement).getTagName();
                if (stack.empty()) {
                    arrayList.add(string);
                    for (int i = vector.size(); i > 0; --i) {
                        arrayList.add((String)vector.get(i - 1));
                    }
                    return arrayList;
                }
                if (stack.peek().equals(string)) {
                    if (stack.size() == 1) {
                        vector.add(string);
                    }
                    stack.pop();
                }
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        arrayList.clear();
        return arrayList;
    }

    public List getFollowingLevelTags(int n) throws BadLocationException {
        Stack<String> stack = new Stack<String>();
        Vector<String> vector = new Vector<String>();
        SyntaxElement syntaxElement = this.getElementChain(n);
        if (syntaxElement != null) {
            syntaxElement = syntaxElement.getNext();
        } else if (n > 0) {
            syntaxElement = this.getElementChain(n - 1);
        } else {
            return new ArrayList();
        }
        while (syntaxElement != null) {
            if (syntaxElement instanceof EmptyTag) {
                if (stack.size() == 0) {
                    vector.add(((EmptyTag)syntaxElement).getTagName());
                }
            } else if (syntaxElement instanceof Tag) {
                stack.push(((Tag)syntaxElement).getTagName());
            } else if (syntaxElement instanceof EndTag) {
                String string = ((EndTag)syntaxElement).getTagName();
                if (stack.empty()) {
                    return vector;
                }
                if (stack.peek().equals(string)) {
                    if (stack.size() == 1) {
                        vector.add(string);
                    }
                    stack.pop();
                }
            }
            syntaxElement = syntaxElement.getNext();
        }
        vector.clear();
        return vector;
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        this.requestedAutoCompletion = false;
        if (!bl) {
            int n = 1;
            switch (string.charAt(string.length() - 1)) {
                case '/': {
                    int n2 = jTextComponent.getCaret().getDot();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (n2 < 2) break;
                    try {
                        String string2 = baseDocument.getText(n2 - 2, 2);
                        if (!string2.equals("</")) break;
                        n = 0;
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                    break;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    n = 0;
                }
            }
            if (n == 0) {
                this.requestedAutoCompletion = true;
            }
            return n;
        }
        switch (string.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }

    public boolean requestedAutoCompletion() {
        return this.requestedAutoCompletion;
    }

    static int getTokenEnd(TokenItem tokenItem) {
        return tokenItem.getOffset() + tokenItem.getImage().length();
    }

    public final char lastTypedChar() {
        return this.lastInsertedChar;
    }

    public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        block46: {
            Object object;
            TokenItem tokenItem;
            TokenItem tokenItem2 = tokenItem = this.getTokenChain(n, n + 1);
            if (tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().endsWith(">")) {
                tokenItem = tokenItem.getPrevious();
            }
            if (tokenItem2 == null) {
                return null;
            }
            if (tokenItem2.getTokenID() == XMLTokenIDs.DECLARATION) {
                TokenItem tokenItem3;
                String string = tokenItem2.getImage();
                if (string.startsWith("<!")) {
                    tokenItem3 = tokenItem2;
                    while ((tokenItem3 = tokenItem3.getNext()) != null && tokenItem3.getTokenID() != XMLTokenIDs.DECLARATION) {
                    }
                    if (tokenItem3 != null && tokenItem3.getTokenID() == XMLTokenIDs.DECLARATION && tokenItem3.getImage().endsWith(">")) {
                        int n2 = tokenItem3.getOffset();
                        int n3 = tokenItem3.getOffset() + tokenItem3.getImage().length();
                        return new int[]{n2, n3};
                    }
                }
                if (string.endsWith(">") && n >= tokenItem2.getOffset() + tokenItem2.getImage().length() - ">".length()) {
                    tokenItem3 = tokenItem2;
                    while ((tokenItem3 = tokenItem3.getPrevious()) != null && tokenItem3.getTokenID() != XMLTokenIDs.DECLARATION) {
                    }
                    if (tokenItem3 != null && tokenItem3.getTokenID() == XMLTokenIDs.DECLARATION && tokenItem3.getImage().startsWith("<!")) {
                        int n4 = tokenItem3.getOffset();
                        int n5 = tokenItem3.getOffset() + "<!".length();
                        return new int[]{n4, n5};
                    }
                }
                return null;
            }
            if (tokenItem2.getTokenID() == XMLTokenIDs.PI_START || tokenItem2.getTokenID() == XMLTokenIDs.PI_TARGET) {
                object = tokenItem2;
                while ((object = object.getNext()) != null && object.getTokenID() != XMLTokenIDs.PI_END) {
                }
                if (object != null && object.getTokenID() == XMLTokenIDs.PI_END) {
                    int n6 = object.getOffset();
                    int n7 = object.getOffset() + object.getImage().length();
                    return new int[]{n6, n7};
                }
            } else if (tokenItem2.getTokenID() == XMLTokenIDs.PI_END) {
                object = tokenItem2;
                while ((object = object.getPrevious()) != null && object.getTokenID() != XMLTokenIDs.PI_START) {
                }
                if (object != null && object.getTokenID() == XMLTokenIDs.PI_START) {
                    int n8 = object.getOffset();
                    int n9 = object.getOffset() + object.getImage().length() + object.getNext().getImage().length();
                    return new int[]{n8, n9};
                }
            }
            if (tokenItem2.getTokenID() == XMLTokenIDs.CDATA_SECTION) {
                object = tokenItem2.getImage();
                TokenItem tokenItem4 = tokenItem2;
                if (((String)object).startsWith(CDATA_START) && n < tokenItem2.getOffset() + CDATA_START.length()) {
                    int n10 = tokenItem4.getOffset() + tokenItem4.getImage().length() - CDATA_END.length();
                    int n11 = tokenItem4.getOffset() + tokenItem4.getImage().length();
                    return new int[]{n10, n11};
                }
                if (((String)object).endsWith(CDATA_END) && n >= tokenItem2.getOffset() + tokenItem2.getImage().length() - CDATA_END.length()) {
                    int n12 = tokenItem4.getOffset();
                    int n13 = tokenItem4.getOffset() + CDATA_START.length();
                    return new int[]{n12, n13};
                }
                return null;
            }
            if (tokenItem2.getTokenID() == XMLTokenIDs.BLOCK_COMMENT) {
                TokenItem tokenItem5;
                object = tokenItem2.getImage();
                if (((String)object).startsWith("<!--") && n < tokenItem2.getOffset() + "<!--".length()) {
                    for (tokenItem5 = tokenItem2; tokenItem5 != null && tokenItem5.getTokenID() == XMLTokenIDs.BLOCK_COMMENT; tokenItem5 = tokenItem5.getNext()) {
                        if (!tokenItem5.getImage().endsWith("-->")) continue;
                        int n14 = tokenItem5.getOffset() + tokenItem5.getImage().length() - "-->".length();
                        int n15 = tokenItem5.getOffset() + tokenItem5.getImage().length();
                        return new int[]{n14, n15};
                    }
                }
                if (((String)object).endsWith("-->") && n >= tokenItem2.getOffset() + tokenItem2.getImage().length() - "-->".length()) {
                    while (tokenItem5 != null && tokenItem5.getTokenID() == XMLTokenIDs.BLOCK_COMMENT) {
                        if (tokenItem5.getImage().startsWith("<!--")) {
                            int n16 = tokenItem5.getOffset();
                            int n17 = tokenItem5.getOffset() + "<!--".length();
                            return new int[]{n16, n17};
                        }
                        tokenItem5 = tokenItem5.getPrevious();
                    }
                }
                return null;
            }
            boolean bl2 = false;
            if (tokenItem != null) {
                if (tokenItem.getImage().startsWith("<")) {
                    bl2 = true;
                } else {
                    while (tokenItem != null && tokenItem.getTokenID() != XMLTokenIDs.TAG && !tokenItem.getImage().startsWith("<")) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith("<")) {
                        bl2 = true;
                    }
                }
            }
            if (tokenItem == null || !bl2) break block46;
            int n18 = -1;
            if (tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith("</")) {
                String string = tokenItem.getImage().substring(2).trim().toLowerCase();
                while (tokenItem != null) {
                    if (tokenItem.getTokenID() == XMLTokenIDs.TAG && !">".equals(tokenItem.getImage())) {
                        if (tokenItem.getImage().substring(1).trim().toLowerCase().equals(string) && !this.isSingletonTag(tokenItem)) {
                            if (n18 == 0) {
                                int n19 = tokenItem.getOffset();
                                int n20 = tokenItem.getOffset() + tokenItem.getImage().length();
                                TokenItem tokenItem6 = tokenItem.getNext();
                                if (tokenItem6 == null || tokenItem6.getTokenID() != XMLTokenIDs.TAG || ">".equals(tokenItem6.getImage())) {
                                    // empty if block
                                }
                                return new int[]{n19, ++n20};
                            }
                            --n18;
                        } else if (tokenItem.getImage().substring(2).toLowerCase().indexOf(string) > -1 && !this.isSingletonTag(tokenItem)) {
                            ++n18;
                        }
                    }
                    tokenItem = tokenItem.getPrevious();
                }
            } else {
                if (this.isSingletonTag(tokenItem)) {
                    return null;
                }
                String string = tokenItem.getImage().substring(1).toLowerCase();
                while (tokenItem != null) {
                    if (tokenItem.getTokenID() == XMLTokenIDs.TAG && !">".equals(tokenItem.getImage())) {
                        if (tokenItem.getImage().substring(2).trim().toLowerCase().equals(string)) {
                            if (n18 == 0) {
                                int n21 = tokenItem.getOffset();
                                int n22 = tokenItem.getOffset() + tokenItem.getImage().length() + 1;
                                return new int[]{n21, n22};
                            }
                            --n18;
                        } else if (tokenItem.getImage().substring(1).toLowerCase().equals(string) && !this.isSingletonTag(tokenItem)) {
                            ++n18;
                        }
                    }
                    tokenItem = tokenItem.getNext();
                }
            }
        }
        return null;
    }

    public boolean isSingletonTag(TokenItem tokenItem) {
        for (TokenItem tokenItem2 = tokenItem; tokenItem2 != null; tokenItem2 = tokenItem2.getNext()) {
            if (tokenItem2.getTokenID() == XMLTokenIDs.TAG) {
                if ("/>".equals(tokenItem2.getImage())) {
                    return true;
                }
                if (">".equals(tokenItem2.getImage())) {
                    return false;
                }
            }
            if (tokenItem2.getTokenID() == XMLTokenIDs.TEXT) break;
        }
        return false;
    }

    private class DocumentMonitor
    implements DocumentListener {
        private DocumentMonitor() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            try {
                String string = documentEvent.getDocument().getText(n + n2 - 1, 1);
                XMLSyntaxSupport.this.lastInsertedChar = string.charAt(0);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify((Throwable)badLocationException);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }
    }
}

