/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;

public class TreeModelRoot
implements ModelListener {
    static final long serialVersionUID = -1259352660663524178L;
    private Models.CompoundModel model;
    private TreeModelNode rootNode;
    private WeakHashMap objectToNode = new WeakHashMap();
    private TreeTable treeTable;
    private TreeModelNode.LazyEvaluator childrenEvaluator;
    private TreeModelNode.LazyEvaluator valuesEvaluator;

    public TreeModelRoot(Models.CompoundModel compoundModel, TreeTable treeTable) {
        this.model = compoundModel;
        this.treeTable = treeTable;
        compoundModel.addModelListener(this);
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }

    public TreeModelNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new TreeModelNode(this.model, this, this.model.getRoot());
        }
        return this.rootNode;
    }

    void registerNode(Object object, TreeModelNode treeModelNode) {
        this.objectToNode.put(object, new WeakReference<TreeModelNode>(treeModelNode));
    }

    TreeModelNode findNode(Object object) {
        WeakReference weakReference = (WeakReference)this.objectToNode.get(object);
        if (weakReference == null) {
            return null;
        }
        return (TreeModelNode)((Object)weakReference.get());
    }

    public void modelChanged(final ModelEvent modelEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelNode treeModelNode;
                ModelEvent modelEvent2;
                Object object;
                if (TreeModelRoot.this.model == null) {
                    return;
                }
                if (modelEvent instanceof ModelEvent.TableValueChanged && (object = ((ModelEvent.TableValueChanged)(modelEvent2 = (ModelEvent.TableValueChanged)modelEvent)).getNode()) != null && (treeModelNode = TreeModelRoot.this.findNode(object)) != null) {
                    String string = ((ModelEvent.TableValueChanged)modelEvent2).getColumnID();
                    if (string != null) {
                        treeModelNode.refreshColumn(string);
                    } else {
                        treeModelNode.refresh();
                    }
                    return;
                }
                if (modelEvent instanceof ModelEvent.NodeChanged && (object = ((ModelEvent.NodeChanged)(modelEvent2 = (ModelEvent.NodeChanged)modelEvent)).getNode()) != null && (treeModelNode = TreeModelRoot.this.findNode(object)) != null) {
                    treeModelNode.refresh(((ModelEvent.NodeChanged)modelEvent2).getChange());
                    return;
                }
                TreeModelRoot.this.rootNode.setObject(TreeModelRoot.this.model.getRoot());
            }
        });
    }

    synchronized TreeModelNode.LazyEvaluator getChildrenEvaluator() {
        if (this.childrenEvaluator == null) {
            this.childrenEvaluator = new TreeModelNode.LazyEvaluator();
        }
        return this.childrenEvaluator;
    }

    synchronized TreeModelNode.LazyEvaluator getValuesEvaluator() {
        if (this.valuesEvaluator == null) {
            this.valuesEvaluator = new TreeModelNode.LazyEvaluator();
        }
        return this.valuesEvaluator;
    }

    public void destroy() {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = null;
        this.objectToNode = new WeakHashMap();
    }
}

