/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.applet.AppletSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassWarning;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class J2SEActionProvider
implements ActionProvider {
    private static final String[] supportedActions;
    private static final String[] platformSensitiveActions;
    J2SEProject project;
    private UpdateHelper updateHelper;
    Map commands = new HashMap();
    final Set bkgScanSensitiveActions;
    private static final Pattern SRCDIRJAVA;
    private static final String SUBST = "Test.java";
    static final /* synthetic */ boolean $assertionsDisabled;

    public J2SEActionProvider(J2SEProject j2SEProject, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"jar"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "jar"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
        this.updateHelper = updateHelper;
        this.project = j2SEProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Properties properties = new Properties();
                String[] stringArray = J2SEActionProvider.this.getTargetNames(string, lookup, properties);
                if (stringArray == null) {
                    return;
                }
                if (stringArray.length == 0) {
                    stringArray = null;
                }
                if (properties.keySet().size() == 0) {
                    properties = null;
                }
                try {
                    FileObject fileObject = J2SEActionProvider.this.findBuildXml();
                    if (fileObject == null || !fileObject.isValid()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$J2SEActionProvider == null ? (class$org$netbeans$modules$java$j2seproject$J2SEActionProvider = J2SEActionProvider.class$("org.netbeans.modules.java.j2seproject.J2SEActionProvider")) : class$org$netbeans$modules$java$j2seproject$J2SEActionProvider), (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    } else {
                        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
        if (this.bkgScanSensitiveActions.contains(string)) {
            JMManager.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)J2SEActionProvider.class, (String)("ACTION_" + string)));
        } else {
            runnable.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String string2;
        String[] stringArray;
        if (Arrays.asList(platformSensitiveActions).contains(string) && J2SEProjectUtil.getActivePlatform((String)(stringArray = this.project.evaluator().getProperty("platform.active"))) == null) {
            this.showPlatformWarning();
            return null;
        }
        stringArray = new String[]{};
        if (string.equals("compile.single")) {
            boolean bl;
            FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
            FileObject[] fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray);
            boolean bl2 = bl = lookup.lookup(NonRecursiveFolder.class) == null;
            if (fileObjectArray2 != null) {
                properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray2, (FileObject)this.getRoot(fileObjectArray, fileObjectArray2[0]), (boolean)bl));
                return new String[]{"compile-single"};
            }
            FileObject[] fileObjectArray3 = this.project.getTestSourceRoots().getRoots();
            fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray3);
            properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray2, (FileObject)this.getRoot(fileObjectArray3, fileObjectArray2[0]), (boolean)bl));
            return new String[]{"compile-test-single"};
        }
        if (string.equals("test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            return this.setupTestSingle(properties, fileObjectArray);
        }
        if (string.equals("debug.test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            return this.setupDebugTestSingle(properties, fileObjectArray);
        }
        if (string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            string2 = null;
            if (fileObjectArray != null) {
                string2 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), fileObjectArray[0]), (FileObject)fileObjectArray[0]);
                stringArray = new String[]{"debug-fix"};
            } else {
                fileObjectArray = this.findTestSources(lookup, false);
                string2 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getTestSourceRoots().getRoots(), fileObjectArray[0]), (FileObject)fileObjectArray[0]);
                stringArray = new String[]{"debug-fix-test"};
            }
            if (string2.endsWith(".java")) {
                string2 = string2.substring(0, string2.length() - 5);
            }
        } else {
            if (string.equals("run") || string.equals("debug") || string.equals("debug.stepinto")) {
                EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
                String string3 = (String)editableProperties.get((Object)"main.class");
                int n = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string3);
                if (n != 0) {
                    do {
                        if (this.showMainClassWarning(string3, ProjectUtils.getInformation((Project)this.project).getDisplayName(), editableProperties, n)) {
                            return null;
                        }
                        string3 = (String)editableProperties.get((Object)"main.class");
                    } while ((n = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string3)) != 0);
                    try {
                        if (!this.updateHelper.requestSave()) return null;
                        this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().log(1, "Error while saving project: " + iOException);
                    }
                }
                if (!string.equals("run")) {
                    properties.setProperty("debug.class", string3);
                }
                if ((stringArray = (String[])this.commands.get(string)) != null) return stringArray;
                throw new IllegalArgumentException(string);
            }
            if (string.equals("run.single") || string.equals("debug.single")) {
                FileObject[] fileObjectArray = this.findTestSources(lookup, false);
                if (fileObjectArray != null) {
                    if (!string.equals("run.single")) return this.setupDebugTestSingle(properties, fileObjectArray);
                    return this.setupTestSingle(properties, fileObjectArray);
                }
                FileObject fileObject = this.findSources(lookup)[0];
                String string4 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), fileObject), (FileObject)fileObject);
                properties.setProperty("javac.includes", string4);
                if (string4.endsWith(".java")) {
                    string4 = string4.substring(0, string4.length() - 5);
                }
                string4 = string4.replace('/', '.');
                if (!J2SEProjectUtil.hasMainMethod(fileObject)) {
                    if (AppletSupport.isApplet(fileObject)) {
                        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
                        String string5 = editableProperties.getProperty("run.jvmargs");
                        URL uRL = null;
                        if (string5 == null || string5.indexOf("java.security.policy") <= 0) {
                            AppletSupport.generateSecurityPolicy(this.project.getProjectDirectory());
                            if (string5 == null || string5.length() == 0) {
                                editableProperties.setProperty("run.jvmargs", "-Djava.security.policy=applet.policy");
                            } else {
                                editableProperties.setProperty("run.jvmargs", string5 + " -Djava.security.policy=applet.policy");
                            }
                            this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
                            try {
                                ProjectManager.getDefault().saveProject((Project)this.project);
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().log(1, "Error while saving project: " + exception);
                            }
                        }
                        if ((uRL = fileObject.existsExt("html") || fileObject.existsExt("HTML") ? this.copyAppletHTML(fileObject, "html") : this.generateAppletHTML(fileObject)) == null) {
                            return null;
                        }
                        properties.setProperty("applet.url", uRL.toString());
                        if (string.equals("run.single")) {
                            return new String[]{"run-applet"};
                        }
                        properties.setProperty("debug.class", string4);
                        return new String[]{"debug-applet"};
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"LBL_No_Main_Classs_Found", (Object)string4), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return null;
                }
                if (string.equals("run.single")) {
                    properties.setProperty("run.class", string4);
                    return (String[])this.commands.get("run.single");
                }
                properties.setProperty("debug.class", string4);
                return (String[])this.commands.get("debug.single");
            }
            stringArray = (String[])this.commands.get(string);
            if (stringArray != null) return stringArray;
            throw new IllegalArgumentException(string);
        }
        properties.setProperty("fix.includes", string2);
        return stringArray;
    }

    private String[] setupTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        properties.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObjectArray[0]);
        properties.setProperty("test.class", string.substring(0, string.length() - 5).replace('/', '.'));
        return new String[]{"debug-test"};
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        FileObject fileObject = this.findBuildXml();
        if (fileObject == null || !fileObject.isValid()) {
            return false;
        }
        if (string.equals("compile.single")) {
            return this.findSourcesAndPackages(lookup, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(lookup, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (string.equals("test.single")) {
            return this.findTestSourcesForSources(lookup) != null;
        }
        if (string.equals("debug.test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        if (string.equals("run.single") || string.equals("debug.single") || string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1) {
                return true;
            }
            fileObjectArray = this.findTestSources(lookup, false);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        return true;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray[i], (String)".java", (boolean)true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup lookup, FileObject fileObject) {
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, null, (boolean)true);
            if (fileObjectArray != null) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (fileObjectArray[i].isFolder() || "java".equals(fileObjectArray[i].getExt())) continue;
                    return null;
                }
            }
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup lookup, FileObject[] fileObjectArray) {
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray[i]);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup lookup, boolean bl) {
        FileObject[] fileObjectArray;
        FileObject fileObject;
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray2.length; ++i) {
            fileObject = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray2[i], (String)".java", (boolean)true);
            if (fileObject == null) continue;
            return fileObject;
        }
        if (bl && fileObjectArray2.length > 0 && (fileObjectArray = this.findSources(lookup)) != null) {
            fileObject = this.getRoot(this.project.getSourceRoots().getRoots(), fileObjectArray[0]);
            for (int i = 0; i < fileObjectArray2.length; ++i) {
                FileObject[] fileObjectArray3 = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)fileObjectArray2[i], (String)SUBST, (boolean)true);
                if (fileObjectArray3 == null) continue;
                return fileObjectArray3;
            }
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray == null) {
            return null;
        }
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        if (fileObjectArray2.length == 0) {
            return null;
        }
        FileObject[] fileObjectArray3 = this.project.getSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray3, fileObjectArray[0]);
        for (int i = 0; i < fileObjectArray2.length; ++i) {
            FileObject[] fileObjectArray4 = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)fileObjectArray2[i], (String)SUBST, (boolean)true);
            if (fileObjectArray4 == null) continue;
            return fileObjectArray4;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] fileObjectArray, FileObject fileObject) {
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)"File can't be null");
        }
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!$assertionsDisabled && fileObjectArray[i] == null) {
                throw new AssertionError((Object)"Source Path Root can't be null");
            }
            if (!FileUtil.isParentOf((FileObject)fileObjectArray[i], (FileObject)fileObject) && !fileObjectArray[i].equals(fileObject)) continue;
            fileObject2 = fileObjectArray[i];
            break;
        }
        return fileObject2;
    }

    private int isSetMainClass(FileObject[] fileObjectArray, String string) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? 0 : -2;
        }
        if (string == null || string.length() == 0) {
            return -1;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/execute");
        if (J2SEProjectUtil.isMainClass(string, classPath)) {
            return 0;
        }
        return -2;
    }

    public static boolean canBeRun(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Node.Cookie cookie = dataObject.getCookie(SourceCookie.class);
            if (cookie == null || !(cookie instanceof SourceCookie)) {
                return false;
            }
            SourceCookie sourceCookie = (SourceCookie)cookie;
            SourceElement sourceElement = sourceCookie.getSource();
            ClassElement[] classElementArray = sourceElement.getClasses();
            boolean bl = false;
            for (int i = 0; i < classElementArray.length; ++i) {
                if (!classElementArray[i].hasMainMethod()) continue;
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean showMainClassWarning(String string, String string2, EditableProperties editableProperties, int n) {
        boolean bl;
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MainClassWarning.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (n) {
            case -1: {
                string3 = MessageFormat.format(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassNotFound"), string2);
                break;
            }
            case -2: {
                string3 = MessageFormat.format(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassWrong"), string, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning mainClassWarning = new MainClassWarning(string3, this.project.getSourceRoots().getRoots());
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        mainClassWarning.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    jButton.doClick();
                } else {
                    jButton.setEnabled(mainClassWarning.getSelectedMainClass() != null);
                }
            }
        });
        jButton.setEnabled(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassWarning, NbBundle.getMessage((Class)MainClassWarning.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            string = mainClassWarning.getSelectedMainClass();
            bl = false;
            editableProperties.put((Object)"main.class", (Object)(string == null ? "" : string));
        }
        dialog.dispose();
        return bl;
    }

    private void showPlatformWarning() {
        JButton jButton = new JButton(NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"CTL_BrokenPlatform_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"AD_BrokenPlatform_Close"));
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation == null ? NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"TEXT_BrokenPlatform_UnknownProjectName") : projectInformation.getDisplayName();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"TEXT_BrokenPlatform", (Object)string), NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"MSG_BrokenPlatform_Title"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
        dialogDescriptor.setMessageType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private URL generateAppletHTML(FileObject fileObject) {
        URL uRL = null;
        try {
            String string = this.project.evaluator().getProperty("build.dir");
            String string2 = this.project.evaluator().getProperty("build.classes.dir");
            FileObject fileObject2 = this.updateHelper.getAntProjectHelper().resolveFileObject(string);
            FileObject fileObject3 = this.updateHelper.getAntProjectHelper().resolveFileObject(string2);
            if (fileObject2 == null) {
                fileObject2 = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)string);
            }
            if (fileObject3 == null) {
                fileObject3 = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)string2);
            }
            String string3 = this.project.evaluator().getProperty("platform.active");
            uRL = AppletSupport.generateHtmlFileURL(fileObject, fileObject2, fileObject3, string3);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return uRL;
    }

    private URL copyAppletHTML(FileObject fileObject, String string) {
        URL uRL = null;
        try {
            FileObject fileObject2;
            String string2 = this.project.evaluator().getProperty("build.dir");
            FileObject fileObject3 = this.updateHelper.getAntProjectHelper().resolveFileObject(string2);
            if (fileObject3 == null) {
                fileObject3 = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)string2);
            }
            FileObject fileObject4 = null;
            fileObject4 = fileObject.getParent().getFileObject(fileObject.getName(), "html");
            if (fileObject4 == null) {
                fileObject4 = fileObject.getParent().getFileObject(fileObject.getName(), "HTML");
            }
            if (fileObject4 == null) {
                return null;
            }
            FileObject fileObject5 = fileObject3.getFileObject(fileObject4.getName(), fileObject4.getExt());
            if (fileObject5 != null) {
                fileObject5.delete();
            }
            if ((fileObject2 = fileObject4.copy(fileObject3, fileObject.getName(), string)) != null) {
                String string3 = this.project.evaluator().getProperty("platform.active");
                uRL = AppletSupport.getHTMLPageURL(fileObject2, string3);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return uRL;
    }

    static {
        $assertionsDisabled = !J2SEActionProvider.class.desiredAssertionStatus();
        supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto", "delete", "copy", "move", "rename"};
        platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto"};
        SRCDIRJAVA = Pattern.compile("\\.java$");
    }
}

