/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = "rootProperties";
    public static final String PROP_ROOTS = "roots";
    public static final String DEFAULT_SOURCE_LABEL;
    public static final String DEFAULT_TEST_LABEL;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String elementName;
    private final String newRootNameTemplate;
    private List sourceRootProperties;
    private List sourceRootNames;
    private List sourceRoots;
    private List sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;
    static final /* synthetic */ boolean $assertionsDisabled;

    SourceRoots(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, String string, boolean bl, String string2) {
        if (!($assertionsDisabled || updateHelper != null && propertyEvaluator != null && referenceHelper != null && string != null && string2 != null)) {
            throw new AssertionError();
        }
        this.helper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.elementName = string;
        this.isTest = bl;
        this.newRootNameTemplate = string2;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getAntProjectHelper().addAntProjectListener((AntProjectListener)WeakListeners.create((Class)AntProjectListener.class, (EventListener)this.listener, (Object)this.helper));
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            FileObject fileObject;
                            String string = SourceRoots.this.evaluator.getProperty(stringArray[i]);
                            if (string == null || (fileObject = SourceRoots.this.helper.getAntProjectHelper().resolveFileObject(string)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                            }
                            arrayList.add(fileObject);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = SourceRoots.this.evaluator.getProperty(stringArray[i]);
                            if (string == null) continue;
                            File file = SourceRoots.this.helper.getAntProjectHelper().resolveFile(string);
                            try {
                                URL uRL = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL = new URL(uRL.toExternalForm() + "/");
                                }
                                arrayList.add(uRL);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void putRoots(final URL[] uRLArray, final String[] stringArray) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object run() {
                Object object;
                Object object2;
                String[] stringArray3 = SourceRoots.this.getRootProperties();
                URL[] uRLArray2 = SourceRoots.this.getRootURLs();
                HashMap<URL, String> hashMap = new HashMap<URL, String>();
                for (int i = 0; i < stringArray3.length; ++i) {
                    hashMap.put(uRLArray2[i], stringArray3[i]);
                }
                HashMap<URL, String> hashMap2 = new HashMap<URL, String>();
                for (int i = 0; i < uRLArray.length; ++i) {
                    hashMap2.put(uRLArray[i], stringArray[i]);
                }
                Element element = SourceRoots.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", SourceRoots.this.elementName);
                if (!$assertionsDisabled && nodeList.getLength() != 1) {
                    throw new AssertionError((Object)"Illegal project.xml");
                }
                Element element2 = (Element)nodeList.item(0);
                NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                while (nodeList2.getLength() > 0) {
                    object2 = (Element)nodeList2.item(0);
                    element2.removeChild((Node)object2);
                }
                object2 = Arrays.asList(uRLArray);
                HashMap hashMap3 = new HashMap(hashMap);
                hashMap3.keySet().removeAll((Collection<?>)object2);
                EditableProperties editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                Object object3 = hashMap3.values().iterator();
                while (object3.hasNext()) {
                    object = (String)object3.next();
                    editableProperties.remove(object);
                }
                SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                object3 = element2.getOwnerDocument();
                hashMap.keySet().retainAll((Collection<?>)object2);
                object = object2.iterator();
                while (object.hasNext()) {
                    String[] stringArray2;
                    URL uRL = (URL)object.next();
                    String string = (String)hashMap.get(uRL);
                    if (string == null) {
                        String string2;
                        editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        stringArray2 = uRL.getPath().split("/");
                        string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], "");
                        int n = 1;
                        while (editableProperties.containsKey((Object)string)) {
                            string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], new Integer(++n));
                        }
                        File file = FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
                        File file2 = FileUtil.toFile((FileObject)SourceRoots.this.helper.getAntProjectHelper().getProjectDirectory());
                        String string3 = file.getAbsolutePath();
                        if (string3.startsWith(string2 = file2.getAbsolutePath() + File.separatorChar)) {
                            string3 = string3.substring(string2.length());
                        } else {
                            string3 = SourceRoots.this.refHelper.createForeignFileReference(file, "java");
                            editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        }
                        editableProperties.put((Object)string, (Object)string3);
                        SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    stringArray2 = object3.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                    stringArray2.setAttribute("id", string);
                    String string4 = (String)hashMap2.get(uRL);
                    if (string4 != null && string4.length() > 0 && !string4.equals(SourceRoots.this.getRootDisplayName(null, string))) {
                        stringArray2.setAttribute("name", string4);
                    }
                    element2.appendChild((Node)stringArray2);
                }
                SourceRoots.this.helper.putPrimaryConfigurationData(element, true);
                return null;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$SourceRoots == null ? (class$org$netbeans$modules$java$j2seproject$SourceRoots = SourceRoots.class$("org.netbeans.modules.java.j2seproject.SourceRoots")) : class$org$netbeans$modules$java$j2seproject$SourceRoots).desiredAssertionStatus();
            }
        });
    }

    public String getRootDisplayName(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (this.isTest && "test.src.dir".equals(string2)) {
                string = DEFAULT_TEST_LABEL;
            } else if (!this.isTest && "src.dir".equals(string2)) {
                string = DEFAULT_SOURCE_LABEL;
            } else {
                String string3 = this.evaluator.getProperty(string2);
                File file = string3 == null ? null : this.helper.getAntProjectHelper().resolveFile(string3);
                string = this.createInitialDisplayName(file);
            }
        }
        return string;
    }

    public String createInitialDisplayName(File file) {
        String string;
        String string2;
        String string3 = file != null ? ((string2 = file.getAbsolutePath()).startsWith(string = this.projectDir.getAbsolutePath() + File.separatorChar) ? string2.substring(string.length()) : file.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return string3;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean bl, String string) {
        boolean bl2 = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (bl) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            } else if (string == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(string)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private void readProjectMetadata() {
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", this.elementName);
        if (!$assertionsDisabled && nodeList.getLength() != 0 && nodeList.getLength() != 1) {
            throw new AssertionError((Object)"Illegal project.xml");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (nodeList.getLength() == 1) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = element2.getAttribute("id");
                if (!$assertionsDisabled && string.length() <= 0) {
                    throw new AssertionError((Object)"Illegal project.xml");
                }
                arrayList.add(string);
                string = element2.getAttribute("name");
                arrayList2.add(string);
            }
        }
        this.sourceRootProperties = Collections.unmodifiableList(arrayList);
        this.sourceRootNames = Collections.unmodifiableList(arrayList2);
    }

    static {
        $assertionsDisabled = !SourceRoots.class.desiredAssertionStatus();
        DEFAULT_SOURCE_LABEL = NbBundle.getMessage((Class)SourceRoots.class, (String)"NAME_src.dir");
        DEFAULT_TEST_LABEL = NbBundle.getMessage((Class)SourceRoots.class, (String)"NAME_test.src.dir");
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    AntProjectListener {
        private ProjectMetadataListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourceRoots.this.resetCache(false, propertyChangeEvent.getPropertyName());
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }
    }
}

