/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE;
    private static final String BUILD_NUMBER;
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    static final /* synthetic */ boolean $assertionsDisabled;

    UpdateHelper(Project project, AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration, GeneratedFilesHelper generatedFilesHelper, Notifier notifier) {
        if (!($assertionsDisabled || project != null && antProjectHelper != null && auxiliaryConfiguration != null && generatedFilesHelper != null && notifier != null)) {
            throw new AssertionError();
        }
        this.project = project;
        this.helper = antProjectHelper;
        this.cfg = auxiliaryConfiguration;
        this.genFileHelper = generatedFilesHelper;
        this.notifier = notifier;
    }

    public EditableProperties getProperties(final String string) {
        return (EditableProperties)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(string)) {
                    return UpdateHelper.this.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(string);
            }
        });
    }

    public void putProperties(final String string, final EditableProperties editableProperties) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(string)) {
                    UpdateHelper.this.helper.putProperties(string, editableProperties);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putProperties(string, editableProperties);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean bl) {
        return (Element)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(bl);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean bl) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate();
        return true;
    }

    public synchronized boolean isCurrent() {
        if (this.isCurrent == null) {
            this.isCurrent = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true) != null || this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true) != null ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.isCurrent;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean bl = this.notifier.canUpdate();
        if (!bl) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate() throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateHelper updateHelper = this;
        synchronized (updateHelper) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            Element element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
            if (element != null) {
                Document document = element.getOwnerDocument();
                Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                UpdateHelper.copyDocument(document, element, element2);
                Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                Element element4 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                element4.setAttribute("id", "src.dir");
                element3.appendChild(element4);
                element2.appendChild(element3);
                Element element5 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                element4 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                element4.setAttribute("id", "test.src.dir");
                element5.appendChild(element4);
                element2.appendChild(element5);
                this.cachedElement = UpdateHelper.updateMinAntVersion(element2, document);
            } else {
                element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
                if (element != null) {
                    Document document = element.getOwnerDocument();
                    Element element6 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                    UpdateHelper.copyDocument(document, element, element6);
                    this.cachedElement = UpdateHelper.updateMinAntVersion(element6, document);
                }
            }
        }
        return this.cachedElement;
    }

    private synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        if (editableProperties.get((Object)"javadoc.additionalparam") == null) {
            editableProperties.put((Object)"javadoc.additionalparam", (Object)"");
        }
        if (editableProperties.get((Object)"build.generated.dir") == null) {
            editableProperties.put((Object)"build.generated.dir", (Object)"${build.dir}/generated");
        }
        if (editableProperties.get((Object)"meta.inf.dir") == null) {
            editableProperties.put((Object)"meta.inf.dir", (Object)"${src.dir}/META-INF");
        }
        return editableProperties;
    }

    private static void copyDocument(Document document, Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            switch (node.getNodeType()) {
                case 1: {
                    Node node3;
                    Element element3 = (Element)node;
                    node2 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    Element element4 = (Element)node2;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        node3 = namedNodeMap.item(j);
                        element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    UpdateHelper.copyDocument(document, element3, element4);
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    node2 = document.createTextNode(text.getData());
                    break;
                }
                case 8: {
                    Node node3 = (Comment)node;
                    node2 = document.createComment(node3.getData());
                }
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    private static Element updateMinAntVersion(Element element, Document document) {
        Element element2;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", MINIMUM_ANT_VERSION_ELEMENT);
        if (nodeList.getLength() == 1 && (nodeList = (element2 = (Element)nodeList.item(0)).getChildNodes()).getLength() == 1) {
            element2.replaceChild(document.createTextNode("1.6.5"), nodeList.item(0));
            return element;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Invalid project file");
        }
        return element;
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            public boolean canUpdate() {
                JButton jButton = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$UpdateHelper == null ? (class$org$netbeans$modules$java$j2seproject$UpdateHelper = UpdateHelper.class$("org.netbeans.modules.java.j2seproject.UpdateHelper")) : class$org$netbeans$modules$java$j2seproject$UpdateHelper), (String)"CTL_UpdateOption"));
                jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$UpdateHelper == null ? (class$org$netbeans$modules$java$j2seproject$UpdateHelper = UpdateHelper.class$("org.netbeans.modules.java.j2seproject.UpdateHelper")) : class$org$netbeans$modules$java$j2seproject$UpdateHelper), (String)"AD_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$UpdateHelper == null ? (class$org$netbeans$modules$java$j2seproject$UpdateHelper = UpdateHelper.class$("org.netbeans.modules.java.j2seproject.UpdateHelper")) : class$org$netbeans$modules$java$j2seproject$UpdateHelper), (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$UpdateHelper == null ? (class$org$netbeans$modules$java$j2seproject$UpdateHelper = UpdateHelper.class$("org.netbeans.modules.java.j2seproject.UpdateHelper")) : class$org$netbeans$modules$java$j2seproject$UpdateHelper), (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
            }
        };
    }

    static {
        $assertionsDisabled = !UpdateHelper.class.desiredAssertionStatus();
        TRANSPARENT_UPDATE = Boolean.getBoolean("j2seproject.transparentUpdate");
        BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

